/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity.corporea;

import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.CorporeaRequestMatcher;
import vazkii.botania.api.corporea.CorporeaRequestor;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;

import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3695;
import net.minecraft.class_4587;

public class CorporeaCrystalCubeBlockEntity extends BaseCorporeaBlockEntity implements CorporeaRequestor, Wandable {
	private static final String TAG_REQUEST_TARGET = "requestTarget";
	private static final String TAG_ITEM_COUNT = "itemCount";
	private static final String TAG_LOCK = "lock";

	private class_1799 requestTarget = class_1799.field_8037;
	private int itemCount = 0;
	private int ticks = 0;
	private int compValue = 0;
	public boolean locked = false;

	public CorporeaCrystalCubeBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.CORPOREA_CRYSTAL_CUBE, pos, state);
	}

	public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, CorporeaCrystalCubeBlockEntity self) {
		++self.ticks;
		if (self.ticks % 20 == 0) {
			self.updateCount();
		}
	}

	public void setRequestTarget(class_1799 stack) {
		if (!stack.method_7960() && !locked) {
			class_1799 copy = stack.method_7972();
			copy.method_7939(1);
			requestTarget = copy;
			updateCount();
			if (!field_11863.field_9236) {
				VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
			}
		}

	}

	public class_1799 getRequestTarget() {
		return requestTarget;
	}

	public int getItemCount() {
		return itemCount;
	}

	public void doRequest(class_1657 player) {
		if (field_11863.field_9236) {
			return;
		}

		CorporeaSpark spark = getSpark();
		if (spark != null && spark.getMaster() != null && !requestTarget.method_7960()) {
			int count = player.method_5715() ? requestTarget.method_7914() : 1;
			var matcher = CorporeaHelper.instance().createMatcher(requestTarget, true);
			doCorporeaRequest(matcher, count, spark, player);
		}
	}

	private void updateCount() {
		if (field_11863.field_9236) {
			return;
		}

		int sum = 0;
		CorporeaSpark spark = getSpark();
		if (spark != null && spark.getMaster() != null && !requestTarget.method_7960()) {
			var matcher = CorporeaHelper.instance().createMatcher(requestTarget, true);
			List<class_1799> stacks = CorporeaHelper.instance().requestItem(matcher, -1, spark, null, false).stacks();
			for (class_1799 stack : stacks) {
				sum += stack.method_7947();
			}
		}

		setCount(sum);
	}

	private void setCount(int count) {
		int oldCount = this.itemCount;
		this.itemCount = count;
		if (this.itemCount != oldCount) {
			int oldCompValue = this.compValue;
			this.compValue = CorporeaHelper.instance().signalStrengthForRequestSize(itemCount);
			if (this.compValue != oldCompValue && this.field_11863 != null) {
				this.field_11863.method_8455(this.field_11867, method_11010().method_26204());
			}
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		}
	}

	@Override
	public void writePacketNBT(class_2487 tag) {
		super.writePacketNBT(tag);
		class_2487 cmp = new class_2487();
		if (!requestTarget.method_7960()) {
			cmp = requestTarget.method_7953(cmp);
		}
		tag.method_10566(TAG_REQUEST_TARGET, cmp);
		tag.method_10569(TAG_ITEM_COUNT, itemCount);
		tag.method_10556(TAG_LOCK, locked);
	}

	@Override
	public void readPacketNBT(class_2487 tag) {
		super.readPacketNBT(tag);
		class_2487 cmp = tag.method_10562(TAG_REQUEST_TARGET);
		requestTarget = class_1799.method_7915(cmp);
		setCount(tag.method_10550(TAG_ITEM_COUNT));
		locked = tag.method_10577(TAG_LOCK);
	}

	public int getComparatorValue() {
		return compValue;
	}

	@Override
	public void doCorporeaRequest(CorporeaRequestMatcher request, int count, CorporeaSpark spark, @Nullable class_1309 entity) {
		if (!requestTarget.method_7960()) {
			List<class_1799> stacks = CorporeaHelper.instance().requestItem(request, count, spark, entity, true).stacks();
			spark.onItemsRequested(stacks);
			boolean did = false;
			int sum = 0;
			for (class_1799 reqStack : stacks) {
				class_1542 item = new class_1542(field_11863, field_11867.method_10263() + 0.5, field_11867.method_10264() + 1.5, field_11867.method_10260() + 0.5, reqStack);
				field_11863.method_8649(item);
				if (requestTarget.method_7962(reqStack)) {
					sum += reqStack.method_7947();
					did = true;
				}
			}

			if (did) {
				setCount(getItemCount() - sum);
			}
		}
	}

	@Override
	public boolean onUsedByWand(@Nullable class_1657 player, class_1799 stack, class_2350 side) {
		if (player == null || player.method_5715()) {
			this.locked = !this.locked;
			if (!field_11863.field_9236) {
				VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
			}
			return true;
		}
		return false;
	}

	public static class Hud {
		public static void render(class_4587 ps, CorporeaCrystalCubeBlockEntity cube) {
			class_310 mc = class_310.method_1551();
			class_3695 profiler = mc.method_16011();

			profiler.method_15396("crystalCube");
			class_1799 target = cube.getRequestTarget();
			if (!target.method_7960()) {
				String nameStr = target.method_7964().getString();
				String countStr = cube.getItemCount() + "x";
				String lockedStr = class_1074.method_4662("botaniamisc.locked");

				int strlen = Math.max(mc.field_1772.method_1727(nameStr), mc.field_1772.method_1727(countStr));
				if (cube.locked) {
					strlen = Math.max(strlen, mc.field_1772.method_1727(lockedStr));
				}

				int w = mc.method_22683().method_4486();
				int h = mc.method_22683().method_4502();
				int boxH = h / 2 + (cube.locked ? 20 : 10);
				class_332.method_25294(ps, w / 2 + 8, h / 2 - 12, w / 2 + strlen + 32, boxH, 0x44000000);
				class_332.method_25294(ps, w / 2 + 6, h / 2 - 14, w / 2 + strlen + 34, boxH + 2, 0x44000000);

				mc.field_1772.method_1720(ps, nameStr, w / 2.0F + 30, h / 2.0F - 10, 0x6666FF);
				mc.field_1772.method_1720(ps, countStr, w / 2.0F + 30, h / 2.0F, 0xFFFFFF);
				if (cube.locked) {
					mc.field_1772.method_1720(ps, lockedStr, w / 2.0F + 30, h / 2.0F + 10, 0xFFAA00);
				}
				mc.method_1480().method_4023(target, w / 2 + 10, h / 2 - 10);
			}

			profiler.method_15407();
		}
	}
}
