/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity;

import it.unimi.dsi.fastutil.objects.ObjectArrays;
import net.minecraft.class_1268;
import net.minecraft.class_1275;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1671;
import net.minecraft.class_1767;
import net.minecraft.class_1781;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5545;
import net.minecraft.class_5819;
import net.minecraft.class_6088;
import net.minecraft.world.level.block.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.BotaniaStats;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.decor.TinyPotatoBlock;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.helper.VecHelper;

import java.time.LocalDateTime;
import java.time.Month;
import java.util.List;
import java.util.Locale;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

import I;

public class TinyPotatoBlockEntity extends ExposedSimpleInventoryBlockEntity implements class_1275 {
	private static final class_2960 BIRTHDAY_ADVANCEMENT = prefix("challenge/tiny_potato_birthday");
	private static final boolean IS_BIRTHDAY = isTinyPotatoBirthday();
	private static final String TAG_NAME = "name";
	private static final int JUMP_EVENT = 0;

	public int jumpTicks = 0;
	public class_2561 name = class_2561.method_43470("");
	private int nextDoIt = 0;
	private int birthdayTick = 0;

	public TinyPotatoBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.TINY_POTATO, pos, state);
	}

	public void interact(class_1657 player, class_1268 hand, class_1799 stack, class_2350 side) {
		if (!field_11863.field_9236) {
			int index = side.method_10146();
			class_1799 stackAt = getItemHandler().method_5438(index);
			if (!stackAt.method_7960() && stack.method_7960()) {
				player.method_6122(hand, stackAt);
				getItemHandler().method_5447(index, class_1799.field_8037);
			} else if (!stack.method_7960()) {
				class_1799 copy = stack.method_7971(1);

				if (stack.method_7960()) {
					player.method_6122(hand, stackAt);
				} else if (!stackAt.method_7960()) {
					player.method_31548().method_7398(stackAt);
				}

				getItemHandler().method_5447(index, copy);
			}

			jump();

			if (name.getString().toLowerCase(Locale.ROOT).trim().endsWith("shia labeouf") && nextDoIt == 0) {
				nextDoIt = 40;
				field_11863.method_8396(null, field_11867, BotaniaSounds.doit, class_3419.field_15245, 1F, 1F);
			}

			for (int i = 0; i < inventorySize(); i++) {
				var son = getItemHandler().method_5438(i);
				if (!son.method_7960() && son.method_31574(BotaniaBlocks.tinyPotato.method_8389())) {
					player.method_43496(class_2561.method_43470("Don't talk to me or my son ever again."));
					return;
				}
			}

			player.method_7281(BotaniaStats.TINY_POTATOES_PETTED);
			PlayerHelper.grantCriterion((class_3222) player, prefix("main/tiny_potato_pet"), "code_triggered");
		}
	}

	private void jump() {
		if (jumpTicks == 0) {
			field_11863.method_8427(method_11016(), method_11010().method_26204(), JUMP_EVENT, 20);
		}
	}

	@Override
	public boolean method_11004(int id, int param) {
		if (id == JUMP_EVENT) {
			jumpTicks = param;
			return true;
		} else {
			return super.method_11004(id, param);
		}
	}

	public static void commonTick(class_1937 level, class_2338 pos, class_2680 state, TinyPotatoBlockEntity self) {
		if (self.jumpTicks > 0) {
			self.jumpTicks--;
		}

		if (!level.field_9236) {
			if (level.field_9229.method_43048(100) == 0) {
				self.jump();
			}
			if (self.nextDoIt > 0) {
				self.nextDoIt--;
			}
			if (IS_BIRTHDAY) {
				self.tickBirthday();
			}
		}
	}

	private void tickBirthday() {
		var facing = method_11010().method_11654(class_2741.field_12481);
		var facingPos = method_11016().method_10093(facing);

		if (field_11863.method_22340(facingPos)) {
			var facingState = field_11863.method_8320(facingPos);
			var cakeColor = getLitCakeColor(facingState, field_11863.method_8409());
			var players = PlayerHelper.getRealPlayersIn(field_11863,
					VecHelper.boxForRange(class_243.method_24953(method_11016()), 8));

			if (cakeColor != null && !players.isEmpty()) {
				birthdayTick++;

				// 3.5s per message, initial delay of 5s
				var messageTimes = List.of(100, 170, 240, 310, 380);
				var messageIndex = messageTimes.indexOf(birthdayTick);
				if (messageIndex != -1) {
					Object[] args = messageIndex == 1 ? new Object[] { getTinyPotatoAge() } : ObjectArrays.EMPTY_ARRAY;
					var message = class_2561.method_43470("<")
							.method_10852(method_5476())
							.method_27693("> ")
							.method_10852(class_2561.method_43469("botania.tater_birthday." + messageIndex, args));

					for (var player : players) {
						player.method_43496(message);
					}
					jump();
					TinyPotatoBlock.spawnHearts((class_3218) field_11863, method_11016());
				}

				if (messageIndex == messageTimes.size() - 1) {
					class_2487 explosion = new class_2487();
					explosion.method_10567("Type", (byte) class_1781.class_1782.field_7977.method_7816());
					explosion.method_10556("Flicker", true);
					explosion.method_10556("Trail", true);
					explosion.method_10572("Colors", List.of(
							cakeColor.method_7790(),
							0xD260A5, 0xE4AFCD, 0xFEFEFE, 0x57CEF8
					));

					class_2499 explosions = new class_2499();
					explosions.add(explosion);

					class_1799 rocket = new class_1799(class_1802.field_8639);
					class_2487 rocketFireworks = rocket.method_7911("Fireworks");
					rocketFireworks.method_10567("Flight", (byte) 0);
					rocketFireworks.method_10566("Explosions", explosions);

					field_11863.method_8649(new class_1671(field_11863, facingPos.method_10263() + 0.5, facingPos.method_10264() + 0.5, facingPos.method_10260() + 0.5, rocket));
					field_11863.method_8650(facingPos, false);
					field_11863.method_20290(class_6088.field_31144, facingPos, class_2248.method_9507(facingState));
					// Usage of vanilla sound event: Subtitle is "Eating", generic sounds are meant to be reused.
					field_11863.method_8396(null, method_11016(), class_3417.field_20614, class_3419.field_15245, 1F, 0.5F + (float) Math.random() * 0.5F);

					for (var player : players) {
						PlayerHelper.grantCriterion((class_3222) player, BIRTHDAY_ADVANCEMENT, "code_triggered");
					}
				}
			}
		}
	}

	@Override
	public void method_5431() {
		super.method_5431();
		if (field_11863 != null && !field_11863.field_9236) {
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		}
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		super.writePacketNBT(cmp);
		cmp.method_10582(TAG_NAME, class_2561.class_2562.method_10867(name));
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		super.readPacketNBT(cmp);
		name = class_2561.class_2562.method_10877(cmp.method_10558(TAG_NAME));
	}

	@Override
	protected class_1277 createItemHandler() {
		return new class_1277(6) {
			@Override
			public int method_5444() {
				return 1;
			}
		};
	}

	@NotNull
	@Override
	public class_2561 method_5477() {
		return BotaniaBlocks.tinyPotato.method_9518();
	}

	@Nullable
	@Override
	public class_2561 method_5797() {
		return name.getString().isEmpty() ? null : name;
	}

	@NotNull
	@Override
	public class_2561 method_5476() {
		return method_16914() ? method_5797() : method_5477();
	}

	private static final List<class_2248> ALL_CANDLE_CAKES = List.of(
			class_2246.field_27143, class_2246.field_27144, class_2246.field_27145, class_2246.field_27146,
			class_2246.field_27147, class_2246.field_27148, class_2246.field_27149, class_2246.field_27150,
			class_2246.field_27151, class_2246.field_27152, class_2246.field_27153, class_2246.field_27154,
			class_2246.field_27155, class_2246.field_27156, class_2246.field_27157, class_2246.field_27158,
			class_2246.field_27142
	);

	@Nullable
	private static class_1767 getLitCakeColor(class_2680 state, class_5819 rand) {
		var idx = ALL_CANDLE_CAKES.indexOf(state.method_26204());
		if (idx == -1) {
			return null;
		}

		if (!state.method_11654(class_5545.field_27183)) {
			return null;
		}

		if (idx == 16) { // Uncolored candle cake, choose a random color
			return class_1767.method_7791(rand.method_43048(16));
		}

		return class_1767.method_7791(idx);
	}

	private static boolean isTinyPotatoBirthday() {
		// Tiny Potato was added in commit c225a134043922724e6ff141ff26f31097d4d9d0,
		// created on July 19, 2014
		var now = LocalDateTime.now();
		return now.getMonth() == Month.JULY && now.getDayOfMonth() == 19;
	}

	private static int getTinyPotatoAge() {
		var now = LocalDateTime.now();
		return now.getYear() - 2014;
	}
}
