/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity;

import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.api.mana.spark.SparkUpgradeType;
import vazkii.botania.common.item.SparkAugmentItem;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public class SparkTinkererBlockEntity extends ExposedSimpleInventoryBlockEntity {
	public SparkTinkererBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.SPARK_CHANGER, pos, state);
	}

	public void doSwap() {
		if (field_11863.field_9236) {
			return;
		}

		class_1799 changeStack = getItemHandler().method_5438(0);
		List<SparkAttachable> attachables = new ArrayList<>();
		for (class_2350 dir : class_2350.class_2353.field_11062) {
			var pos = field_11867.method_10093(dir);
			var attach = XplatAbstractions.INSTANCE.findSparkAttachable(field_11863, pos, field_11863.method_8320(pos), field_11863.method_8321(pos), dir.method_10153());
			if (attach != null) {
				ManaSpark spark = attach.getAttachedSpark();
				if (spark != null) {
					SparkUpgradeType upg = spark.getUpgrade();
					SparkUpgradeType newUpg = changeStack.method_7960() ? SparkUpgradeType.NONE : ((SparkAugmentItem) changeStack.method_7909()).type;
					if (upg != newUpg) {
						attachables.add(attach);
					}
				}
			}
		}

		if (attachables.size() > 0) {
			SparkAttachable attach = attachables.get(field_11863.field_9229.method_43048(attachables.size()));
			ManaSpark spark = attach.getAttachedSpark();
			SparkUpgradeType upg = spark.getUpgrade();
			class_1799 sparkStack = SparkAugmentItem.getByType(upg);
			SparkUpgradeType newUpg = changeStack.method_7960() ? SparkUpgradeType.NONE : ((SparkAugmentItem) changeStack.method_7909()).type;
			spark.setUpgrade(newUpg);
			Collection<ManaSpark> transfers = spark.getTransfers();
			if (transfers != null) {
				transfers.clear();
			}
			getItemHandler().method_5447(0, sparkStack);
		}
	}

	@Override
	protected class_1277 createItemHandler() {
		return new class_1277(1) {
			@Override
			public int method_5444() {
				return 1;
			}

			@Override
			public boolean method_5437(int index, class_1799 stack) {
				return !stack.method_7960() && stack.method_7909() instanceof SparkAugmentItem;
			}
		};
	}

	@Override
	public void method_5431() {
		super.method_5431();
		if (field_11863 != null && !field_11863.field_9236) {
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		}
	}

}
