/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity;

import com.mojang.blaze3d.systems.RenderSystem;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.recipe.RunicAltarRecipe;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.material.RuneItem;
import vazkii.botania.common.proxy.Proxy;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1074;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_4587;

public class RunicAltarBlockEntity extends SimpleInventoryBlockEntity implements ManaReceiver, Wandable {
	private static final String TAG_MANA = "mana";
	private static final String TAG_MANA_TO_GET = "manaToGet";
	private static final int SET_KEEP_TICKS_EVENT = 0;
	private static final int SET_COOLDOWN_EVENT = 1;
	private static final int CRAFT_EFFECT_EVENT = 2;

	private RunicAltarRecipe currentRecipe;

	public int manaToGet = 0;
	private int mana = 0;
	private int cooldown = 0;
	public int signal = 0;

	private List<class_1799> lastRecipe = null;
	private int recipeKeepTicks = 0;

	public RunicAltarBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.RUNE_ALTAR, pos, state);
	}

	public boolean addItem(@Nullable class_1657 player, class_1799 stack, @Nullable class_1268 hand) {
		if (cooldown > 0 || stack.method_7909() instanceof WandOfTheForestItem || stack.method_31574(BotaniaItems.lexicon)) {
			return false;
		}

		if (stack.method_31574(BotaniaBlocks.livingrock.method_8389())) {
			if (!field_11863.field_9236) {
				class_1799 toSpawn = player != null && player.method_31549().field_7477 ? stack.method_7972().method_7971(1) : stack.method_7971(1);
				class_1542 item = new class_1542(field_11863, method_11016().method_10263() + 0.5, method_11016().method_10264() + 1, method_11016().method_10260() + 0.5, toSpawn);
				item.method_6982(40);
				item.method_18799(class_243.field_1353);
				field_11863.method_8649(item);
			}

			return true;
		}

		if (manaToGet != 0) {
			return false;
		}

		boolean did = false;

		for (int i = 0; i < inventorySize(); i++) {
			if (getItemHandler().method_5438(i).method_7960()) {
				did = true;
				class_1799 stackToAdd = stack.method_7972();
				stackToAdd.method_7939(1);
				getItemHandler().method_5447(i, stackToAdd);

				if (player == null || !player.method_31549().field_7477) {
					stack.method_7934(1);
				}

				break;
			}
		}

		if (did) {
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		}

		return true;
	}

	@Override
	public boolean method_11004(int id, int param) {
		switch (id) {
			case SET_KEEP_TICKS_EVENT:
				recipeKeepTicks = param;
				return true;
			case SET_COOLDOWN_EVENT:
				cooldown = param;
				return true;
			case CRAFT_EFFECT_EVENT: {
				if (field_11863.field_9236) {
					for (int i = 0; i < 25; i++) {
						float red = (float) Math.random();
						float green = (float) Math.random();
						float blue = (float) Math.random();
						SparkleParticleData data = SparkleParticleData.sparkle((float) Math.random(), red, green, blue, 10);
						field_11863.method_8406(data, field_11867.method_10263() + 0.5 + Math.random() * 0.4 - 0.2, field_11867.method_10264() + 1, field_11867.method_10260() + 0.5 + Math.random() * 0.4 - 0.2, 0, 0, 0);
					}
					field_11863.method_8486(field_11867.method_10263(), field_11867.method_10264(), field_11867.method_10260(), BotaniaSounds.runeAltarCraft, class_3419.field_15245, 1F, 1F, false);
				}
				return true;
			}
			default:
				return super.method_11004(id, param);
		}
	}

	private void tickCooldown() {
		if (cooldown > 0) {
			cooldown--;
		}

		if (recipeKeepTicks > 0) {
			--recipeKeepTicks;
		} else {
			lastRecipe = null;
		}
	}

	public static void serverTick(class_1937 level, class_2338 worldPosition, class_2680 state, RunicAltarBlockEntity self) {
		if (self.manaToGet == 0) {
			List<class_1542> items = level.method_18467(class_1542.class, new class_238(worldPosition, worldPosition.method_10069(1, 1, 1)));
			for (class_1542 item : items) {
				if (item.method_5805() && !item.method_6983().method_7960() && !item.method_6983().method_31574(BotaniaBlocks.livingrock.method_8389())) {
					class_1799 stack = item.method_6983();
					if (self.addItem(null, stack, null)) {
						EntityHelper.syncItem(item);
					}
				}
			}
		}

		int newSignal = 0;
		if (self.manaToGet > 0) {
			newSignal++;
			if (self.mana >= self.manaToGet) {
				newSignal++;
			}
		}

		if (newSignal != self.signal) {
			self.signal = newSignal;
			level.method_8455(worldPosition, state.method_26204());
		}

		self.updateRecipe();
		self.tickCooldown();
	}

	public static void clientTick(class_1937 level, class_2338 worldPosition, class_2680 state, RunicAltarBlockEntity self) {
		if (self.manaToGet > 0 && self.mana >= self.manaToGet && level.field_9229.method_43048(20) == 0) {
			class_243 vec = class_243.method_24953(self.method_11016());
			class_243 endVec = vec.method_1031(0, 2.5, 0);
			Proxy.INSTANCE.lightningFX(level, vec, endVec, 2F, 0x00948B, 0x00E4D7);
		}

		if (self.cooldown > 0) {
			WispParticleData data = WispParticleData.wisp(0.2F, 0.2F, 0.2F, 0.2F, 1);
			level.method_8406(data, worldPosition.method_10263() + Math.random(), worldPosition.method_10264() + 0.8, worldPosition.method_10260() + Math.random(), 0, - -0.025F, 0);
		}
		self.tickCooldown();
	}

	private void updateRecipe() {
		int manaToGet = this.manaToGet;

		if (currentRecipe != null) {
			this.manaToGet = currentRecipe.getManaUsage();
		} else {
			this.manaToGet = field_11863.method_8433().method_8132(BotaniaRecipeTypes.RUNE_TYPE, getItemHandler(), field_11863)
					.map(RunicAltarRecipe::getManaUsage)
					.orElse(0);
		}

		if (manaToGet != this.manaToGet) {
			field_11863.method_8396(null, field_11867, BotaniaSounds.runeAltarStart, class_3419.field_15245, 1F, 1F);
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		}
	}

	private void saveLastRecipe() {
		lastRecipe = new ArrayList<>();
		for (int i = 0; i < inventorySize(); i++) {
			class_1799 stack = getItemHandler().method_5438(i);
			if (stack.method_7960()) {
				break;
			}
			lastRecipe.add(stack.method_7972());
		}
		recipeKeepTicks = 400;
		field_11863.method_8427(method_11016(), BotaniaBlocks.runeAltar, SET_KEEP_TICKS_EVENT, 400);
	}

	public class_1269 trySetLastRecipe(class_1657 player) {
		// lastRecipe is not synced. If we're calling this method we already checked that
		// the altar has no items, so just optimistically assume success on the client.
		boolean success = player.field_6002.field_9236
				|| InventoryHelper.tryToSetLastRecipe(player, getItemHandler(), lastRecipe, null);
		if (success) {
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		}
		return success
				? class_1269.method_29236(player.field_6002.method_8608())
				: class_1269.field_5811;
	}

	@Override
	public boolean onUsedByWand(@Nullable class_1657 player, class_1799 wand, class_2350 side) {
		if (field_11863.field_9236) {
			return true;
		}

		RunicAltarRecipe recipe = null;

		if (currentRecipe != null) {
			recipe = currentRecipe;
		} else {
			Optional<RunicAltarRecipe> maybeRecipe = field_11863.method_8433().method_8132(BotaniaRecipeTypes.RUNE_TYPE, getItemHandler(), field_11863);
			if (maybeRecipe.isPresent()) {
				recipe = maybeRecipe.get();
			}
		}

		if (recipe != null && manaToGet > 0 && mana >= manaToGet) {
			List<class_1542> items = field_11863.method_18467(class_1542.class, new class_238(field_11867, field_11867.method_10069(1, 1, 1)));
			class_1542 livingrock = null;
			for (class_1542 item : items) {
				if (item.method_5805() && !item.method_6983().method_7960() && item.method_6983().method_31574(BotaniaBlocks.livingrock.method_8389())) {
					livingrock = item;
					break;
				}
			}

			if (livingrock != null) {
				int mana = recipe.getManaUsage();
				receiveMana(-mana);
				class_1799 output = recipe.method_8116(getItemHandler());
				class_1542 outputItem = new class_1542(field_11863, field_11867.method_10263() + 0.5, field_11867.method_10264() + 1.5, field_11867.method_10260() + 0.5, output);
				field_11863.method_8649(outputItem);
				currentRecipe = null;
				field_11863.method_8427(method_11016(), BotaniaBlocks.runeAltar, SET_COOLDOWN_EVENT, 60);
				field_11863.method_8427(method_11016(), BotaniaBlocks.runeAltar, CRAFT_EFFECT_EVENT, 0);

				saveLastRecipe();
				for (int i = 0; i < inventorySize(); i++) {
					class_1799 stack = getItemHandler().method_5438(i);
					if (!stack.method_7960()) {
						if (stack.method_7909() instanceof RuneItem && (player == null || !player.method_31549().field_7477)) {
							class_1542 outputRune = new class_1542(field_11863, method_11016().method_10263() + 0.5, method_11016().method_10264() + 1.5, method_11016().method_10260() + 0.5, stack.method_7972());
							field_11863.method_8649(outputRune);
						}

						getItemHandler().method_5447(i, class_1799.field_8037);
					}
				}

				EntityHelper.shrinkItem(livingrock);
			}
		}

		return true;
	}

	public boolean isEmpty() {
		for (int i = 0; i < inventorySize(); i++) {
			if (!getItemHandler().method_5438(i).method_7960()) {
				return false;
			}
		}

		return true;
	}

	@Override
	public void writePacketNBT(class_2487 tag) {
		super.writePacketNBT(tag);

		tag.method_10569(TAG_MANA, mana);
		tag.method_10569(TAG_MANA_TO_GET, manaToGet);
	}

	@Override
	public void readPacketNBT(class_2487 tag) {
		super.readPacketNBT(tag);

		mana = tag.method_10550(TAG_MANA);
		manaToGet = tag.method_10550(TAG_MANA_TO_GET);
	}

	@Override
	protected class_1277 createItemHandler() {
		return new class_1277(16) {
			@Override
			public int method_5444() {
				return 1;
			}
		};
	}

	@Override
	public class_1937 getManaReceiverLevel() {
		return method_10997();
	}

	@Override
	public class_2338 getManaReceiverPos() {
		return method_11016();
	}

	@Override
	public int getCurrentMana() {
		return mana;
	}

	@Override
	public boolean isFull() {
		return mana >= manaToGet;
	}

	@Override
	public void receiveMana(int mana) {
		this.mana = Math.min(this.mana + mana, manaToGet);
	}

	@Override
	public boolean canReceiveManaFromBursts() {
		return !isFull();
	}

	public boolean canAddLastRecipe() {
		return this.isEmpty();
	}

	public static class Hud {
		public static void render(RunicAltarBlockEntity altar, class_4587 ms, class_310 mc) {
			int xc = mc.method_22683().method_4486() / 2;
			int yc = mc.method_22683().method_4502() / 2;

			float angle = -90;
			int radius = 24;
			int amt = 0;
			for (int i = 0; i < altar.inventorySize(); i++) {
				if (altar.getItemHandler().method_5438(i).method_7960()) {
					break;
				}
				amt++;
			}

			if (amt > 0) {
				float anglePer = 360F / amt;
				altar.field_11863.method_8433().method_8132(BotaniaRecipeTypes.RUNE_TYPE, altar.getItemHandler(), altar.field_11863).ifPresent(recipe -> {
					RenderSystem.enableBlend();
					RenderSystem.blendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);

					float progress = (float) altar.mana / (float) altar.manaToGet;

					RenderSystem.setShaderTexture(0, HUDHandler.manaBar);
					RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
					RenderHelper.drawTexturedModalRect(ms, xc + radius + 9, yc - 8, progress == 1F ? 0 : 22, 8, 22, 15);

					if (progress == 1F) {
						mc.method_1480().method_4010(new class_1799(BotaniaBlocks.livingrock), xc + radius + 16, yc + 8);
						class_4587 pose = RenderSystem.getModelViewStack();
						pose.method_22903();
						pose.method_22904(0, 0, 100);
						RenderSystem.applyModelViewMatrix();
						// If the player is holding a WandOfTheForestItem or has one in their inventory, render that instead of a generic twigWand
						class_1799 playerWand = PlayerHelper.getFirstHeldItemClass(mc.field_1724, WandOfTheForestItem.class);
						if (playerWand.method_7960()) {
							playerWand = PlayerHelper.getItemClassFromInventory(mc.field_1724, WandOfTheForestItem.class);
						}
						class_1799 wandToRender = playerWand.method_7960() ? new class_1799(BotaniaItems.twigWand) : playerWand;
						mc.method_1480().method_4010(wandToRender, xc + radius + 24, yc + 8);
						pose.method_22909();
						RenderSystem.applyModelViewMatrix();
					}

					RenderHelper.renderProgressPie(ms, xc + radius + 32, yc - 8, progress, recipe.method_8116(altar.getItemHandler()));

					if (progress == 1F) {
						mc.field_1772.method_1729(ms, "+", xc + radius + 14, yc + 12, 0xFFFFFF);
					}
				});

				for (int i = 0; i < amt; i++) {
					double xPos = xc + Math.cos(angle * Math.PI / 180D) * radius - 8;
					double yPos = yc + Math.sin(angle * Math.PI / 180D) * radius - 8;
					class_4587 pose = RenderSystem.getModelViewStack();
					pose.method_22903();
					pose.method_22904(xPos, yPos, 0);
					RenderSystem.applyModelViewMatrix();
					mc.method_1480().method_4010(altar.getItemHandler().method_5438(i), 0, 0);
					pose.method_22909();
					RenderSystem.applyModelViewMatrix();

					angle += anglePer;
				}
			}
			if (altar.recipeKeepTicks > 0 && altar.canAddLastRecipe()) {
				String s = class_1074.method_4662("botaniamisc.altarRefill0");
				mc.field_1772.method_1720(ms, s, xc - mc.field_1772.method_1727(s) / 2, yc + 10, 0xFFFFFF);
				s = class_1074.method_4662("botaniamisc.altarRefill1");
				mc.field_1772.method_1720(ms, s, xc - mc.field_1772.method_1727(s) / 2, yc + 20, 0xFFFFFF);
			}
		}
	}

	public int getTargetMana() {
		return manaToGet;
	}

}
