/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.block.Wandable;
import vazkii.botania.common.annotations.SoftImplement;
import vazkii.botania.common.block.PlatformBlock;

public class PlatformBlockEntity extends BotaniaBlockEntity implements Wandable {
	private static final String TAG_CAMO = "camo";

	@Nullable
	private class_2680 camoState;

	public PlatformBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.PLATFORM, pos, state);
	}

	@Override
	public boolean onUsedByWand(@Nullable class_1657 player, class_1799 stack, class_2350 side) {
		if (player != null) {
			PlatformBlock.Variant variant = getVariant();
			if (variant.indestructible && !player.method_7337()) {
				return false;
			}

			if (getCamoState() == null || player.method_5715()) {
				swapSelfAndPass(this, true, variant);
			} else {
				swapSurroudings(this, false, variant);
			}
			return true;
		}

		return false;
	}

	@Nullable
	public class_2680 getCamoState() {
		return camoState;
	}

	public void setCamoState(@Nullable class_2680 state) {
		this.camoState = state;

		if (field_11863 != null) {
			field_11863.method_8413(method_11016(), method_11010(), method_11010(), 3);
			if (!field_11863.field_9236) {
				field_11863.method_8408(field_11867, method_11010().method_26204());
				method_5431();
			}
		}
	}

	private PlatformBlock.Variant getVariant() {
		return ((PlatformBlock) method_11010().method_26204()).getVariant();
	}

	private void swapSelfAndPass(PlatformBlockEntity tile, boolean empty, PlatformBlock.Variant variant) {
		swap(tile, empty);
		swapSurroudings(tile, empty, variant);
	}

	private void swapSurroudings(PlatformBlockEntity tile, boolean empty, PlatformBlock.Variant variant) {
		for (class_2350 dir : class_2350.values()) {
			class_2338 pos = tile.method_11016().method_10093(dir);
			class_2586 tileAt = field_11863.method_8321(pos);
			if (tileAt instanceof PlatformBlockEntity platform) {
				if (tile.getVariant() != platform.getVariant()) {
					continue;
				}
				if (empty == (platform.getCamoState() != null)) {
					swapSelfAndPass(platform, empty, variant);
				}
			}
		}
	}

	private void swap(PlatformBlockEntity tile, boolean empty) {
		tile.setCamoState(empty ? null : getCamoState());
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		if (getCamoState() != null) {
			cmp.method_10566(TAG_CAMO, class_2512.method_10686(getCamoState()));
		}
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		class_2680 state = class_2512.method_10681(cmp.method_10562(TAG_CAMO));
		if (state.method_26215()) {
			state = null;
		}
		setCamoState(state);
		if (field_11863 != null && field_11863.field_9236) {
			field_11863.method_8413(method_11016(), method_11010(), method_11010(), 0);
		}
	}

	@SoftImplement("RenderAttachmentBlockEntity")
	public Object getRenderAttachmentData() {
		return new PlatformData(this);
	}

	public record PlatformData(class_2338 pos, @Nullable class_2680 state) {
		public PlatformData(PlatformBlockEntity tile) {
			this(tile.method_11016().method_10062(), tile.camoState);
		}
	}
}
