/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.class_1277;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.xplat.XplatAbstractions;

public class OpenCrateBlockEntity extends ExposedSimpleInventoryBlockEntity {
	public OpenCrateBlockEntity(class_2338 pos, class_2680 state) {
		this(BotaniaBlockEntities.OPEN_CRATE, pos, state);
	}

	protected OpenCrateBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
		super(type, pos, state);
	}

	@Override
	protected class_1277 createItemHandler() {
		return new class_1277(1);
	}

	public static void serverTick(class_1937 level, class_2338 worldPosition, class_2680 state, OpenCrateBlockEntity self) {
		boolean redstone = level.method_8479(worldPosition);

		if (self.canEject()) {
			class_1799 stack = self.getItemHandler().method_5438(0);
			if (!stack.method_7960()) {
				self.eject(stack, redstone);
			}
		}
	}

	public boolean canEject() {
		float width = class_1299.field_6052.method_17685();
		float height = class_1299.field_6052.method_17686();

		double ejectX = field_11867.method_10263() + 0.5;
		double ejectY = field_11867.method_10264() - height;
		double ejectZ = field_11867.method_10260() + 0.5;
		class_238 itemBB = new class_238(ejectX - width / 2, ejectY, ejectZ - width / 2, ejectX + width / 2, ejectY + height, ejectZ + width / 2);
		return field_11863.method_18026(itemBB);
	}

	public void eject(class_1799 stack, boolean redstone) {
		double ejectY = field_11867.method_10264() - class_1299.field_6052.method_17686();
		class_1542 item = new class_1542(field_11863, field_11867.method_10263() + 0.5, ejectY, field_11867.method_10260() + 0.5, stack);
		item.method_18799(class_243.field_1353);
		if (redstone) {
			XplatAbstractions.INSTANCE.itemFlagsComponent(item).timeCounter = -200;
		}

		getItemHandler().method_5447(0, class_1799.field_8037);
		field_11863.method_8649(item);
	}

	@Override
	public boolean method_5493(int index, @NotNull class_1799 stack, @Nullable class_2350 direction) {
		return false;
	}
}
