/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.api.state.enums.CraftyCratePattern;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.mixin.RecipeManagerAccessor;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.*;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_332;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_4013;
import net.minecraft.class_4587;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class CraftyCrateBlockEntity extends OpenCrateBlockEntity implements Wandable {
	private static final String TAG_CRAFTING_RESULT = "craft_result";

	private static int recipeEpoch = 0;

	private int signal = 0;
	private class_1799 craftResult = class_1799.field_8037;

	private final Queue<class_2960> lastRecipes = new ArrayDeque<>();
	private boolean dirty;
	private boolean matchFailed;
	private int lastRecipeEpoch = recipeEpoch;

	public static void registerListener() {
		XplatAbstractions.INSTANCE.registerReloadListener(class_3264.field_14190, prefix("craft_crate_epoch_counter"),
				(class_4013) mgr -> recipeEpoch++);
	}

	public CraftyCrateBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.CRAFT_CRATE, pos, state);
	}

	@Override
	protected class_1277 createItemHandler() {
		return new class_1277(9) {
			@Override
			public int method_5444() {
				return 1;
			}

			@Override
			public boolean method_5437(int slot, class_1799 stack) {
				return !isLocked(slot);
			}
		};
	}

	public CraftyCratePattern getPattern() {
		class_2680 state = method_11010();
		if (!state.method_27852(BotaniaBlocks.craftCrate)) {
			return CraftyCratePattern.NONE;
		}
		return state.method_11654(BotaniaStateProperties.CRATE_PATTERN);
	}

	private boolean isLocked(int slot) {
		return !getPattern().openSlots.get(slot);
	}

	@Override
	public void readPacketNBT(class_2487 tag) {
		super.readPacketNBT(tag);
		craftResult = class_1799.method_7915(tag.method_10562(TAG_CRAFTING_RESULT));
	}

	@Override
	public void writePacketNBT(class_2487 tag) {
		super.writePacketNBT(tag);
		tag.method_10566(TAG_CRAFTING_RESULT, craftResult.method_7953(new class_2487()));
	}

	public static void serverTick(class_1937 level, class_2338 worldPosition, class_2680 state, CraftyCrateBlockEntity self) {
		if (recipeEpoch != self.lastRecipeEpoch) {
			self.lastRecipeEpoch = recipeEpoch;
			self.matchFailed = false;
		}

		if (!self.matchFailed && self.canEject() && self.isFull() && self.craft(true)) {
			self.ejectAll();
		}

		int newSignal = 0;
		for (; newSignal < 9; newSignal++) // dis for loop be derpy
		{
			if (!self.isLocked(newSignal) && self.getItemHandler().method_5438(newSignal).method_7960()) {
				break;
			}
		}

		if (newSignal != self.signal) {
			self.signal = newSignal;
			level.method_8455(worldPosition, state.method_26204());
		}

		if (self.dirty) {
			self.dirty = false;
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
		}
	}

	private boolean craft(boolean fullCheck) {
		field_11863.method_16107().method_15396("craft");
		if (fullCheck && !isFull()) {
			return false;
		}

		class_1715 craft = new class_1715(new class_1703(class_3917.field_17333, -1) {
			@NotNull
			@Override
			public class_1799 method_7601(@NotNull class_1657 player, int i) {
				return class_1799.field_8037;
			}

			@Override
			public boolean method_7597(@NotNull class_1657 player) {
				return false;
			}
		}, 3, 3);
		for (int i = 0; i < craft.method_5439(); i++) {
			class_1799 stack = getItemHandler().method_5438(i);

			if (stack.method_7960() || isLocked(i) || stack.method_31574(BotaniaItems.placeholder)) {
				continue;
			}

			craft.method_5447(i, stack);
		}

		Optional<class_3955> matchingRecipe = getMatchingRecipe(craft);
		matchingRecipe.ifPresent(recipe -> {
			craftResult = recipe.method_8116(craft);

			// Given some mods can return air by a bad implementation of their recipe handler,
			// check for air before continuting on.
			if (craftResult.method_7960()) {
				// We have air, do not continue.
				matchFailed = true;
				return;
			}

			class_1263 handler = getItemHandler();
			List<class_1799> remainders = recipe.method_8111(craft);

			for (int i = 0; i < craft.method_5439(); i++) {
				class_1799 s = remainders.get(i);
				class_1799 inSlot = handler.method_5438(i);
				if ((inSlot.method_7960() && s.method_7960())
						|| (!inSlot.method_7960() && inSlot.method_31574(BotaniaItems.placeholder))) {
					continue;
				}
				handler.method_5447(i, s);
			}
		});
		if (!matchingRecipe.isPresent()) {
			matchFailed = true;
		}

		field_11863.method_16107().method_15407();
		// Return only if present and not air.
		return matchingRecipe.isPresent() && !craftResult.method_7960();
	}

	private Optional<class_3955> getMatchingRecipe(class_1715 craft) {
		for (class_2960 currentRecipe : lastRecipes) {
			class_1860<class_1715> recipe = ((RecipeManagerAccessor) field_11863.method_8433())
					.botania_getAll(class_3956.field_17545)
					.get(currentRecipe);
			if (recipe instanceof class_3955 craftingRecipe && recipe.method_8115(craft, field_11863)) {
				return Optional.of(craftingRecipe);
			}
		}
		Optional<class_3955> recipe = field_11863.method_8433().method_8132(class_3956.field_17545, craft, field_11863);
		if (recipe.isPresent()) {
			if (lastRecipes.size() >= 8) {
				lastRecipes.remove();
			}
			lastRecipes.add(recipe.get().method_8114());
			return recipe;
		}
		return Optional.empty();
	}

	boolean isFull() {
		for (int i = 0; i < getItemHandler().method_5439(); i++) {
			if (!isLocked(i) && getItemHandler().method_5438(i).method_7960()) {
				return false;
			}
		}

		return true;
	}

	private void ejectAll() {
		for (int i = 0; i < inventorySize(); ++i) {
			class_1799 stack = getItemHandler().method_5438(i);
			if (!stack.method_7960()) {
				eject(stack, false);
				getItemHandler().method_5447(i, class_1799.field_8037);
			}
		}
		if (!craftResult.method_7960()) {
			eject(craftResult, false);
			craftResult = class_1799.field_8037;
		}
	}

	@Override
	public boolean onUsedByWand(@Nullable class_1657 player, class_1799 stack, class_2350 side) {
		if (!method_10997().field_9236 && canEject()) {
			craft(false);
			ejectAll();
		}
		return true;
	}

	@Override
	public void method_5431() {
		super.method_5431();
		if (field_11863 != null && !field_11863.field_9236) {
			this.dirty = true;
			this.matchFailed = false;
		}
	}

	public int getSignal() {
		return signal;
	}

	public static class WandHud implements WandHUD {
		private final CraftyCrateBlockEntity crate;

		public WandHud(CraftyCrateBlockEntity crate) {
			this.crate = crate;
		}

		@Override
		public void renderHUD(class_4587 ms, class_310 mc) {
			int width = 52;
			int height = 52;
			int xc = mc.method_22683().method_4486() / 2 + 20;
			int yc = mc.method_22683().method_4502() / 2 - height / 2;

			class_332.method_25294(ms, xc - 6, yc - 6, xc + width + 6, yc + height + 6, 0x22000000);
			class_332.method_25294(ms, xc - 4, yc - 4, xc + width + 4, yc + height + 4, 0x22000000);

			for (int i = 0; i < 3; i++) {
				for (int j = 0; j < 3; j++) {
					int index = i * 3 + j;
					int xp = xc + j * 18;
					int yp = yc + i * 18;

					boolean enabled = true;
					if (crate.getPattern() != CraftyCratePattern.NONE) {
						enabled = crate.getPattern().openSlots.get(index);
					}

					class_332.method_25294(ms, xp, yp, xp + 16, yp + 16, enabled ? 0x22FFFFFF : 0x22FF0000);

					class_1799 item = crate.getItemHandler().method_5438(index);
					mc.method_1480().method_4023(item, xp, yp);
				}
			}
		}
	}
}
