/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.class_124;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1646;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3730;
import net.minecraft.class_3854;
import net.minecraft.class_5250;
import net.minecraft.class_5425;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.world.entity.*;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.common.lib.BotaniaTags;

import java.util.ArrayList;
import java.util.List;

public class CocoonBlockEntity extends BotaniaBlockEntity {
	private static final String TAG_TIME_PASSED = "timePassed";
	private static final String TAG_EMERALDS_GIVEN = "emeraldsGiven";
	private static final String TAG_CHORUS_FRUIT_GIVEN = "chorusFruitGiven";
	private static final String TAG_GAIA_SPIRIT_GIVEN = "gaiaSpiritGiven";

	public static final int TOTAL_TIME = 2400;
	public static final int MAX_EMERALDS = 20;
	public static final int MAX_CHORUS_FRUITS = 20;
	private static final float SPECIAL_CHANCE = 0.075F;

	public int timePassed;
	public int emeraldsGiven;
	public int chorusFruitGiven;
	public boolean gaiaSpiritGiven;

	public CocoonBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.COCOON, pos, state);
	}

	public static void commonTick(class_1937 level, class_2338 worldPosition, class_2680 state, CocoonBlockEntity self) {
		self.timePassed++;
		if (self.timePassed >= TOTAL_TIME) {
			self.hatch();
		}
	}

	private void hatch() {
		if (!field_11863.field_9236) {
			timePassed = 0;
			field_11863.method_22352(field_11867, false);

			class_1308 entity = null;
			class_2338 placePos = field_11867;
			float rareChance = gaiaSpiritGiven ? 1F : SPECIAL_CHANCE;

			float villagerChance = Math.min(1F, (float) emeraldsGiven / (float) MAX_EMERALDS);
			float shulkerChance = Math.min(1F, (float) chorusFruitGiven / (float) MAX_CHORUS_FRUITS);

			List<class_2338> validWater = new ArrayList<>();
			for (class_2350 d : class_2350.values()) {
				class_2338 blockPos = (d == class_2350.field_11036) ? field_11867 : field_11867.method_10093(d);
				if (field_11863.method_22340(blockPos)
						&& field_11863.method_8320(blockPos).method_27852(class_2246.field_10382)) {
					validWater.add(blockPos);
				}
			}

			if (Math.random() < shulkerChance) {
				entity = class_1299.field_6109.method_5883(field_11863);
			} else if (Math.random() < villagerChance) {
				class_1646 villager = class_1299.field_6077.method_5883(field_11863);
				if (villager != null) {
					class_3854 type = class_3854.method_16930(field_11863.method_23753(field_11867));
					villager.method_7195(villager.method_7231().method_16922(type));
				}
				entity = villager;
			} else if (!validWater.isEmpty()) {
				placePos = validWater.get(field_11863.field_9229.method_43048(validWater.size()));
				if (Math.random() < rareChance) {
					entity = random(BotaniaTags.Entities.COCOON_RARE_AQUATIC);
				} else {
					entity = random(BotaniaTags.Entities.COCOON_COMMON_AQUATIC);
				}
			} else {
				if (Math.random() < rareChance) {
					entity = random(BotaniaTags.Entities.COCOON_RARE);
				} else {
					entity = random(BotaniaTags.Entities.COCOON_COMMON);
				}
			}

			if (entity != null) {
				if (field_11863.field_9229.method_43057() < 0.01) {
					// gonna make modded minecraft items into a gacha game
					// and somehow find a way to add jeanne d'arc to it
					// - Vazkii 2021
					var name = class_2561.method_43470("Jeanne d'");
					name.method_10852(entity.method_5477());
					name.method_10852(class_2561.method_43470(" [SSR]"));
					entity.method_5665(name.method_27692(class_124.field_1065));
					entity.method_5880(true);
				}

				entity.method_5814(placePos.method_10263() + 0.5, placePos.method_10264() + 0.5, placePos.method_10260() + 0.5);
				if (entity instanceof class_1296 ageable) {
					ageable.method_5614(-24000);
				}
				entity.method_5943((class_5425) field_11863, field_11863.method_8404(method_11016()), class_3730.field_16467, null, null);
				entity.method_5971();
				field_11863.method_8649(entity);
				entity.method_5990();
			}
		}
	}

	public void forceRare() {
		gaiaSpiritGiven = true;
		timePassed = Math.max(timePassed, TOTAL_TIME / 2);
	}

	@Nullable
	private class_1308 random(class_6862<class_1299<?>> tag) {
		class_1299<?> type = class_2378.field_11145.method_40266(tag)
				.flatMap(t -> t.method_40243(field_11863.field_9229))
				.map(class_6880::comp_349)
				.orElse(null);
		if (type == null) {
			return null;
		}

		if (type == class_1299.field_6085 && field_11863.field_9229.method_43057() < 0.01) {
			type = class_1299.field_6143;
		}
		class_1297 entity = type.method_5883(field_11863);
		return entity instanceof class_1308 mob ? mob : null;
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		cmp.method_10569(TAG_TIME_PASSED, timePassed);
		cmp.method_10569(TAG_EMERALDS_GIVEN, emeraldsGiven);
		cmp.method_10569(TAG_CHORUS_FRUIT_GIVEN, chorusFruitGiven);
		cmp.method_10556(TAG_GAIA_SPIRIT_GIVEN, gaiaSpiritGiven);
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		timePassed = cmp.method_10550(TAG_TIME_PASSED);
		emeraldsGiven = cmp.method_10550(TAG_EMERALDS_GIVEN);
		chorusFruitGiven = cmp.method_10550(TAG_CHORUS_FRUIT_GIVEN);
		gaiaSpiritGiven = cmp.method_10577(TAG_GAIA_SPIRIT_GIVEN);
	}
}
