/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity;

import vazkii.botania.api.block.Avatar;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.AvatarWieldable;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2741;

public class AvatarBlockEntity extends SimpleInventoryBlockEntity implements Avatar, ManaReceiver {
	private static final int MAX_MANA = 6400;

	private static final String TAG_ENABLED = "enabled";
	private static final String TAG_TICKS_ELAPSED = "ticksElapsed";
	private static final String TAG_MANA = "mana";
	private static final String TAG_COOLDOWNS = "boostCooldowns";

	private boolean enabled;
	private int ticksElapsed;
	private int mana;
	private final Map<UUID, Integer> boostCooldowns = new HashMap<>();

	public AvatarBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.AVATAR, pos, state);
	}

	public static void commonTick(class_1937 level, class_2338 worldPosition, class_2680 state, AvatarBlockEntity self) {
		self.enabled = !level.method_8479(worldPosition);

		class_1799 stack = self.getItemHandler().method_5438(0);
		if (!stack.method_7960()) {
			var wieldable = XplatAbstractions.INSTANCE.findAvatarWieldable(stack);
			if (wieldable != null) {
				wieldable.onAvatarUpdate(self);
			}
		}

		if (self.enabled) {
			self.ticksElapsed++;
		}
	}

	@Override
	public void writePacketNBT(class_2487 tag) {
		super.writePacketNBT(tag);
		tag.method_10556(TAG_ENABLED, enabled);
		tag.method_10569(TAG_TICKS_ELAPSED, ticksElapsed);
		tag.method_10569(TAG_MANA, mana);
		class_2499 boostCooldowns = new class_2499();
		for (Map.Entry<UUID, Integer> e : this.boostCooldowns.entrySet()) {
			class_2487 cmp = new class_2487();
			cmp.method_25927("id", e.getKey());
			cmp.method_10569("cooldown", e.getValue());
			boostCooldowns.add(cmp);
		}
		tag.method_10566(TAG_COOLDOWNS, boostCooldowns);
	}

	@Override
	public void readPacketNBT(class_2487 tag) {
		super.readPacketNBT(tag);
		enabled = tag.method_10577(TAG_ENABLED);
		ticksElapsed = tag.method_10550(TAG_TICKS_ELAPSED);
		mana = tag.method_10550(TAG_MANA);
		boostCooldowns.clear();
		class_2499 boostCooldowns = tag.method_10554(TAG_COOLDOWNS, class_2520.field_33260);
		for (class_2520 nbt : boostCooldowns) {
			class_2487 cmp = ((class_2487) nbt);
			UUID id = cmp.method_25926("id");
			int cooldown = cmp.method_10550("cooldown");
			this.boostCooldowns.put(id, cooldown);
		}
	}

	@Override
	protected class_1277 createItemHandler() {
		return new class_1277(1) {
			@Override
			public int method_5444() {
				return 1;
			}
		};
	}

	@Override
	public void method_5431() {
		super.method_5431();
		if (field_11863 != null && !field_11863.field_9236) {
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		}
	}

	@Override
	public boolean isFull() {
		return mana >= MAX_MANA;
	}

	@Override
	public void receiveMana(int mana) {
		this.mana = Math.min(3 * MAX_MANA, this.mana + mana);
	}

	@Override
	public boolean canReceiveManaFromBursts() {
		return !getItemHandler().method_5438(0).method_7960();
	}

	@Override
	public class_1937 getManaReceiverLevel() {
		return method_10997();
	}

	@Override
	public class_2338 getManaReceiverPos() {
		return method_11016();
	}

	@Override
	public int getCurrentMana() {
		return mana;
	}

	@Override
	public class_1263 getInventory() {
		return getItemHandler();
	}

	@Override
	public class_2350 getAvatarFacing() {
		return method_11010().method_11654(class_2741.field_12481);
	}

	@Override
	public int getElapsedFunctionalTicks() {
		return ticksElapsed;
	}

	@Override
	public boolean isEnabled() {
		return enabled;
	}

	@Override
	public Map<UUID, Integer> getBoostCooldowns() {
		return boostCooldowns;
	}
}
