/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity;

import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaTrigger;
import vazkii.botania.common.block.BotaniaBlocks;

import java.util.Arrays;
import java.util.Locale;
import net.minecraft.class_1074;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2390;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class AnimatedTorchBlockEntity extends BotaniaBlockEntity implements ManaTrigger, Wandable {
	private static final String TAG_SIDE = "side";
	private static final String TAG_ROTATING = "rotating";
	private static final String TAG_ROTATION_TICKS = "rotationTicks";
	private static final String TAG_ANGLE_PER_TICK = "anglePerTick";
	private static final String TAG_TORCH_MODE = "torchMode";
	private static final String TAG_NEXT_RANDOM_ROTATION = "nextRandomRotation";

	public static final class_2350[] SIDES = new class_2350[] {
			class_2350.field_11043,
			class_2350.field_11034,
			class_2350.field_11035,
			class_2350.field_11039
	};

	public int side;
	public double rotation;
	public boolean rotating;
	public double lastTickRotation;
	public int nextRandomRotation = class_3532.method_15357(Math.random() * 3);
	public int currentRandomRotation;

	private int rotationTicks;
	public double anglePerTick;

	private TorchMode torchMode = TorchMode.TOGGLE;

	public AnimatedTorchBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.ANIMATED_TORCH, pos, state);
	}

	public void handRotate() {
		if (!field_11863.field_9236) {
			field_11863.method_8427(method_11016(), BotaniaBlocks.animatedTorch, 0, (side + 1) % 4);
		}
	}

	public void onPlace(@Nullable class_1309 entity) {
		if (entity != null) {
			side = Arrays.asList(SIDES).indexOf(entity.method_5735().method_10153());
		}
		field_11863.method_8452(method_11016().method_10093(SIDES[side].method_10153()), method_11010().method_26204());
	}

	public void toggle() {
		if (!field_11863.field_9236) {
			field_11863.method_8427(method_11016(), BotaniaBlocks.animatedTorch, 0, torchMode.modeSwitcher.rotate(this, side));
			nextRandomRotation = field_11863.field_9229.method_43048(4);
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		}
	}

	@Override
	public boolean onUsedByWand(class_1657 player, class_1799 stack, class_2350 side) {
		int modeOrdinal = torchMode.ordinal();
		TorchMode[] modes = TorchMode.values();

		torchMode = modes[(modeOrdinal + 1) % modes.length];
		return true;
	}

	@Override
	public boolean method_11004(int id, int param) {
		if (id == 0) {
			rotateTo(param);
			return true;
		} else {
			return super.method_11004(id, param);
		}
	}

	private void rotateTo(int side) {
		if (rotating) {
			return;
		}

		currentRandomRotation = nextRandomRotation;
		int finalRotation = side * 90;

		double diff = (finalRotation - rotation % 360) % 360;
		if (diff < 0) {
			diff = 360 + diff;
		}

		rotationTicks = 4;
		anglePerTick = diff / rotationTicks;
		this.side = side;
		rotating = true;

		// tell neighbors that signal is off because we are rotating
		field_11863.method_8452(method_11016(), method_11010().method_26204());
		for (class_2350 e : class_2350.values()) {
			field_11863.method_8452(method_11016().method_10093(e), method_11010().method_26204());
		}
	}

	@Override
	public void onBurstCollision(ManaBurst burst) {
		if (!burst.isFake()) {
			toggle();
		}
	}

	public static class WandHud implements WandHUD {
		private final AnimatedTorchBlockEntity torch;

		public WandHud(AnimatedTorchBlockEntity torch) {
			this.torch = torch;
		}

		@Override
		public void renderHUD(class_4587 ms, class_310 mc) {
			int x = mc.method_22683().method_4486() / 2 + 10;
			int y = mc.method_22683().method_4502() / 2 - 8;

			mc.method_1480().method_4023(new class_1799(class_2246.field_10523), x, y);
			mc.field_1772.method_1720(ms, class_1074.method_4662("botania.animatedTorch." + torch.torchMode.name().toLowerCase(Locale.ROOT)), x + 18, y + 6, 0xFF4444);
		}
	}

	public static void commonTick(class_1937 level, class_2338 worldPosition, class_2680 state, AnimatedTorchBlockEntity self) {
		if (self.rotating) {
			self.lastTickRotation = self.rotation;
			self.rotation = (self.rotation + self.anglePerTick) % 360;
			self.rotationTicks--;

			if (self.rotationTicks <= 0) {
				self.rotating = false;
				// done rotating, tell neighbors
				level.method_8452(worldPosition, state.method_26204());
				for (class_2350 e : class_2350.values()) {
					level.method_8452(worldPosition.method_10093(e), state.method_26204());
				}
			}

		} else {
			self.rotation = self.side * 90;
		}

		if (level.field_9236) {
			int amt = self.rotating ? 3 : Math.random() < 0.1 ? 1 : 0;
			double x = worldPosition.method_10263() + 0.5 + Math.cos((self.rotation + 90) / 180.0 * Math.PI) * 0.35;
			double y = worldPosition.method_10264() + 0.2;
			double z = worldPosition.method_10260() + 0.5 + Math.sin((self.rotation + 90) / 180.0 * Math.PI) * 0.35;

			for (int i = 0; i < amt; i++) {
				level.method_8406(class_2390.field_11188, x, y, z, 0.0D, 0.0D, 0.0D);
			}
		}
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		cmp.method_10569(TAG_SIDE, side);
		cmp.method_10556(TAG_ROTATING, rotating);
		cmp.method_10569(TAG_ROTATION_TICKS, rotationTicks);
		cmp.method_10549(TAG_ANGLE_PER_TICK, anglePerTick);
		cmp.method_10569(TAG_TORCH_MODE, torchMode.ordinal());
		cmp.method_10569(TAG_NEXT_RANDOM_ROTATION, nextRandomRotation);
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		side = cmp.method_10550(TAG_SIDE);
		rotating = cmp.method_10577(TAG_ROTATING);
		if (field_11863 != null && !field_11863.field_9236) {
			rotationTicks = cmp.method_10550(TAG_ROTATION_TICKS);
		}
		anglePerTick = cmp.method_10574(TAG_ANGLE_PER_TICK);
		nextRandomRotation = cmp.method_10550(TAG_NEXT_RANDOM_ROTATION);

		int modeOrdinal = cmp.method_10550(TAG_TORCH_MODE);
		TorchMode[] modes = TorchMode.values();
		torchMode = modes[modeOrdinal % modes.length];
	}

	public enum TorchMode {
		TOGGLE((t, i) -> (i + 2) % 4),
		ROTATE((t, i) -> (i + 1) % 4),
		RANDOM((t, i) -> t.currentRandomRotation);

		TorchMode(RotationHandler modeSwitcher) {
			this.modeSwitcher = modeSwitcher;
		}

		public final RotationHandler modeSwitcher;

		private interface RotationHandler {
			int rotate(AnimatedTorchBlockEntity tile, int curr);
		}
	}
}
