/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.state.enums.LuminizerVariant;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.LuminizerBlockEntity;
import vazkii.botania.common.item.BotaniaItems;

public class LuminizerBlock extends BotaniaWaterloggedBlock implements class_2343 {

	private static final class_265 SHAPE = method_9541(5, 5, 5, 11, 11, 11);
	public final LuminizerVariant variant;

	protected LuminizerBlock(LuminizerVariant variant, class_2251 builder) {
		super(builder);
		this.variant = variant;
		method_9590(method_9564().method_11657(class_2741.field_12484, false));
	}

	@NotNull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		super.method_9515(builder);
		builder.method_11667(class_2741.field_12484);
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		class_1799 stack = player.method_5998(hand);
		class_2586 te = world.method_8321(pos);
		if (te instanceof LuminizerBlockEntity relay) {
			if (stack.method_31574(BotaniaItems.phantomInk) && !relay.isNoParticle()) {
				if (!world.field_9236) {
					stack.method_7934(1);
					relay.setNoParticle();
					VanillaPacketDispatcher.dispatchTEToNearbyPlayers(relay);
				}
				return class_1269.method_29236(world.method_8608());
			} else if (!stack.method_31574(class_1802.field_8634)) {
				relay.mountEntity(player);
				return class_1269.method_29236(world.method_8608());
			}
		}

		return class_1269.field_5811;
	}

	@Override
	public void method_9612(class_2680 state, class_1937 worldIn, class_2338 pos, class_2248 blockIn, class_2338 fromPos, boolean isMoving) {
		if (!worldIn.field_9236 && variant == LuminizerVariant.TOGGLE) {
			if (state.method_11654(class_2741.field_12484) && !worldIn.method_8479(pos)) {
				worldIn.method_8501(pos, state.method_11657(class_2741.field_12484, false));
			} else if (!state.method_11654(class_2741.field_12484) && worldIn.method_8479(pos)) {
				worldIn.method_8501(pos, state.method_11657(class_2741.field_12484, true));
			}
		}
	}

	@Override
	public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 rand) {
		world.method_8501(pos, state.method_11657(class_2741.field_12484, false));
	}

	@Override
	public boolean method_9506(class_2680 state) {
		return variant == LuminizerVariant.DETECTOR;
	}

	@Override
	public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 s) {
		return variant == LuminizerVariant.DETECTOR
				&& state.method_11654(class_2741.field_12484) ? 15 : 0;
	}

	@NotNull
	@Override
	public class_2464 method_9604(class_2680 state) {
		return class_2464.field_11456;
	}

	@NotNull
	@Override
	public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		return new LuminizerBlockEntity(pos, state);
	}

	@Nullable
	@Override
	public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
		return createTickerHelper(type, BotaniaBlockEntities.LIGHT_RELAY, level.field_9236 ? LuminizerBlockEntity::clientTick : LuminizerBlockEntity::serverTick);
	}

}
