/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.HoveringHourglassBlockEntity;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.common.item.WandOfTheForestItem;

public class HoveringHourglassBlock extends BotaniaWaterloggedBlock implements class_2343 {

	private static final class_265 SHAPE = method_9541(4, 0, 4, 12, 18.4, 12);

	protected HoveringHourglassBlock(class_2251 builder) {
		super(builder);
		method_9590(method_9564().method_11657(class_2741.field_12484, false));
	}

	@NotNull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		super.method_9515(builder);
		builder.method_11667(class_2741.field_12484);
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		HoveringHourglassBlockEntity hourglass = (HoveringHourglassBlockEntity) world.method_8321(pos);
		class_1799 hgStack = hourglass.getItemHandler().method_5438(0);
		class_1799 stack = player.method_5998(hand);
		if (!stack.method_7960() && stack.method_7909() instanceof WandOfTheForestItem) {
			return class_1269.field_5811;
		}

		if (hourglass.lock) {
			if (!player.field_6002.field_9236 && hand == class_1268.field_5810) {
				player.method_43496(class_2561.method_43471("botaniamisc.hourglassLock"));
			}
			return class_1269.field_5814;
		}

		if (hgStack.method_7960() && HoveringHourglassBlockEntity.getStackItemTime(stack) > 0) {
			hourglass.getItemHandler().method_5447(0, stack.method_7972());
			stack.method_7939(0);
			return class_1269.method_29236(world.method_8608());
		} else if (!hgStack.method_7960()) {
			player.method_31548().method_7398(hgStack);
			hourglass.getItemHandler().method_5447(0, class_1799.field_8037);
			return class_1269.method_29236(world.method_8608());
		}

		return class_1269.field_5811;
	}

	@Override
	public boolean method_9506(class_2680 state) {
		return true;
	}

	@Override
	public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 side) {
		return state.method_11654(class_2741.field_12484) ? 15 : 0;
	}

	@Override
	public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 rand) {
		if (state.method_11654(class_2741.field_12484)) {
			world.method_8501(pos, state.method_11657(class_2741.field_12484, false));
		}
	}

	@Override
	public void method_9536(@NotNull class_2680 state, @NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_2680 newState, boolean isMoving) {
		if (!state.method_27852(newState.method_26204())) {
			class_2586 be = world.method_8321(pos);
			if (be instanceof SimpleInventoryBlockEntity inventory) {
				class_1264.method_5451(world, pos, inventory.getItemHandler());
			}
			super.method_9536(state, world, pos, newState, isMoving);
		}
	}

	@NotNull
	@Override
	public class_2464 method_9604(class_2680 state) {
		return class_2464.field_11456;
	}

	@NotNull
	@Override
	public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		return new HoveringHourglassBlockEntity(pos, state);
	}

	@Nullable
	@Override
	public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
		return createTickerHelper(type, BotaniaBlockEntities.HOURGLASS, HoveringHourglassBlockEntity::commonTick);
	}
}
