/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import vazkii.botania.common.block.decor.BotaniaDirectionalBlock;
import vazkii.botania.common.block.decor.panes.BotaniaPaneBlock;
import vazkii.botania.common.block.decor.stairs.BotaniaStairBlock;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.LibBlockNames;

import java.util.function.BiConsumer;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2378;
import net.minecraft.class_2465;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2544;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_4970;

import static vazkii.botania.common.block.BotaniaBlocks.*;
import static vazkii.botania.common.lib.LibBlockNames.*;
import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public final class BotaniaFluffBlocks {
	public static final class_2248 livingwoodStairs = new BotaniaStairBlock(livingwood.method_9564(), class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 livingwoodSlab = new class_2482(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 livingwoodWall = new class_2544(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 livingwoodFence = new class_2354(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 livingwoodFenceGate = new class_2349(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 livingwoodStrippedStairs = new BotaniaStairBlock(livingwoodStripped.method_9564(), class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 livingwoodStrippedSlab = new class_2482(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 livingwoodStrippedWall = new class_2544(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 livingwoodPlankStairs = new BotaniaStairBlock(livingwoodPlanks.method_9564(), class_4970.class_2251.method_9630(livingwoodPlanks));
	public static final class_2248 livingwoodPlankSlab = new class_2482(class_4970.class_2251.method_9630(livingwoodPlanks));

	public static final class_2248 livingrockStairs = new BotaniaStairBlock(livingrock.method_9564(), class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 livingrockSlab = new class_2482(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 livingrockWall = new class_2544(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 livingrockPolishedStairs = new BotaniaStairBlock(livingrock.method_9564(), class_4970.class_2251.method_9630(livingrockPolished));
	public static final class_2248 livingrockPolishedSlab = new class_2482(class_4970.class_2251.method_9630(livingrockPolished));
	public static final class_2248 livingrockPolishedWall = new class_2544(class_4970.class_2251.method_9630(livingrockPolished));
	public static final class_2248 livingrockBrickStairs = new BotaniaStairBlock(livingrockBrick.method_9564(), class_4970.class_2251.method_9630(livingrockBrick));
	public static final class_2248 livingrockBrickSlab = new class_2482(class_4970.class_2251.method_9630(livingrockBrick));
	public static final class_2248 livingrockBrickWall = new class_2544(class_4970.class_2251.method_9630(livingrockBrick));
	public static final class_2248 livingrockBrickMossyStairs = new BotaniaStairBlock(livingrockBrickMossy.method_9564(), class_4970.class_2251.method_9630(livingrockBrickMossy));
	public static final class_2248 livingrockBrickMossySlab = new class_2482(class_4970.class_2251.method_9630(livingrockBrickMossy));
	public static final class_2248 livingrockBrickMossyWall = new class_2544(class_4970.class_2251.method_9630(livingrockBrickMossy));

	public static final class_2248 dreamwoodStairs = new BotaniaStairBlock(dreamwood.method_9564(), class_4970.class_2251.method_9630(dreamwood));
	public static final class_2248 dreamwoodSlab = new class_2482(class_4970.class_2251.method_9630(dreamwood));
	public static final class_2248 dreamwoodWall = new class_2544(class_4970.class_2251.method_9630(dreamwood));
	public static final class_2248 dreamwoodFence = new class_2354(class_4970.class_2251.method_9630(dreamwood));
	public static final class_2248 dreamwoodFenceGate = new class_2349(class_4970.class_2251.method_9630(dreamwood));
	public static final class_2248 dreamwoodStrippedStairs = new BotaniaStairBlock(dreamwoodStripped.method_9564(), class_4970.class_2251.method_9630(dreamwood));
	public static final class_2248 dreamwoodStrippedSlab = new class_2482(class_4970.class_2251.method_9630(dreamwood));
	public static final class_2248 dreamwoodStrippedWall = new class_2544(class_4970.class_2251.method_9630(dreamwood));
	public static final class_2248 dreamwoodPlankStairs = new BotaniaStairBlock(dreamwoodPlanks.method_9564(), class_4970.class_2251.method_9630(dreamwoodPlanks));
	public static final class_2248 dreamwoodPlankSlab = new class_2482(class_4970.class_2251.method_9630(dreamwoodPlanks));

	public static final class_2248 darkQuartz = new BotaniaBlock(class_4970.class_2251.method_9630(class_2246.field_10153));
	public static final class_2248 darkQuartzChiseled = new BotaniaBlock(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 darkQuartzPillar = new class_2465(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 darkQuartzSlab = new class_2482(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 darkQuartzStairs = new BotaniaStairBlock(darkQuartz.method_9564(), class_4970.class_2251.method_9630(darkQuartz));

	public static final class_2248 manaQuartz = new BotaniaBlock(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 manaQuartzChiseled = new BotaniaBlock(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 manaQuartzPillar = new class_2465(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 manaQuartzSlab = new class_2482(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 manaQuartzStairs = new BotaniaStairBlock(darkQuartz.method_9564(), class_4970.class_2251.method_9630(darkQuartz));

	public static final class_2248 blazeQuartz = new BotaniaBlock(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 blazeQuartzChiseled = new BotaniaBlock(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 blazeQuartzPillar = new class_2465(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 blazeQuartzSlab = new class_2482(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 blazeQuartzStairs = new BotaniaStairBlock(darkQuartz.method_9564(), class_4970.class_2251.method_9630(darkQuartz));

	public static final class_2248 lavenderQuartz = new BotaniaBlock(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 lavenderQuartzChiseled = new BotaniaBlock(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 lavenderQuartzPillar = new class_2465(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 lavenderQuartzSlab = new class_2482(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 lavenderQuartzStairs = new BotaniaStairBlock(darkQuartz.method_9564(), class_4970.class_2251.method_9630(darkQuartz));

	public static final class_2248 redQuartz = new BotaniaBlock(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 redQuartzChiseled = new BotaniaBlock(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 redQuartzPillar = new class_2465(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 redQuartzSlab = new class_2482(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 redQuartzStairs = new BotaniaStairBlock(darkQuartz.method_9564(), class_4970.class_2251.method_9630(darkQuartz));

	public static final class_2248 elfQuartz = new BotaniaBlock(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 elfQuartzChiseled = new BotaniaBlock(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 elfQuartzPillar = new class_2465(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 elfQuartzSlab = new class_2482(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 elfQuartzStairs = new BotaniaStairBlock(darkQuartz.method_9564(), class_4970.class_2251.method_9630(darkQuartz));

	public static final class_2248 sunnyQuartz = new BotaniaBlock(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 sunnyQuartzChiseled = new BotaniaBlock(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 sunnyQuartzPillar = new class_2465(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 sunnyQuartzSlab = new class_2482(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 sunnyQuartzStairs = new BotaniaStairBlock(darkQuartz.method_9564(), class_4970.class_2251.method_9630(darkQuartz));

	public static final class_2248 whitePavement = new BotaniaBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 whitePavementStair = new BotaniaStairBlock(whitePavement.method_9564(), class_4970.class_2251.method_9630(whitePavement));
	public static final class_2248 whitePavementSlab = new class_2482(class_4970.class_2251.method_9630(whitePavement));

	public static final class_2248 blackPavement = new BotaniaBlock(class_4970.class_2251.method_9630(whitePavement));
	public static final class_2248 blackPavementStair = new BotaniaStairBlock(whitePavement.method_9564(), class_4970.class_2251.method_9630(whitePavement));
	public static final class_2248 blackPavementSlab = new class_2482(class_4970.class_2251.method_9630(whitePavement));

	public static final class_2248 bluePavement = new BotaniaBlock(class_4970.class_2251.method_9630(whitePavement));
	public static final class_2248 bluePavementStair = new BotaniaStairBlock(whitePavement.method_9564(), class_4970.class_2251.method_9630(whitePavement));
	public static final class_2248 bluePavementSlab = new class_2482(class_4970.class_2251.method_9630(whitePavement));

	public static final class_2248 yellowPavement = new BotaniaBlock(class_4970.class_2251.method_9630(whitePavement));
	public static final class_2248 yellowPavementStair = new BotaniaStairBlock(whitePavement.method_9564(), class_4970.class_2251.method_9630(whitePavement));
	public static final class_2248 yellowPavementSlab = new class_2482(class_4970.class_2251.method_9630(whitePavement));

	public static final class_2248 redPavement = new BotaniaBlock(class_4970.class_2251.method_9630(whitePavement));
	public static final class_2248 redPavementStair = new BotaniaStairBlock(whitePavement.method_9564(), class_4970.class_2251.method_9630(whitePavement));
	public static final class_2248 redPavementSlab = new class_2482(class_4970.class_2251.method_9630(whitePavement));

	public static final class_2248 greenPavement = new BotaniaBlock(class_4970.class_2251.method_9630(whitePavement));
	public static final class_2248 greenPavementStair = new BotaniaStairBlock(whitePavement.method_9564(), class_4970.class_2251.method_9630(whitePavement));
	public static final class_2248 greenPavementSlab = new class_2482(class_4970.class_2251.method_9630(whitePavement));

	public static final class_2248 biomeStoneForest = new BotaniaBlock(class_4970.class_2251.method_9637(class_3614.field_15914).method_9629(1.5F, 10).method_9626(class_2498.field_27202).method_29292());
	public static final class_2248 biomeStoneForestSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeStoneForestStairs = new BotaniaStairBlock(biomeStoneForest.method_9564(), class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeStoneForestWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeCobblestoneForest = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeCobblestoneForestSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeCobblestoneForestStairs = new BotaniaStairBlock(biomeStoneForest.method_9564(), class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeCobblestoneForestWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeBrickForest = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeBrickForestSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeBrickForestStairs = new BotaniaStairBlock(biomeStoneForest.method_9564(), class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeBrickForestWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeChiseledBrickForest = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneForest));

	public static final class_2248 biomeStonePlains = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneForest).method_9626(class_2498.field_27203));
	public static final class_2248 biomeStonePlainsSlab = new class_2482(class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeStonePlainsStairs = new BotaniaStairBlock(biomeStonePlains.method_9564(), class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeStonePlainsWall = new class_2544(class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeCobblestonePlains = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeCobblestonePlainsSlab = new class_2482(class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeCobblestonePlainsStairs = new BotaniaStairBlock(biomeStonePlains.method_9564(), class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeCobblestonePlainsWall = new class_2544(class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeBrickPlains = new class_2465(class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeBrickPlainsSlab = new class_2482(class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeBrickPlainsStairs = new BotaniaStairBlock(biomeStonePlains.method_9564(), class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeBrickPlainsWall = new class_2544(class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeChiseledBrickPlains = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStonePlains));

	public static final class_2248 biomeStoneMountain = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneForest).method_9626(class_2498.field_29035));
	public static final class_2248 biomeStoneMountainSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeStoneMountainStairs = new BotaniaStairBlock(biomeStoneMountain.method_9564(), class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeStoneMountainWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeCobblestoneMountain = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeCobblestoneMountainSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeCobblestoneMountainStairs = new BotaniaStairBlock(biomeStoneMountain.method_9564(), class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeCobblestoneMountainWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeBrickMountain = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeBrickMountainSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeBrickMountainStairs = new BotaniaStairBlock(biomeStoneMountain.method_9564(), class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeBrickMountainWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeChiseledBrickMountain = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneMountain));

	public static final class_2248 biomeStoneFungal = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneForest).method_9626(class_2498.field_29034));
	public static final class_2248 biomeStoneFungalSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeStoneFungalStairs = new BotaniaStairBlock(biomeStoneFungal.method_9564(), class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeStoneFungalWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeCobblestoneFungal = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeCobblestoneFungalSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeCobblestoneFungalStairs = new BotaniaStairBlock(biomeStoneFungal.method_9564(), class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeCobblestoneFungalWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeBrickFungal = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeBrickFungalSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeBrickFungalStairs = new BotaniaStairBlock(biomeStoneFungal.method_9564(), class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeBrickFungalWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeChiseledBrickFungal = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneFungal));

	public static final class_2248 biomeStoneSwamp = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneForest).method_9626(class_2498.field_29035));
	public static final class_2248 biomeStoneSwampSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeStoneSwampStairs = new BotaniaStairBlock(biomeStoneSwamp.method_9564(), class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeStoneSwampWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeCobblestoneSwamp = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeCobblestoneSwampSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeCobblestoneSwampStairs = new BotaniaStairBlock(biomeStoneSwamp.method_9564(), class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeCobblestoneSwampWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeBrickSwamp = new BotaniaDirectionalBlock(class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeBrickSwampSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeBrickSwampStairs = new BotaniaStairBlock(biomeStoneSwamp.method_9564(), class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeBrickSwampWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeChiseledBrickSwamp = new BotaniaDirectionalBlock(class_4970.class_2251.method_9630(biomeStoneSwamp));

	public static final class_2248 biomeStoneDesert = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneForest).method_9626(class_2498.field_29033));
	public static final class_2248 biomeStoneDesertSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeStoneDesertStairs = new BotaniaStairBlock(biomeStoneDesert.method_9564(), class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeStoneDesertWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeCobblestoneDesert = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeCobblestoneDesertSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeCobblestoneDesertStairs = new BotaniaStairBlock(biomeStoneDesert.method_9564(), class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeCobblestoneDesertWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeBrickDesert = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeBrickDesertSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeBrickDesertStairs = new BotaniaStairBlock(biomeStoneDesert.method_9564(), class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeBrickDesertWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeChiseledBrickDesert = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneDesert));

	public static final class_2248 biomeStoneTaiga = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneForest).method_9626(class_2498.field_29033));
	public static final class_2248 biomeStoneTaigaSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeStoneTaigaStairs = new BotaniaStairBlock(biomeStoneTaiga.method_9564(), class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeStoneTaigaWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeCobblestoneTaiga = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeCobblestoneTaigaSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeCobblestoneTaigaStairs = new BotaniaStairBlock(biomeStoneTaiga.method_9564(), class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeCobblestoneTaigaWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeBrickTaiga = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeBrickTaigaSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeBrickTaigaStairs = new BotaniaStairBlock(biomeStoneTaiga.method_9564(), class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeBrickTaigaWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeChiseledBrickTaiga = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneTaiga));

	public static final class_2248 biomeStoneMesa = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneForest).method_9626(class_2498.field_27203));
	public static final class_2248 biomeStoneMesaSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeStoneMesaStairs = new BotaniaStairBlock(biomeStoneMesa.method_9564(), class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeStoneMesaWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeCobblestoneMesa = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeCobblestoneMesaSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeCobblestoneMesaStairs = new BotaniaStairBlock(biomeStoneMesa.method_9564(), class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeCobblestoneMesaWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeBrickMesa = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeBrickMesaSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeBrickMesaStairs = new BotaniaStairBlock(biomeStoneMesa.method_9564(), class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeBrickMesaWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeChiseledBrickMesa = new class_2465(class_4970.class_2251.method_9630(biomeStoneMesa));

	public static final class_2248 shimmerrockSlab = new class_2482(class_4970.class_2251.method_9630(shimmerrock));
	public static final class_2248 shimmerrockStairs = new BotaniaStairBlock(shimmerrock.method_9564(), class_4970.class_2251.method_9630(shimmerrock));

	public static final class_2248 shimmerwoodPlankSlab = new class_2482(class_4970.class_2251.method_9630(shimmerwoodPlanks));
	public static final class_2248 shimmerwoodPlankStairs = new BotaniaStairBlock(shimmerwoodPlanks.method_9564(), class_4970.class_2251.method_9630(shimmerwoodPlanks));

	public static final class_2248 managlassPane = new BotaniaPaneBlock(class_4970.class_2251.method_9630(manaGlass));
	public static final class_2248 alfglassPane = new BotaniaPaneBlock(class_4970.class_2251.method_9630(elfGlass));
	public static final class_2248 bifrostPane = new BotaniaPaneBlock(class_4970.class_2251.method_9630(bifrostPerm));

	public static void registerBlocks(BiConsumer<class_2248, class_2960> r) {

		r.accept(livingwoodStairs, prefix(LibBlockNames.LIVING_WOOD + STAIR_SUFFIX));
		r.accept(livingwoodSlab, prefix(LibBlockNames.LIVING_WOOD + SLAB_SUFFIX));
		r.accept(livingwoodWall, prefix(LibBlockNames.LIVING_WOOD + WALL_SUFFIX));
		r.accept(livingwoodStrippedStairs, prefix(LibBlockNames.LIVING_WOOD_STRIPPED + STAIR_SUFFIX));
		r.accept(livingwoodStrippedSlab, prefix(LibBlockNames.LIVING_WOOD_STRIPPED + SLAB_SUFFIX));
		r.accept(livingwoodStrippedWall, prefix(LibBlockNames.LIVING_WOOD_STRIPPED + WALL_SUFFIX));
		r.accept(livingwoodPlankStairs, prefix(LibBlockNames.LIVING_WOOD_PLANKS + STAIR_SUFFIX));
		r.accept(livingwoodPlankSlab, prefix(LibBlockNames.LIVING_WOOD_PLANKS + SLAB_SUFFIX));
		r.accept(livingwoodFence, prefix(LibBlockNames.LIVING_WOOD + FENCE_SUFFIX));
		r.accept(livingwoodFenceGate, prefix(LibBlockNames.LIVING_WOOD + FENCE_GATE_SUFFIX));

		r.accept(livingrockStairs, prefix(LibBlockNames.LIVING_ROCK + STAIR_SUFFIX));
		r.accept(livingrockSlab, prefix(LibBlockNames.LIVING_ROCK + SLAB_SUFFIX));
		r.accept(livingrockWall, prefix(LibBlockNames.LIVING_ROCK + WALL_SUFFIX));

		r.accept(livingrockPolishedStairs, prefix(LibBlockNames.LIVING_ROCK_POLISHED + STAIR_SUFFIX));
		r.accept(livingrockPolishedSlab, prefix(LibBlockNames.LIVING_ROCK_POLISHED + SLAB_SUFFIX));
		r.accept(livingrockPolishedWall, prefix(LibBlockNames.LIVING_ROCK_POLISHED + WALL_SUFFIX));

		r.accept(livingrockBrickStairs, prefix(LibBlockNames.LIVING_ROCK_BRICK + STAIR_SUFFIX));
		r.accept(livingrockBrickSlab, prefix(LibBlockNames.LIVING_ROCK_BRICK + SLAB_SUFFIX));
		r.accept(livingrockBrickWall, prefix(LibBlockNames.LIVING_ROCK_BRICK + WALL_SUFFIX));

		r.accept(livingrockBrickMossyStairs, prefix(LibBlockNames.LIVING_ROCK_BRICK_MOSSY + STAIR_SUFFIX));
		r.accept(livingrockBrickMossySlab, prefix(LibBlockNames.LIVING_ROCK_BRICK_MOSSY + SLAB_SUFFIX));
		r.accept(livingrockBrickMossyWall, prefix(LibBlockNames.LIVING_ROCK_BRICK_MOSSY + WALL_SUFFIX));

		r.accept(dreamwoodStairs, prefix(LibBlockNames.DREAM_WOOD + STAIR_SUFFIX));
		r.accept(dreamwoodSlab, prefix(LibBlockNames.DREAM_WOOD + SLAB_SUFFIX));
		r.accept(dreamwoodWall, prefix(LibBlockNames.DREAM_WOOD + WALL_SUFFIX));
		r.accept(dreamwoodStrippedStairs, prefix(LibBlockNames.DREAM_WOOD_STRIPPED + STAIR_SUFFIX));
		r.accept(dreamwoodStrippedSlab, prefix(LibBlockNames.DREAM_WOOD_STRIPPED + SLAB_SUFFIX));
		r.accept(dreamwoodStrippedWall, prefix(LibBlockNames.DREAM_WOOD_STRIPPED + WALL_SUFFIX));
		r.accept(dreamwoodPlankStairs, prefix(LibBlockNames.DREAM_WOOD_PLANKS + STAIR_SUFFIX));
		r.accept(dreamwoodPlankSlab, prefix(LibBlockNames.DREAM_WOOD_PLANKS + SLAB_SUFFIX));
		r.accept(dreamwoodFence, prefix(LibBlockNames.DREAM_WOOD + FENCE_SUFFIX));
		r.accept(dreamwoodFenceGate, prefix(LibBlockNames.DREAM_WOOD + FENCE_GATE_SUFFIX));

		r.accept(darkQuartz, prefix(QUARTZ_DARK));
		r.accept(darkQuartzChiseled, prefix("chiseled_" + QUARTZ_DARK));
		r.accept(darkQuartzPillar, prefix(QUARTZ_DARK + "_pillar"));
		r.accept(darkQuartzSlab, prefix(QUARTZ_DARK + SLAB_SUFFIX));
		r.accept(darkQuartzStairs, prefix(QUARTZ_DARK + STAIR_SUFFIX));

		r.accept(manaQuartz, prefix(QUARTZ_MANA));
		r.accept(manaQuartzChiseled, prefix("chiseled_" + QUARTZ_MANA));
		r.accept(manaQuartzPillar, prefix(QUARTZ_MANA + "_pillar"));
		r.accept(manaQuartzSlab, prefix(QUARTZ_MANA + SLAB_SUFFIX));
		r.accept(manaQuartzStairs, prefix(QUARTZ_MANA + STAIR_SUFFIX));

		r.accept(blazeQuartz, prefix(QUARTZ_BLAZE));
		r.accept(blazeQuartzChiseled, prefix("chiseled_" + QUARTZ_BLAZE));
		r.accept(blazeQuartzPillar, prefix(QUARTZ_BLAZE + "_pillar"));
		r.accept(blazeQuartzSlab, prefix(QUARTZ_BLAZE + SLAB_SUFFIX));
		r.accept(blazeQuartzStairs, prefix(QUARTZ_BLAZE + STAIR_SUFFIX));

		r.accept(lavenderQuartz, prefix(QUARTZ_LAVENDER));
		r.accept(lavenderQuartzChiseled, prefix("chiseled_" + QUARTZ_LAVENDER));
		r.accept(lavenderQuartzPillar, prefix(QUARTZ_LAVENDER + "_pillar"));
		r.accept(lavenderQuartzSlab, prefix(QUARTZ_LAVENDER + SLAB_SUFFIX));
		r.accept(lavenderQuartzStairs, prefix(QUARTZ_LAVENDER + STAIR_SUFFIX));

		r.accept(redQuartz, prefix(QUARTZ_RED));
		r.accept(redQuartzChiseled, prefix("chiseled_" + QUARTZ_RED));
		r.accept(redQuartzPillar, prefix(QUARTZ_RED + "_pillar"));
		r.accept(redQuartzSlab, prefix(QUARTZ_RED + SLAB_SUFFIX));
		r.accept(redQuartzStairs, prefix(QUARTZ_RED + STAIR_SUFFIX));

		r.accept(elfQuartz, prefix(QUARTZ_ELF));
		r.accept(elfQuartzChiseled, prefix("chiseled_" + QUARTZ_ELF));
		r.accept(elfQuartzPillar, prefix(QUARTZ_ELF + "_pillar"));
		r.accept(elfQuartzSlab, prefix(QUARTZ_ELF + SLAB_SUFFIX));
		r.accept(elfQuartzStairs, prefix(QUARTZ_ELF + STAIR_SUFFIX));

		r.accept(sunnyQuartz, prefix(QUARTZ_SUNNY));
		r.accept(sunnyQuartzChiseled, prefix("chiseled_" + QUARTZ_SUNNY));
		r.accept(sunnyQuartzPillar, prefix(QUARTZ_SUNNY + "_pillar"));
		r.accept(sunnyQuartzSlab, prefix(QUARTZ_SUNNY + SLAB_SUFFIX));
		r.accept(sunnyQuartzStairs, prefix(QUARTZ_SUNNY + STAIR_SUFFIX));

		r.accept(whitePavement, prefix("white" + PAVEMENT_SUFFIX));
		r.accept(whitePavementStair, prefix("white" + PAVEMENT_SUFFIX + STAIR_SUFFIX));
		r.accept(whitePavementSlab, prefix("white" + PAVEMENT_SUFFIX + SLAB_SUFFIX));

		r.accept(blackPavement, prefix("black" + PAVEMENT_SUFFIX));
		r.accept(blackPavementStair, prefix("black" + PAVEMENT_SUFFIX + STAIR_SUFFIX));
		r.accept(blackPavementSlab, prefix("black" + PAVEMENT_SUFFIX + SLAB_SUFFIX));

		r.accept(bluePavement, prefix("blue" + PAVEMENT_SUFFIX));
		r.accept(bluePavementStair, prefix("blue" + PAVEMENT_SUFFIX + STAIR_SUFFIX));
		r.accept(bluePavementSlab, prefix("blue" + PAVEMENT_SUFFIX + SLAB_SUFFIX));

		r.accept(yellowPavement, prefix("yellow" + PAVEMENT_SUFFIX));
		r.accept(yellowPavementStair, prefix("yellow" + PAVEMENT_SUFFIX + STAIR_SUFFIX));
		r.accept(yellowPavementSlab, prefix("yellow" + PAVEMENT_SUFFIX + SLAB_SUFFIX));

		r.accept(redPavement, prefix("red" + PAVEMENT_SUFFIX));
		r.accept(redPavementStair, prefix("red" + PAVEMENT_SUFFIX + STAIR_SUFFIX));
		r.accept(redPavementSlab, prefix("red" + PAVEMENT_SUFFIX + SLAB_SUFFIX));

		r.accept(greenPavement, prefix("green" + PAVEMENT_SUFFIX));
		r.accept(greenPavementStair, prefix("green" + PAVEMENT_SUFFIX + STAIR_SUFFIX));
		r.accept(greenPavementSlab, prefix("green" + PAVEMENT_SUFFIX + SLAB_SUFFIX));

		r.accept(biomeStoneForest, prefix(METAMORPHIC_PREFIX + "forest_stone"));
		r.accept(biomeStoneForestSlab, prefix(METAMORPHIC_PREFIX + "forest_stone" + SLAB_SUFFIX));
		r.accept(biomeStoneForestStairs, prefix(METAMORPHIC_PREFIX + "forest_stone" + STAIR_SUFFIX));
		r.accept(biomeStoneForestWall, prefix(METAMORPHIC_PREFIX + "forest_stone" + WALL_SUFFIX));
		r.accept(biomeCobblestoneForest, prefix(METAMORPHIC_PREFIX + "forest_cobblestone"));
		r.accept(biomeCobblestoneForestSlab, prefix(METAMORPHIC_PREFIX + "forest_cobblestone" + SLAB_SUFFIX));
		r.accept(biomeCobblestoneForestStairs, prefix(METAMORPHIC_PREFIX + "forest_cobblestone" + STAIR_SUFFIX));
		r.accept(biomeCobblestoneForestWall, prefix(METAMORPHIC_PREFIX + "forest_cobblestone" + WALL_SUFFIX));
		r.accept(biomeBrickForest, prefix(METAMORPHIC_PREFIX + "forest_bricks"));
		r.accept(biomeBrickForestSlab, prefix(METAMORPHIC_PREFIX + "forest_bricks" + SLAB_SUFFIX));
		r.accept(biomeBrickForestStairs, prefix(METAMORPHIC_PREFIX + "forest_bricks" + STAIR_SUFFIX));
		r.accept(biomeBrickForestWall, prefix(METAMORPHIC_PREFIX + "forest_bricks" + WALL_SUFFIX));
		r.accept(biomeChiseledBrickForest, prefix("chiseled_" + METAMORPHIC_PREFIX + "forest_bricks"));

		r.accept(biomeStonePlains, prefix(METAMORPHIC_PREFIX + "plains_stone"));
		r.accept(biomeStonePlainsSlab, prefix(METAMORPHIC_PREFIX + "plains_stone" + SLAB_SUFFIX));
		r.accept(biomeStonePlainsStairs, prefix(METAMORPHIC_PREFIX + "plains_stone" + STAIR_SUFFIX));
		r.accept(biomeStonePlainsWall, prefix(METAMORPHIC_PREFIX + "plains_stone" + WALL_SUFFIX));
		r.accept(biomeCobblestonePlains, prefix(METAMORPHIC_PREFIX + "plains_cobblestone"));
		r.accept(biomeCobblestonePlainsSlab, prefix(METAMORPHIC_PREFIX + "plains_cobblestone" + SLAB_SUFFIX));
		r.accept(biomeCobblestonePlainsStairs, prefix(METAMORPHIC_PREFIX + "plains_cobblestone" + STAIR_SUFFIX));
		r.accept(biomeCobblestonePlainsWall, prefix(METAMORPHIC_PREFIX + "plains_cobblestone" + WALL_SUFFIX));
		r.accept(biomeBrickPlains, prefix(METAMORPHIC_PREFIX + "plains_bricks"));
		r.accept(biomeBrickPlainsSlab, prefix(METAMORPHIC_PREFIX + "plains_bricks" + SLAB_SUFFIX));
		r.accept(biomeBrickPlainsStairs, prefix(METAMORPHIC_PREFIX + "plains_bricks" + STAIR_SUFFIX));
		r.accept(biomeBrickPlainsWall, prefix(METAMORPHIC_PREFIX + "plains_bricks" + WALL_SUFFIX));
		r.accept(biomeChiseledBrickPlains, prefix("chiseled_" + METAMORPHIC_PREFIX + "plains_bricks"));

		r.accept(biomeStoneMountain, prefix(METAMORPHIC_PREFIX + "mountain_stone"));
		r.accept(biomeStoneMountainSlab, prefix(METAMORPHIC_PREFIX + "mountain_stone" + SLAB_SUFFIX));
		r.accept(biomeStoneMountainStairs, prefix(METAMORPHIC_PREFIX + "mountain_stone" + STAIR_SUFFIX));
		r.accept(biomeStoneMountainWall, prefix(METAMORPHIC_PREFIX + "mountain_stone" + WALL_SUFFIX));
		r.accept(biomeCobblestoneMountain, prefix(METAMORPHIC_PREFIX + "mountain_cobblestone"));
		r.accept(biomeCobblestoneMountainSlab, prefix(METAMORPHIC_PREFIX + "mountain_cobblestone" + SLAB_SUFFIX));
		r.accept(biomeCobblestoneMountainStairs, prefix(METAMORPHIC_PREFIX + "mountain_cobblestone" + STAIR_SUFFIX));
		r.accept(biomeCobblestoneMountainWall, prefix(METAMORPHIC_PREFIX + "mountain_cobblestone" + WALL_SUFFIX));
		r.accept(biomeBrickMountain, prefix(METAMORPHIC_PREFIX + "mountain_bricks"));
		r.accept(biomeBrickMountainSlab, prefix(METAMORPHIC_PREFIX + "mountain_bricks" + SLAB_SUFFIX));
		r.accept(biomeBrickMountainStairs, prefix(METAMORPHIC_PREFIX + "mountain_bricks" + STAIR_SUFFIX));
		r.accept(biomeBrickMountainWall, prefix(METAMORPHIC_PREFIX + "mountain_bricks" + WALL_SUFFIX));
		r.accept(biomeChiseledBrickMountain, prefix("chiseled_" + METAMORPHIC_PREFIX + "mountain_bricks"));

		r.accept(biomeStoneFungal, prefix(METAMORPHIC_PREFIX + "fungal_stone"));
		r.accept(biomeStoneFungalSlab, prefix(METAMORPHIC_PREFIX + "fungal_stone" + SLAB_SUFFIX));
		r.accept(biomeStoneFungalStairs, prefix(METAMORPHIC_PREFIX + "fungal_stone" + STAIR_SUFFIX));
		r.accept(biomeStoneFungalWall, prefix(METAMORPHIC_PREFIX + "fungal_stone" + WALL_SUFFIX));
		r.accept(biomeCobblestoneFungal, prefix(METAMORPHIC_PREFIX + "fungal_cobblestone"));
		r.accept(biomeCobblestoneFungalSlab, prefix(METAMORPHIC_PREFIX + "fungal_cobblestone" + SLAB_SUFFIX));
		r.accept(biomeCobblestoneFungalStairs, prefix(METAMORPHIC_PREFIX + "fungal_cobblestone" + STAIR_SUFFIX));
		r.accept(biomeCobblestoneFungalWall, prefix(METAMORPHIC_PREFIX + "fungal_cobblestone" + WALL_SUFFIX));
		r.accept(biomeBrickFungal, prefix(METAMORPHIC_PREFIX + "fungal_bricks"));
		r.accept(biomeBrickFungalSlab, prefix(METAMORPHIC_PREFIX + "fungal_bricks" + SLAB_SUFFIX));
		r.accept(biomeBrickFungalStairs, prefix(METAMORPHIC_PREFIX + "fungal_bricks" + STAIR_SUFFIX));
		r.accept(biomeBrickFungalWall, prefix(METAMORPHIC_PREFIX + "fungal_bricks" + WALL_SUFFIX));
		r.accept(biomeChiseledBrickFungal, prefix("chiseled_" + METAMORPHIC_PREFIX + "fungal_bricks"));

		r.accept(biomeStoneSwamp, prefix(METAMORPHIC_PREFIX + "swamp_stone"));
		r.accept(biomeStoneSwampSlab, prefix(METAMORPHIC_PREFIX + "swamp_stone" + SLAB_SUFFIX));
		r.accept(biomeStoneSwampStairs, prefix(METAMORPHIC_PREFIX + "swamp_stone" + STAIR_SUFFIX));
		r.accept(biomeStoneSwampWall, prefix(METAMORPHIC_PREFIX + "swamp_stone" + WALL_SUFFIX));
		r.accept(biomeCobblestoneSwamp, prefix(METAMORPHIC_PREFIX + "swamp_cobblestone"));
		r.accept(biomeCobblestoneSwampSlab, prefix(METAMORPHIC_PREFIX + "swamp_cobblestone" + SLAB_SUFFIX));
		r.accept(biomeCobblestoneSwampStairs, prefix(METAMORPHIC_PREFIX + "swamp_cobblestone" + STAIR_SUFFIX));
		r.accept(biomeCobblestoneSwampWall, prefix(METAMORPHIC_PREFIX + "swamp_cobblestone" + WALL_SUFFIX));
		r.accept(biomeBrickSwamp, prefix(METAMORPHIC_PREFIX + "swamp_bricks"));
		r.accept(biomeBrickSwampSlab, prefix(METAMORPHIC_PREFIX + "swamp_bricks" + SLAB_SUFFIX));
		r.accept(biomeBrickSwampStairs, prefix(METAMORPHIC_PREFIX + "swamp_bricks" + STAIR_SUFFIX));
		r.accept(biomeBrickSwampWall, prefix(METAMORPHIC_PREFIX + "swamp_bricks" + WALL_SUFFIX));
		r.accept(biomeChiseledBrickSwamp, prefix("chiseled_" + METAMORPHIC_PREFIX + "swamp_bricks"));

		r.accept(biomeStoneDesert, prefix(METAMORPHIC_PREFIX + "desert_stone"));
		r.accept(biomeStoneDesertSlab, prefix(METAMORPHIC_PREFIX + "desert_stone" + SLAB_SUFFIX));
		r.accept(biomeStoneDesertStairs, prefix(METAMORPHIC_PREFIX + "desert_stone" + STAIR_SUFFIX));
		r.accept(biomeStoneDesertWall, prefix(METAMORPHIC_PREFIX + "desert_stone" + WALL_SUFFIX));
		r.accept(biomeCobblestoneDesert, prefix(METAMORPHIC_PREFIX + "desert_cobblestone"));
		r.accept(biomeCobblestoneDesertSlab, prefix(METAMORPHIC_PREFIX + "desert_cobblestone" + SLAB_SUFFIX));
		r.accept(biomeCobblestoneDesertStairs, prefix(METAMORPHIC_PREFIX + "desert_cobblestone" + STAIR_SUFFIX));
		r.accept(biomeCobblestoneDesertWall, prefix(METAMORPHIC_PREFIX + "desert_cobblestone" + WALL_SUFFIX));
		r.accept(biomeBrickDesert, prefix(METAMORPHIC_PREFIX + "desert_bricks"));
		r.accept(biomeBrickDesertSlab, prefix(METAMORPHIC_PREFIX + "desert_bricks" + SLAB_SUFFIX));
		r.accept(biomeBrickDesertStairs, prefix(METAMORPHIC_PREFIX + "desert_bricks" + STAIR_SUFFIX));
		r.accept(biomeBrickDesertWall, prefix(METAMORPHIC_PREFIX + "desert_bricks" + WALL_SUFFIX));
		r.accept(biomeChiseledBrickDesert, prefix("chiseled_" + METAMORPHIC_PREFIX + "desert_bricks"));

		r.accept(biomeStoneTaiga, prefix(METAMORPHIC_PREFIX + "taiga_stone"));
		r.accept(biomeStoneTaigaSlab, prefix(METAMORPHIC_PREFIX + "taiga_stone" + SLAB_SUFFIX));
		r.accept(biomeStoneTaigaStairs, prefix(METAMORPHIC_PREFIX + "taiga_stone" + STAIR_SUFFIX));
		r.accept(biomeStoneTaigaWall, prefix(METAMORPHIC_PREFIX + "taiga_stone" + WALL_SUFFIX));
		r.accept(biomeCobblestoneTaiga, prefix(METAMORPHIC_PREFIX + "taiga_cobblestone"));
		r.accept(biomeCobblestoneTaigaSlab, prefix(METAMORPHIC_PREFIX + "taiga_cobblestone" + SLAB_SUFFIX));
		r.accept(biomeCobblestoneTaigaStairs, prefix(METAMORPHIC_PREFIX + "taiga_cobblestone" + STAIR_SUFFIX));
		r.accept(biomeCobblestoneTaigaWall, prefix(METAMORPHIC_PREFIX + "taiga_cobblestone" + WALL_SUFFIX));
		r.accept(biomeBrickTaiga, prefix(METAMORPHIC_PREFIX + "taiga_bricks"));
		r.accept(biomeBrickTaigaSlab, prefix(METAMORPHIC_PREFIX + "taiga_bricks" + SLAB_SUFFIX));
		r.accept(biomeBrickTaigaStairs, prefix(METAMORPHIC_PREFIX + "taiga_bricks" + STAIR_SUFFIX));
		r.accept(biomeBrickTaigaWall, prefix(METAMORPHIC_PREFIX + "taiga_bricks" + WALL_SUFFIX));
		r.accept(biomeChiseledBrickTaiga, prefix("chiseled_" + METAMORPHIC_PREFIX + "taiga_bricks"));

		r.accept(biomeStoneMesa, prefix(METAMORPHIC_PREFIX + "mesa_stone"));
		r.accept(biomeStoneMesaSlab, prefix(METAMORPHIC_PREFIX + "mesa_stone" + SLAB_SUFFIX));
		r.accept(biomeStoneMesaStairs, prefix(METAMORPHIC_PREFIX + "mesa_stone" + STAIR_SUFFIX));
		r.accept(biomeStoneMesaWall, prefix(METAMORPHIC_PREFIX + "mesa_stone" + WALL_SUFFIX));
		r.accept(biomeCobblestoneMesa, prefix(METAMORPHIC_PREFIX + "mesa_cobblestone"));
		r.accept(biomeCobblestoneMesaSlab, prefix(METAMORPHIC_PREFIX + "mesa_cobblestone" + SLAB_SUFFIX));
		r.accept(biomeCobblestoneMesaStairs, prefix(METAMORPHIC_PREFIX + "mesa_cobblestone" + STAIR_SUFFIX));
		r.accept(biomeCobblestoneMesaWall, prefix(METAMORPHIC_PREFIX + "mesa_cobblestone" + WALL_SUFFIX));
		r.accept(biomeBrickMesa, prefix(METAMORPHIC_PREFIX + "mesa_bricks"));
		r.accept(biomeBrickMesaSlab, prefix(METAMORPHIC_PREFIX + "mesa_bricks" + SLAB_SUFFIX));
		r.accept(biomeBrickMesaStairs, prefix(METAMORPHIC_PREFIX + "mesa_bricks" + STAIR_SUFFIX));
		r.accept(biomeBrickMesaWall, prefix(METAMORPHIC_PREFIX + "mesa_bricks" + WALL_SUFFIX));
		r.accept(biomeChiseledBrickMesa, prefix("chiseled_" + METAMORPHIC_PREFIX + "mesa_bricks"));

		r.accept(shimmerrockSlab, prefix(LibBlockNames.SHIMMERROCK + SLAB_SUFFIX));
		r.accept(shimmerrockStairs, prefix(LibBlockNames.SHIMMERROCK + STAIR_SUFFIX));

		r.accept(shimmerwoodPlankSlab, prefix(LibBlockNames.SHIMMERWOOD_PLANKS + SLAB_SUFFIX));
		r.accept(shimmerwoodPlankStairs, prefix(LibBlockNames.SHIMMERWOOD_PLANKS + STAIR_SUFFIX));

		r.accept(managlassPane, prefix(LibBlockNames.MANA_GLASS + "_pane"));
		r.accept(alfglassPane, prefix(LibBlockNames.ELF_GLASS + "_pane"));
		r.accept(bifrostPane, prefix(LibBlockNames.BIFROST + "_pane"));
	}

	public static void registerItemBlocks(BiConsumer<class_1792, class_2960> r) {
		class_1792.class_1793 props = BotaniaItems.defaultBuilder();

		r.accept(new class_1747(livingwoodStairs, props), class_2378.field_11146.method_10221(livingwoodStairs));
		r.accept(new class_1747(livingwoodSlab, props), class_2378.field_11146.method_10221(livingwoodSlab));
		r.accept(new class_1747(livingwoodWall, props), class_2378.field_11146.method_10221(livingwoodWall));
		r.accept(new class_1747(livingwoodFence, props), class_2378.field_11146.method_10221(livingwoodFence));
		r.accept(new class_1747(livingwoodFenceGate, props), class_2378.field_11146.method_10221(livingwoodFenceGate));

		r.accept(new class_1747(livingwoodStrippedStairs, props), class_2378.field_11146.method_10221(livingwoodStrippedStairs));
		r.accept(new class_1747(livingwoodStrippedSlab, props), class_2378.field_11146.method_10221(livingwoodStrippedSlab));
		r.accept(new class_1747(livingwoodStrippedWall, props), class_2378.field_11146.method_10221(livingwoodStrippedWall));

		r.accept(new class_1747(livingwoodPlankStairs, props), class_2378.field_11146.method_10221(livingwoodPlankStairs));
		r.accept(new class_1747(livingwoodPlankSlab, props), class_2378.field_11146.method_10221(livingwoodPlankSlab));

		r.accept(new class_1747(livingrockStairs, props), class_2378.field_11146.method_10221(livingrockStairs));
		r.accept(new class_1747(livingrockSlab, props), class_2378.field_11146.method_10221(livingrockSlab));
		r.accept(new class_1747(livingrockWall, props), class_2378.field_11146.method_10221(livingrockWall));

		r.accept(new class_1747(livingrockPolishedStairs, props), class_2378.field_11146.method_10221(livingrockPolishedStairs));
		r.accept(new class_1747(livingrockPolishedSlab, props), class_2378.field_11146.method_10221(livingrockPolishedSlab));
		r.accept(new class_1747(livingrockPolishedWall, props), class_2378.field_11146.method_10221(livingrockPolishedWall));

		r.accept(new class_1747(livingrockBrickStairs, props), class_2378.field_11146.method_10221(livingrockBrickStairs));
		r.accept(new class_1747(livingrockBrickSlab, props), class_2378.field_11146.method_10221(livingrockBrickSlab));
		r.accept(new class_1747(livingrockBrickWall, props), class_2378.field_11146.method_10221(livingrockBrickWall));

		r.accept(new class_1747(livingrockBrickMossyStairs, props), class_2378.field_11146.method_10221(livingrockBrickMossyStairs));
		r.accept(new class_1747(livingrockBrickMossySlab, props), class_2378.field_11146.method_10221(livingrockBrickMossySlab));
		r.accept(new class_1747(livingrockBrickMossyWall, props), class_2378.field_11146.method_10221(livingrockBrickMossyWall));

		r.accept(new class_1747(dreamwoodStairs, props), class_2378.field_11146.method_10221(dreamwoodStairs));
		r.accept(new class_1747(dreamwoodSlab, props), class_2378.field_11146.method_10221(dreamwoodSlab));
		r.accept(new class_1747(dreamwoodWall, props), class_2378.field_11146.method_10221(dreamwoodWall));
		r.accept(new class_1747(dreamwoodFence, props), class_2378.field_11146.method_10221(dreamwoodFence));
		r.accept(new class_1747(dreamwoodFenceGate, props), class_2378.field_11146.method_10221(dreamwoodFenceGate));

		r.accept(new class_1747(dreamwoodStrippedStairs, props), class_2378.field_11146.method_10221(dreamwoodStrippedStairs));
		r.accept(new class_1747(dreamwoodStrippedSlab, props), class_2378.field_11146.method_10221(dreamwoodStrippedSlab));
		r.accept(new class_1747(dreamwoodStrippedWall, props), class_2378.field_11146.method_10221(dreamwoodStrippedWall));

		r.accept(new class_1747(dreamwoodPlankStairs, props), class_2378.field_11146.method_10221(dreamwoodPlankStairs));
		r.accept(new class_1747(dreamwoodPlankSlab, props), class_2378.field_11146.method_10221(dreamwoodPlankSlab));

		r.accept(new class_1747(darkQuartz, props), class_2378.field_11146.method_10221(darkQuartz));
		r.accept(new class_1747(darkQuartzPillar, props), class_2378.field_11146.method_10221(darkQuartzPillar));
		r.accept(new class_1747(darkQuartzChiseled, props), class_2378.field_11146.method_10221(darkQuartzChiseled));
		r.accept(new class_1747(darkQuartzSlab, props), class_2378.field_11146.method_10221(darkQuartzSlab));
		r.accept(new class_1747(darkQuartzStairs, props), class_2378.field_11146.method_10221(darkQuartzStairs));

		r.accept(new class_1747(manaQuartz, props), class_2378.field_11146.method_10221(manaQuartz));
		r.accept(new class_1747(manaQuartzPillar, props), class_2378.field_11146.method_10221(manaQuartzPillar));
		r.accept(new class_1747(manaQuartzChiseled, props), class_2378.field_11146.method_10221(manaQuartzChiseled));
		r.accept(new class_1747(manaQuartzSlab, props), class_2378.field_11146.method_10221(manaQuartzSlab));
		r.accept(new class_1747(manaQuartzStairs, props), class_2378.field_11146.method_10221(manaQuartzStairs));

		r.accept(new class_1747(blazeQuartz, props), class_2378.field_11146.method_10221(blazeQuartz));
		r.accept(new class_1747(blazeQuartzPillar, props), class_2378.field_11146.method_10221(blazeQuartzPillar));
		r.accept(new class_1747(blazeQuartzChiseled, props), class_2378.field_11146.method_10221(blazeQuartzChiseled));
		r.accept(new class_1747(blazeQuartzSlab, props), class_2378.field_11146.method_10221(blazeQuartzSlab));
		r.accept(new class_1747(blazeQuartzStairs, props), class_2378.field_11146.method_10221(blazeQuartzStairs));

		r.accept(new class_1747(lavenderQuartz, props), class_2378.field_11146.method_10221(lavenderQuartz));
		r.accept(new class_1747(lavenderQuartzPillar, props), class_2378.field_11146.method_10221(lavenderQuartzPillar));
		r.accept(new class_1747(lavenderQuartzChiseled, props), class_2378.field_11146.method_10221(lavenderQuartzChiseled));
		r.accept(new class_1747(lavenderQuartzSlab, props), class_2378.field_11146.method_10221(lavenderQuartzSlab));
		r.accept(new class_1747(lavenderQuartzStairs, props), class_2378.field_11146.method_10221(lavenderQuartzStairs));

		r.accept(new class_1747(redQuartz, props), class_2378.field_11146.method_10221(redQuartz));
		r.accept(new class_1747(redQuartzPillar, props), class_2378.field_11146.method_10221(redQuartzPillar));
		r.accept(new class_1747(redQuartzChiseled, props), class_2378.field_11146.method_10221(redQuartzChiseled));
		r.accept(new class_1747(redQuartzSlab, props), class_2378.field_11146.method_10221(redQuartzSlab));
		r.accept(new class_1747(redQuartzStairs, props), class_2378.field_11146.method_10221(redQuartzStairs));

		r.accept(new class_1747(elfQuartz, props), class_2378.field_11146.method_10221(elfQuartz));
		r.accept(new class_1747(elfQuartzPillar, props), class_2378.field_11146.method_10221(elfQuartzPillar));
		r.accept(new class_1747(elfQuartzChiseled, props), class_2378.field_11146.method_10221(elfQuartzChiseled));
		r.accept(new class_1747(elfQuartzSlab, props), class_2378.field_11146.method_10221(elfQuartzSlab));
		r.accept(new class_1747(elfQuartzStairs, props), class_2378.field_11146.method_10221(elfQuartzStairs));

		r.accept(new class_1747(sunnyQuartz, props), class_2378.field_11146.method_10221(sunnyQuartz));
		r.accept(new class_1747(sunnyQuartzPillar, props), class_2378.field_11146.method_10221(sunnyQuartzPillar));
		r.accept(new class_1747(sunnyQuartzChiseled, props), class_2378.field_11146.method_10221(sunnyQuartzChiseled));
		r.accept(new class_1747(sunnyQuartzSlab, props), class_2378.field_11146.method_10221(sunnyQuartzSlab));
		r.accept(new class_1747(sunnyQuartzStairs, props), class_2378.field_11146.method_10221(sunnyQuartzStairs));

		r.accept(new class_1747(biomeStoneForest, props), class_2378.field_11146.method_10221(biomeStoneForest));
		r.accept(new class_1747(biomeStoneForestSlab, props), class_2378.field_11146.method_10221(biomeStoneForestSlab));
		r.accept(new class_1747(biomeStoneForestStairs, props), class_2378.field_11146.method_10221(biomeStoneForestStairs));
		r.accept(new class_1747(biomeStoneForestWall, props), class_2378.field_11146.method_10221(biomeStoneForestWall));
		r.accept(new class_1747(biomeBrickForest, props), class_2378.field_11146.method_10221(biomeBrickForest));
		r.accept(new class_1747(biomeBrickForestSlab, props), class_2378.field_11146.method_10221(biomeBrickForestSlab));
		r.accept(new class_1747(biomeBrickForestStairs, props), class_2378.field_11146.method_10221(biomeBrickForestStairs));
		r.accept(new class_1747(biomeBrickForestWall, props), class_2378.field_11146.method_10221(biomeBrickForestWall));
		r.accept(new class_1747(biomeCobblestoneForest, props), class_2378.field_11146.method_10221(biomeCobblestoneForest));
		r.accept(new class_1747(biomeCobblestoneForestSlab, props), class_2378.field_11146.method_10221(biomeCobblestoneForestSlab));
		r.accept(new class_1747(biomeCobblestoneForestStairs, props), class_2378.field_11146.method_10221(biomeCobblestoneForestStairs));
		r.accept(new class_1747(biomeCobblestoneForestWall, props), class_2378.field_11146.method_10221(biomeCobblestoneForestWall));
		r.accept(new class_1747(biomeChiseledBrickForest, props), class_2378.field_11146.method_10221(biomeChiseledBrickForest));

		r.accept(new class_1747(biomeStonePlains, props), class_2378.field_11146.method_10221(biomeStonePlains));
		r.accept(new class_1747(biomeStonePlainsSlab, props), class_2378.field_11146.method_10221(biomeStonePlainsSlab));
		r.accept(new class_1747(biomeStonePlainsStairs, props), class_2378.field_11146.method_10221(biomeStonePlainsStairs));
		r.accept(new class_1747(biomeStonePlainsWall, props), class_2378.field_11146.method_10221(biomeStonePlainsWall));
		r.accept(new class_1747(biomeBrickPlains, props), class_2378.field_11146.method_10221(biomeBrickPlains));
		r.accept(new class_1747(biomeBrickPlainsSlab, props), class_2378.field_11146.method_10221(biomeBrickPlainsSlab));
		r.accept(new class_1747(biomeBrickPlainsStairs, props), class_2378.field_11146.method_10221(biomeBrickPlainsStairs));
		r.accept(new class_1747(biomeBrickPlainsWall, props), class_2378.field_11146.method_10221(biomeBrickPlainsWall));
		r.accept(new class_1747(biomeCobblestonePlains, props), class_2378.field_11146.method_10221(biomeCobblestonePlains));
		r.accept(new class_1747(biomeCobblestonePlainsSlab, props), class_2378.field_11146.method_10221(biomeCobblestonePlainsSlab));
		r.accept(new class_1747(biomeCobblestonePlainsStairs, props), class_2378.field_11146.method_10221(biomeCobblestonePlainsStairs));
		r.accept(new class_1747(biomeCobblestonePlainsWall, props), class_2378.field_11146.method_10221(biomeCobblestonePlainsWall));
		r.accept(new class_1747(biomeChiseledBrickPlains, props), class_2378.field_11146.method_10221(biomeChiseledBrickPlains));

		r.accept(new class_1747(biomeStoneMountain, props), class_2378.field_11146.method_10221(biomeStoneMountain));
		r.accept(new class_1747(biomeStoneMountainSlab, props), class_2378.field_11146.method_10221(biomeStoneMountainSlab));
		r.accept(new class_1747(biomeStoneMountainStairs, props), class_2378.field_11146.method_10221(biomeStoneMountainStairs));
		r.accept(new class_1747(biomeStoneMountainWall, props), class_2378.field_11146.method_10221(biomeStoneMountainWall));
		r.accept(new class_1747(biomeBrickMountain, props), class_2378.field_11146.method_10221(biomeBrickMountain));
		r.accept(new class_1747(biomeBrickMountainSlab, props), class_2378.field_11146.method_10221(biomeBrickMountainSlab));
		r.accept(new class_1747(biomeBrickMountainStairs, props), class_2378.field_11146.method_10221(biomeBrickMountainStairs));
		r.accept(new class_1747(biomeBrickMountainWall, props), class_2378.field_11146.method_10221(biomeBrickMountainWall));
		r.accept(new class_1747(biomeCobblestoneMountain, props), class_2378.field_11146.method_10221(biomeCobblestoneMountain));
		r.accept(new class_1747(biomeCobblestoneMountainSlab, props), class_2378.field_11146.method_10221(biomeCobblestoneMountainSlab));
		r.accept(new class_1747(biomeCobblestoneMountainStairs, props), class_2378.field_11146.method_10221(biomeCobblestoneMountainStairs));
		r.accept(new class_1747(biomeCobblestoneMountainWall, props), class_2378.field_11146.method_10221(biomeCobblestoneMountainWall));
		r.accept(new class_1747(biomeChiseledBrickMountain, props), class_2378.field_11146.method_10221(biomeChiseledBrickMountain));

		r.accept(new class_1747(biomeStoneFungal, props), class_2378.field_11146.method_10221(biomeStoneFungal));
		r.accept(new class_1747(biomeStoneFungalSlab, props), class_2378.field_11146.method_10221(biomeStoneFungalSlab));
		r.accept(new class_1747(biomeStoneFungalStairs, props), class_2378.field_11146.method_10221(biomeStoneFungalStairs));
		r.accept(new class_1747(biomeStoneFungalWall, props), class_2378.field_11146.method_10221(biomeStoneFungalWall));
		r.accept(new class_1747(biomeBrickFungal, props), class_2378.field_11146.method_10221(biomeBrickFungal));
		r.accept(new class_1747(biomeBrickFungalSlab, props), class_2378.field_11146.method_10221(biomeBrickFungalSlab));
		r.accept(new class_1747(biomeBrickFungalStairs, props), class_2378.field_11146.method_10221(biomeBrickFungalStairs));
		r.accept(new class_1747(biomeBrickFungalWall, props), class_2378.field_11146.method_10221(biomeBrickFungalWall));
		r.accept(new class_1747(biomeCobblestoneFungal, props), class_2378.field_11146.method_10221(biomeCobblestoneFungal));
		r.accept(new class_1747(biomeCobblestoneFungalSlab, props), class_2378.field_11146.method_10221(biomeCobblestoneFungalSlab));
		r.accept(new class_1747(biomeCobblestoneFungalStairs, props), class_2378.field_11146.method_10221(biomeCobblestoneFungalStairs));
		r.accept(new class_1747(biomeCobblestoneFungalWall, props), class_2378.field_11146.method_10221(biomeCobblestoneFungalWall));
		r.accept(new class_1747(biomeChiseledBrickFungal, props), class_2378.field_11146.method_10221(biomeChiseledBrickFungal));

		r.accept(new class_1747(biomeStoneSwamp, props), class_2378.field_11146.method_10221(biomeStoneSwamp));
		r.accept(new class_1747(biomeStoneSwampSlab, props), class_2378.field_11146.method_10221(biomeStoneSwampSlab));
		r.accept(new class_1747(biomeStoneSwampStairs, props), class_2378.field_11146.method_10221(biomeStoneSwampStairs));
		r.accept(new class_1747(biomeStoneSwampWall, props), class_2378.field_11146.method_10221(biomeStoneSwampWall));
		r.accept(new class_1747(biomeBrickSwamp, props), class_2378.field_11146.method_10221(biomeBrickSwamp));
		r.accept(new class_1747(biomeBrickSwampSlab, props), class_2378.field_11146.method_10221(biomeBrickSwampSlab));
		r.accept(new class_1747(biomeBrickSwampStairs, props), class_2378.field_11146.method_10221(biomeBrickSwampStairs));
		r.accept(new class_1747(biomeBrickSwampWall, props), class_2378.field_11146.method_10221(biomeBrickSwampWall));
		r.accept(new class_1747(biomeCobblestoneSwamp, props), class_2378.field_11146.method_10221(biomeCobblestoneSwamp));
		r.accept(new class_1747(biomeCobblestoneSwampSlab, props), class_2378.field_11146.method_10221(biomeCobblestoneSwampSlab));
		r.accept(new class_1747(biomeCobblestoneSwampStairs, props), class_2378.field_11146.method_10221(biomeCobblestoneSwampStairs));
		r.accept(new class_1747(biomeCobblestoneSwampWall, props), class_2378.field_11146.method_10221(biomeCobblestoneSwampWall));
		r.accept(new class_1747(biomeChiseledBrickSwamp, props), class_2378.field_11146.method_10221(biomeChiseledBrickSwamp));

		r.accept(new class_1747(biomeStoneDesert, props), class_2378.field_11146.method_10221(biomeStoneDesert));
		r.accept(new class_1747(biomeStoneDesertSlab, props), class_2378.field_11146.method_10221(biomeStoneDesertSlab));
		r.accept(new class_1747(biomeStoneDesertStairs, props), class_2378.field_11146.method_10221(biomeStoneDesertStairs));
		r.accept(new class_1747(biomeStoneDesertWall, props), class_2378.field_11146.method_10221(biomeStoneDesertWall));
		r.accept(new class_1747(biomeBrickDesert, props), class_2378.field_11146.method_10221(biomeBrickDesert));
		r.accept(new class_1747(biomeBrickDesertSlab, props), class_2378.field_11146.method_10221(biomeBrickDesertSlab));
		r.accept(new class_1747(biomeBrickDesertStairs, props), class_2378.field_11146.method_10221(biomeBrickDesertStairs));
		r.accept(new class_1747(biomeBrickDesertWall, props), class_2378.field_11146.method_10221(biomeBrickDesertWall));
		r.accept(new class_1747(biomeCobblestoneDesert, props), class_2378.field_11146.method_10221(biomeCobblestoneDesert));
		r.accept(new class_1747(biomeCobblestoneDesertSlab, props), class_2378.field_11146.method_10221(biomeCobblestoneDesertSlab));
		r.accept(new class_1747(biomeCobblestoneDesertStairs, props), class_2378.field_11146.method_10221(biomeCobblestoneDesertStairs));
		r.accept(new class_1747(biomeCobblestoneDesertWall, props), class_2378.field_11146.method_10221(biomeCobblestoneDesertWall));
		r.accept(new class_1747(biomeChiseledBrickDesert, props), class_2378.field_11146.method_10221(biomeChiseledBrickDesert));

		r.accept(new class_1747(biomeStoneTaiga, props), class_2378.field_11146.method_10221(biomeStoneTaiga));
		r.accept(new class_1747(biomeStoneTaigaSlab, props), class_2378.field_11146.method_10221(biomeStoneTaigaSlab));
		r.accept(new class_1747(biomeStoneTaigaStairs, props), class_2378.field_11146.method_10221(biomeStoneTaigaStairs));
		r.accept(new class_1747(biomeStoneTaigaWall, props), class_2378.field_11146.method_10221(biomeStoneTaigaWall));
		r.accept(new class_1747(biomeBrickTaiga, props), class_2378.field_11146.method_10221(biomeBrickTaiga));
		r.accept(new class_1747(biomeBrickTaigaSlab, props), class_2378.field_11146.method_10221(biomeBrickTaigaSlab));
		r.accept(new class_1747(biomeBrickTaigaStairs, props), class_2378.field_11146.method_10221(biomeBrickTaigaStairs));
		r.accept(new class_1747(biomeBrickTaigaWall, props), class_2378.field_11146.method_10221(biomeBrickTaigaWall));
		r.accept(new class_1747(biomeCobblestoneTaiga, props), class_2378.field_11146.method_10221(biomeCobblestoneTaiga));
		r.accept(new class_1747(biomeCobblestoneTaigaSlab, props), class_2378.field_11146.method_10221(biomeCobblestoneTaigaSlab));
		r.accept(new class_1747(biomeCobblestoneTaigaStairs, props), class_2378.field_11146.method_10221(biomeCobblestoneTaigaStairs));
		r.accept(new class_1747(biomeCobblestoneTaigaWall, props), class_2378.field_11146.method_10221(biomeCobblestoneTaigaWall));
		r.accept(new class_1747(biomeChiseledBrickTaiga, props), class_2378.field_11146.method_10221(biomeChiseledBrickTaiga));

		r.accept(new class_1747(biomeStoneMesa, props), class_2378.field_11146.method_10221(biomeStoneMesa));
		r.accept(new class_1747(biomeStoneMesaSlab, props), class_2378.field_11146.method_10221(biomeStoneMesaSlab));
		r.accept(new class_1747(biomeStoneMesaStairs, props), class_2378.field_11146.method_10221(biomeStoneMesaStairs));
		r.accept(new class_1747(biomeStoneMesaWall, props), class_2378.field_11146.method_10221(biomeStoneMesaWall));
		r.accept(new class_1747(biomeBrickMesa, props), class_2378.field_11146.method_10221(biomeBrickMesa));
		r.accept(new class_1747(biomeBrickMesaSlab, props), class_2378.field_11146.method_10221(biomeBrickMesaSlab));
		r.accept(new class_1747(biomeBrickMesaStairs, props), class_2378.field_11146.method_10221(biomeBrickMesaStairs));
		r.accept(new class_1747(biomeBrickMesaWall, props), class_2378.field_11146.method_10221(biomeBrickMesaWall));
		r.accept(new class_1747(biomeCobblestoneMesa, props), class_2378.field_11146.method_10221(biomeCobblestoneMesa));
		r.accept(new class_1747(biomeCobblestoneMesaSlab, props), class_2378.field_11146.method_10221(biomeCobblestoneMesaSlab));
		r.accept(new class_1747(biomeCobblestoneMesaStairs, props), class_2378.field_11146.method_10221(biomeCobblestoneMesaStairs));
		r.accept(new class_1747(biomeCobblestoneMesaWall, props), class_2378.field_11146.method_10221(biomeCobblestoneMesaWall));
		r.accept(new class_1747(biomeChiseledBrickMesa, props), class_2378.field_11146.method_10221(biomeChiseledBrickMesa));

		r.accept(new class_1747(whitePavement, props), class_2378.field_11146.method_10221(whitePavement));
		r.accept(new class_1747(blackPavement, props), class_2378.field_11146.method_10221(blackPavement));
		r.accept(new class_1747(bluePavement, props), class_2378.field_11146.method_10221(bluePavement));
		r.accept(new class_1747(yellowPavement, props), class_2378.field_11146.method_10221(yellowPavement));
		r.accept(new class_1747(redPavement, props), class_2378.field_11146.method_10221(redPavement));
		r.accept(new class_1747(greenPavement, props), class_2378.field_11146.method_10221(greenPavement));

		r.accept(new class_1747(whitePavementSlab, props), class_2378.field_11146.method_10221(whitePavementSlab));
		r.accept(new class_1747(blackPavementSlab, props), class_2378.field_11146.method_10221(blackPavementSlab));
		r.accept(new class_1747(bluePavementSlab, props), class_2378.field_11146.method_10221(bluePavementSlab));
		r.accept(new class_1747(yellowPavementSlab, props), class_2378.field_11146.method_10221(yellowPavementSlab));
		r.accept(new class_1747(redPavementSlab, props), class_2378.field_11146.method_10221(redPavementSlab));
		r.accept(new class_1747(greenPavementSlab, props), class_2378.field_11146.method_10221(greenPavementSlab));

		r.accept(new class_1747(whitePavementStair, props), class_2378.field_11146.method_10221(whitePavementStair));
		r.accept(new class_1747(blackPavementStair, props), class_2378.field_11146.method_10221(blackPavementStair));
		r.accept(new class_1747(bluePavementStair, props), class_2378.field_11146.method_10221(bluePavementStair));
		r.accept(new class_1747(yellowPavementStair, props), class_2378.field_11146.method_10221(yellowPavementStair));
		r.accept(new class_1747(redPavementStair, props), class_2378.field_11146.method_10221(redPavementStair));
		r.accept(new class_1747(greenPavementStair, props), class_2378.field_11146.method_10221(greenPavementStair));

		r.accept(new class_1747(shimmerrockSlab, props), class_2378.field_11146.method_10221(shimmerrockSlab));
		r.accept(new class_1747(shimmerrockStairs, props), class_2378.field_11146.method_10221(shimmerrockStairs));

		r.accept(new class_1747(shimmerwoodPlankSlab, props), class_2378.field_11146.method_10221(shimmerwoodPlankSlab));
		r.accept(new class_1747(shimmerwoodPlankStairs, props), class_2378.field_11146.method_10221(shimmerwoodPlankStairs));

		r.accept(new class_1747(managlassPane, props), class_2378.field_11146.method_10221(managlassPane));
		r.accept(new class_1747(alfglassPane, props), class_2378.field_11146.method_10221(alfglassPane));
		r.accept(new class_1747(bifrostPane, props), class_2378.field_11146.method_10221(bifrostPane));
	}

}
