/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.block.PetalApothecary;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.api.state.enums.AlfheimPortalState;
import vazkii.botania.api.state.enums.LuminizerVariant;
import vazkii.botania.common.block.corporea.*;
import vazkii.botania.common.block.decor.*;
import vazkii.botania.common.block.decor.stairs.BotaniaStairBlock;
import vazkii.botania.common.block.dispenser.*;
import vazkii.botania.common.block.mana.*;
import vazkii.botania.common.block.red_string.*;
import vazkii.botania.common.entity.EnderAirBottleEntity;
import vazkii.botania.common.entity.VineBallEntity;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.block.BlockItemWithSpecialRenderer;
import vazkii.botania.common.item.block.TinyPotatoBlockItem;
import vazkii.botania.common.lib.LibBlockNames;
import vazkii.botania.mixin.DispenserBlockAccessor;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.Locale;
import java.util.function.BiConsumer;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1676;
import net.minecraft.class_1738;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1827;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2342;
import net.minecraft.class_2357;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2465;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2544;
import net.minecraft.class_2960;
import net.minecraft.class_2965;
import net.minecraft.class_2969;
import net.minecraft.class_3614;
import net.minecraft.class_4970;
import net.minecraft.class_5168;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public final class BotaniaBlocks {
	private static final class_4970.class_4972<class_1299<?>> NO_SPAWN = (state, world, pos, et) -> false;
	private static final class_4970.class_4973 NO_SUFFOCATION = (state, world, pos) -> false;

	public static final class_2248 whiteFlower = new BotaniaFlowerBlock(class_1767.field_7952, class_4970.class_2251.method_9637(class_3614.field_15935).method_9634().method_9632(0).method_9626(class_2498.field_11535));
	public static final class_2248 orangeFlower = new BotaniaFlowerBlock(class_1767.field_7946, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 magentaFlower = new BotaniaFlowerBlock(class_1767.field_7958, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 lightBlueFlower = new BotaniaFlowerBlock(class_1767.field_7951, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 yellowFlower = new BotaniaFlowerBlock(class_1767.field_7947, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 limeFlower = new BotaniaFlowerBlock(class_1767.field_7961, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 pinkFlower = new BotaniaFlowerBlock(class_1767.field_7954, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 grayFlower = new BotaniaFlowerBlock(class_1767.field_7944, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 lightGrayFlower = new BotaniaFlowerBlock(class_1767.field_7967, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 cyanFlower = new BotaniaFlowerBlock(class_1767.field_7955, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 purpleFlower = new BotaniaFlowerBlock(class_1767.field_7945, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 blueFlower = new BotaniaFlowerBlock(class_1767.field_7966, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 brownFlower = new BotaniaFlowerBlock(class_1767.field_7957, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 greenFlower = new BotaniaFlowerBlock(class_1767.field_7942, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 redFlower = new BotaniaFlowerBlock(class_1767.field_7964, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 blackFlower = new BotaniaFlowerBlock(class_1767.field_7963, class_4970.class_2251.method_9630(whiteFlower));

	public static final class_2248 whiteShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7952, class_4970.class_2251.method_9630(whiteFlower).method_9631(s -> 15));
	public static final class_2248 orangeShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7946, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 magentaShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7958, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 lightBlueShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7951, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 yellowShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7947, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 limeShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7961, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 pinkShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7954, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 grayShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7944, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 lightGrayShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7967, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 cyanShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7955, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 purpleShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7945, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 blueShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7966, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 brownShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7957, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 greenShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7942, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 redShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7964, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 blackShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7963, class_4970.class_2251.method_9630(whiteShinyFlower));

	public static final class_2248 whiteBuriedPetals = new BuriedPetalBlock(class_1767.field_7952, class_4970.class_2251.method_9630(whiteFlower).method_9626(class_2498.field_28697).method_9631(s -> 4));
	public static final class_2248 orangeBuriedPetals = new BuriedPetalBlock(class_1767.field_7946, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 magentaBuriedPetals = new BuriedPetalBlock(class_1767.field_7958, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 lightBlueBuriedPetals = new BuriedPetalBlock(class_1767.field_7951, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 yellowBuriedPetals = new BuriedPetalBlock(class_1767.field_7947, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 limeBuriedPetals = new BuriedPetalBlock(class_1767.field_7961, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 pinkBuriedPetals = new BuriedPetalBlock(class_1767.field_7954, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 grayBuriedPetals = new BuriedPetalBlock(class_1767.field_7944, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 lightGrayBuriedPetals = new BuriedPetalBlock(class_1767.field_7967, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 cyanBuriedPetals = new BuriedPetalBlock(class_1767.field_7955, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 purpleBuriedPetals = new BuriedPetalBlock(class_1767.field_7945, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 blueBuriedPetals = new BuriedPetalBlock(class_1767.field_7966, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 brownBuriedPetals = new BuriedPetalBlock(class_1767.field_7957, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 greenBuriedPetals = new BuriedPetalBlock(class_1767.field_7942, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 redBuriedPetals = new BuriedPetalBlock(class_1767.field_7964, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 blackBuriedPetals = new BuriedPetalBlock(class_1767.field_7963, class_4970.class_2251.method_9630(whiteBuriedPetals));

	public static final class_4970.class_2251 FLOATING_PROPS = class_4970.class_2251.method_9637(class_3614.field_15941).method_9632(0.5F).method_9626(class_2498.field_11529).method_9631(s -> 15);
	public static final class_2248 whiteFloatingFlower = new FloatingFlowerBlock(class_1767.field_7952, FLOATING_PROPS);
	public static final class_2248 orangeFloatingFlower = new FloatingFlowerBlock(class_1767.field_7946, FLOATING_PROPS);
	public static final class_2248 magentaFloatingFlower = new FloatingFlowerBlock(class_1767.field_7958, FLOATING_PROPS);
	public static final class_2248 lightBlueFloatingFlower = new FloatingFlowerBlock(class_1767.field_7951, FLOATING_PROPS);
	public static final class_2248 yellowFloatingFlower = new FloatingFlowerBlock(class_1767.field_7947, FLOATING_PROPS);
	public static final class_2248 limeFloatingFlower = new FloatingFlowerBlock(class_1767.field_7961, FLOATING_PROPS);
	public static final class_2248 pinkFloatingFlower = new FloatingFlowerBlock(class_1767.field_7954, FLOATING_PROPS);
	public static final class_2248 grayFloatingFlower = new FloatingFlowerBlock(class_1767.field_7944, FLOATING_PROPS);
	public static final class_2248 lightGrayFloatingFlower = new FloatingFlowerBlock(class_1767.field_7967, FLOATING_PROPS);
	public static final class_2248 cyanFloatingFlower = new FloatingFlowerBlock(class_1767.field_7955, FLOATING_PROPS);
	public static final class_2248 purpleFloatingFlower = new FloatingFlowerBlock(class_1767.field_7945, FLOATING_PROPS);
	public static final class_2248 blueFloatingFlower = new FloatingFlowerBlock(class_1767.field_7966, FLOATING_PROPS);
	public static final class_2248 brownFloatingFlower = new FloatingFlowerBlock(class_1767.field_7957, FLOATING_PROPS);
	public static final class_2248 greenFloatingFlower = new FloatingFlowerBlock(class_1767.field_7942, FLOATING_PROPS);
	public static final class_2248 redFloatingFlower = new FloatingFlowerBlock(class_1767.field_7964, FLOATING_PROPS);
	public static final class_2248 blackFloatingFlower = new FloatingFlowerBlock(class_1767.field_7963, FLOATING_PROPS);

	public static final class_2248 petalBlockWhite = new PetalBlock(class_1767.field_7952, class_4970.class_2251.method_9637(class_3614.field_15935).method_9632(0.4F).method_9626(class_2498.field_28697));
	public static final class_2248 petalBlockOrange = new PetalBlock(class_1767.field_7946, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockMagenta = new PetalBlock(class_1767.field_7958, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockLightBlue = new PetalBlock(class_1767.field_7951, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockYellow = new PetalBlock(class_1767.field_7947, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockLime = new PetalBlock(class_1767.field_7961, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockPink = new PetalBlock(class_1767.field_7954, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockGray = new PetalBlock(class_1767.field_7944, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockSilver = new PetalBlock(class_1767.field_7967, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockCyan = new PetalBlock(class_1767.field_7955, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockPurple = new PetalBlock(class_1767.field_7945, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockBlue = new PetalBlock(class_1767.field_7966, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockBrown = new PetalBlock(class_1767.field_7957, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockGreen = new PetalBlock(class_1767.field_7942, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockRed = new PetalBlock(class_1767.field_7964, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockBlack = new PetalBlock(class_1767.field_7963, class_4970.class_2251.method_9630(petalBlockWhite));

	public static final class_2248 whiteMushroom = new BotaniaMushroomBlock(class_1767.field_7952, class_4970.class_2251.method_9630(whiteFlower).method_9631(s -> 3));
	public static final class_2248 orangeMushroom = new BotaniaMushroomBlock(class_1767.field_7946, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 magentaMushroom = new BotaniaMushroomBlock(class_1767.field_7958, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 lightBlueMushroom = new BotaniaMushroomBlock(class_1767.field_7951, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 yellowMushroom = new BotaniaMushroomBlock(class_1767.field_7947, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 limeMushroom = new BotaniaMushroomBlock(class_1767.field_7961, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 pinkMushroom = new BotaniaMushroomBlock(class_1767.field_7954, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 grayMushroom = new BotaniaMushroomBlock(class_1767.field_7944, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 lightGrayMushroom = new BotaniaMushroomBlock(class_1767.field_7967, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 cyanMushroom = new BotaniaMushroomBlock(class_1767.field_7955, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 purpleMushroom = new BotaniaMushroomBlock(class_1767.field_7945, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 blueMushroom = new BotaniaMushroomBlock(class_1767.field_7966, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 brownMushroom = new BotaniaMushroomBlock(class_1767.field_7957, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 greenMushroom = new BotaniaMushroomBlock(class_1767.field_7942, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 redMushroom = new BotaniaMushroomBlock(class_1767.field_7964, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 blackMushroom = new BotaniaMushroomBlock(class_1767.field_7963, class_4970.class_2251.method_9630(whiteMushroom));

	public static final class_2248 doubleFlowerWhite = new BotaniaDoubleFlowerBlock(class_1767.field_7952, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 doubleFlowerOrange = new BotaniaDoubleFlowerBlock(class_1767.field_7946, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerMagenta = new BotaniaDoubleFlowerBlock(class_1767.field_7958, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerLightBlue = new BotaniaDoubleFlowerBlock(class_1767.field_7951, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerYellow = new BotaniaDoubleFlowerBlock(class_1767.field_7947, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerLime = new BotaniaDoubleFlowerBlock(class_1767.field_7961, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerPink = new BotaniaDoubleFlowerBlock(class_1767.field_7954, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerGray = new BotaniaDoubleFlowerBlock(class_1767.field_7944, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerLightGray = new BotaniaDoubleFlowerBlock(class_1767.field_7967, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerCyan = new BotaniaDoubleFlowerBlock(class_1767.field_7955, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerPurple = new BotaniaDoubleFlowerBlock(class_1767.field_7945, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerBlue = new BotaniaDoubleFlowerBlock(class_1767.field_7966, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerBrown = new BotaniaDoubleFlowerBlock(class_1767.field_7957, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerGreen = new BotaniaDoubleFlowerBlock(class_1767.field_7942, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerRed = new BotaniaDoubleFlowerBlock(class_1767.field_7964, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerBlack = new BotaniaDoubleFlowerBlock(class_1767.field_7963, class_4970.class_2251.method_9630(doubleFlowerWhite));

	public static final class_2248 defaultAltar = new PetalApothecaryBlock(PetalApothecaryBlock.Variant.DEFAULT, class_4970.class_2251.method_9637(class_3614.field_15914).method_9632(3.5F).method_9626(class_2498.field_11544)
			.method_29292()
			.method_9631(s -> s.method_11654(PetalApothecaryBlock.FLUID) == PetalApothecary.State.LAVA ? 15 : 0));
	public static final class_2248 mossyAltar = new PetalApothecaryBlock(PetalApothecaryBlock.Variant.MOSSY, class_4970.class_2251.method_9630(defaultAltar));
	public static final class_2248 forestAltar = new PetalApothecaryBlock(PetalApothecaryBlock.Variant.FOREST, class_4970.class_2251.method_9630(defaultAltar).method_9626(class_2498.field_27202));
	public static final class_2248 plainsAltar = new PetalApothecaryBlock(PetalApothecaryBlock.Variant.PLAINS, class_4970.class_2251.method_9630(defaultAltar).method_9626(class_2498.field_27203));
	public static final class_2248 mountainAltar = new PetalApothecaryBlock(PetalApothecaryBlock.Variant.MOUNTAIN, class_4970.class_2251.method_9630(defaultAltar).method_9626(class_2498.field_29035));
	public static final class_2248 fungalAltar = new PetalApothecaryBlock(PetalApothecaryBlock.Variant.FUNGAL, class_4970.class_2251.method_9630(defaultAltar).method_9626(class_2498.field_29034));
	public static final class_2248 swampAltar = new PetalApothecaryBlock(PetalApothecaryBlock.Variant.SWAMP, class_4970.class_2251.method_9630(defaultAltar).method_9626(class_2498.field_29035));
	public static final class_2248 desertAltar = new PetalApothecaryBlock(PetalApothecaryBlock.Variant.DESERT, class_4970.class_2251.method_9630(defaultAltar).method_9626(class_2498.field_29033));
	public static final class_2248 taigaAltar = new PetalApothecaryBlock(PetalApothecaryBlock.Variant.TAIGA, class_4970.class_2251.method_9630(defaultAltar).method_9626(class_2498.field_29033));
	public static final class_2248 mesaAltar = new PetalApothecaryBlock(PetalApothecaryBlock.Variant.MESA, class_4970.class_2251.method_9630(defaultAltar).method_9626(class_2498.field_27203));
	public static final class_2248 livingrockAltar = new PetalApothecaryBlock(PetalApothecaryBlock.Variant.LIVINGROCK, class_4970.class_2251.method_9630(defaultAltar).method_9626(class_2498.field_11544));
	public static final class_2248 deepslateAltar = new PetalApothecaryBlock(PetalApothecaryBlock.Variant.DEEPSLATE, class_4970.class_2251.method_9630(defaultAltar).method_9626(class_2498.field_29033));

	public static final class_2248 livingrock = new BotaniaBlock(class_4970.class_2251.method_9637(class_3614.field_15914).method_9629(2, 10).method_9626(class_2498.field_11544).method_29292());
	public static final class_2248 livingrockPolished = new BotaniaBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 livingrockBrick = new BotaniaBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 livingrockBrickChiseled = new BotaniaBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 livingrockBrickCracked = new BotaniaBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 livingrockBrickMossy = new BotaniaBlock(class_4970.class_2251.method_9630(livingrock));

	public static final class_2248 livingwoodLog = new class_2465(class_4970.class_2251.method_9637(class_3614.field_15932).method_9632(2).method_9626(class_2498.field_11547)); // TODO color
	public static final class_2248 livingwoodLogStripped = new class_2465(class_4970.class_2251.method_9630(livingwoodLog));
	public static final class_2248 livingwoodLogGlimmering = new class_2465(class_4970.class_2251.method_9630(livingwoodLog).method_9631(b -> 12));
	public static final class_2248 livingwoodLogStrippedGlimmering = new class_2465(class_4970.class_2251.method_9630(livingwoodLog).method_9631(b -> 8));
	public static final class_2248 livingwood = new class_2465(class_4970.class_2251.method_9630(livingwoodLog));
	public static final class_2248 livingwoodStripped = new class_2465(class_4970.class_2251.method_9630(livingwoodLog));
	public static final class_2248 livingwoodGlimmering = new class_2465(class_4970.class_2251.method_9630(livingwoodLogGlimmering));
	public static final class_2248 livingwoodStrippedGlimmering = new class_2465(class_4970.class_2251.method_9630(livingwoodLogStrippedGlimmering));
	public static final class_2248 livingwoodPlanks = new BotaniaBlock(class_4970.class_2251.method_9630(livingwoodLog));
	public static final class_2248 livingwoodPlanksMossy = new BotaniaBlock(class_4970.class_2251.method_9630(livingwoodLog));
	public static final class_2248 livingwoodFramed = new class_2465(class_4970.class_2251.method_9630(livingwoodLog));
	public static final class_2248 livingwoodPatternFramed = new BotaniaBlock(class_4970.class_2251.method_9630(livingwoodLog));

	public static final class_2248 dreamwoodLog = new class_2465(class_4970.class_2251.method_9630(livingwoodLog));
	public static final class_2248 dreamwoodLogStripped = new class_2465(class_4970.class_2251.method_9630(livingwoodLog));
	public static final class_2248 dreamwoodLogGlimmering = new class_2465(class_4970.class_2251.method_9630(livingwoodLogGlimmering));
	public static final class_2248 dreamwoodLogStrippedGlimmering = new class_2465(class_4970.class_2251.method_9630(livingwoodLogStrippedGlimmering));
	public static final class_2248 dreamwood = new class_2465(class_4970.class_2251.method_9630(livingwoodLog));
	public static final class_2248 dreamwoodStripped = new class_2465(class_4970.class_2251.method_9630(livingwoodLog));
	public static final class_2248 dreamwoodGlimmering = new class_2465(class_4970.class_2251.method_9630(livingwoodLogGlimmering));
	public static final class_2248 dreamwoodStrippedGlimmering = new class_2465(class_4970.class_2251.method_9630(livingwoodLogStrippedGlimmering));
	public static final class_2248 dreamwoodPlanks = new BotaniaBlock(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 dreamwoodPlanksMossy = new BotaniaBlock(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 dreamwoodFramed = new class_2465(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 dreamwoodPatternFramed = new BotaniaBlock(class_4970.class_2251.method_9630(livingwood));

	public static final class_2248 manaSpreader = new ManaSpreaderBlock(ManaSpreaderBlock.Variant.MANA, class_4970.class_2251.method_9630(livingwood).method_26235(NO_SPAWN));
	public static final class_2248 redstoneSpreader = new ManaSpreaderBlock(ManaSpreaderBlock.Variant.REDSTONE, class_4970.class_2251.method_9630(livingwood).method_26235(NO_SPAWN));
	public static final class_2248 elvenSpreader = new ManaSpreaderBlock(ManaSpreaderBlock.Variant.ELVEN, class_4970.class_2251.method_9630(livingwood).method_26235(NO_SPAWN));
	public static final class_2248 gaiaSpreader = new ManaSpreaderBlock(ManaSpreaderBlock.Variant.GAIA, class_4970.class_2251.method_9630(livingwood).method_26235(NO_SPAWN));

	public static final class_2248 manaPool = new ManaPoolBlock(ManaPoolBlock.Variant.DEFAULT, class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 creativePool = new ManaPoolBlock(ManaPoolBlock.Variant.CREATIVE, class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 dilutedPool = new ManaPoolBlock(ManaPoolBlock.Variant.DILUTED, class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 fabulousPool = new ManaPoolBlock(ManaPoolBlock.Variant.FABULOUS, class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 alchemyCatalyst = new AlchemyCatalystBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 conjurationCatalyst = new ConjurationCatalystBlock(class_4970.class_2251.method_9630(livingrock));

	public static final class_2248 manasteelBlock = new BotaniaBlock(class_4970.class_2251.method_9637(class_3614.field_15953).method_9629(3, 10).method_9626(class_2498.field_11533).method_29292());
	public static final class_2248 terrasteelBlock = new BotaniaBlock(class_4970.class_2251.method_9630(manasteelBlock));
	public static final class_2248 elementiumBlock = new BotaniaBlock(class_4970.class_2251.method_9630(manasteelBlock));
	public static final class_2248 manaDiamondBlock = new BotaniaBlock(class_4970.class_2251.method_9630(manasteelBlock));
	public static final class_2248 dragonstoneBlock = new BotaniaBlock(class_4970.class_2251.method_9630(manasteelBlock));

	public static final class_2248 manaGlass = new BotaniaGlassBlock(class_4970.class_2251.method_9630(class_2246.field_10033).method_9631(s -> 15).method_26245(NO_SUFFOCATION).method_26243(NO_SUFFOCATION).method_26235(NO_SPAWN));
	public static final class_2248 elfGlass = new BotaniaGlassBlock(class_4970.class_2251.method_9630(manaGlass).method_26245(NO_SUFFOCATION).method_26243(NO_SUFFOCATION).method_26235(NO_SPAWN));
	public static final class_2248 bifrost = new BifrostBlock(class_4970.class_2251.method_9637(class_3614.field_15942).method_9629(-1, 0.3F)
			.method_9631(s -> 15).method_9626(class_2498.field_11537).method_22488().method_26245(NO_SUFFOCATION).method_26243(NO_SUFFOCATION).method_26235(NO_SPAWN));
	public static final class_2248 bifrostPerm = new PermanentBifrostBlock(class_4970.class_2251.method_9637(class_3614.field_15942).method_9632(0.3F)
			.method_9631(s -> 15).method_9626(class_2498.field_11537).method_22488().method_26245(NO_SUFFOCATION).method_26243(NO_SUFFOCATION).method_26235(NO_SPAWN));

	public static final class_2248 runeAltar = new RunicAltarBlock(class_4970.class_2251.method_9630(livingrock).method_29292());
	public static final class_2248 enchanter = new ManaEnchanterBlock(class_4970.class_2251.method_9637(class_3614.field_15914).method_9629(3, 5).method_9631(s -> 15).method_9626(class_2498.field_11544));
	public static final class_2248 brewery = new BotanicalBreweryBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 terraPlate = new TerrestrialAgglomerationPlateBlock(class_4970.class_2251.method_9637(class_3614.field_15953).method_9629(3, 10).method_9626(class_2498.field_11533).method_29292());
	public static final class_2248 alfPortal = new AlfheimPortalBlock(class_4970.class_2251.method_9637(class_3614.field_15932).method_9632(10).method_9626(class_2498.field_11547)
			.method_9631(s -> s.method_11654(BotaniaStateProperties.ALFPORTAL_STATE) != AlfheimPortalState.OFF ? 15 : 0));

	public static final class_2248 manaPylon = new PylonBlock(PylonBlock.Variant.MANA, class_4970.class_2251.method_9637(class_3614.field_15953).method_9632(5.5F).method_9626(class_2498.field_11533).method_9631(s -> 7).method_29292());
	public static final class_2248 naturaPylon = new PylonBlock(PylonBlock.Variant.NATURA, class_4970.class_2251.method_9630(manaPylon));
	public static final class_2248 gaiaPylon = new PylonBlock(PylonBlock.Variant.GAIA, class_4970.class_2251.method_9630(manaPylon));

	public static final class_2248 distributor = new ManaSplitterBlock(class_4970.class_2251.method_9637(class_3614.field_15914).method_9629(2, 10).method_9626(class_2498.field_11544).method_29292());
	public static final class_2248 manaVoid = new ManaVoidBlock(class_4970.class_2251.method_9637(class_3614.field_15914).method_9629(2, 2000).method_9626(class_2498.field_11544).method_29292());
	public static final class_2248 manaDetector = new ManaDetectorBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 pistonRelay = new ForceRelayBlock(class_4970.class_2251.method_9637(class_3614.field_15953).method_9629(2, 10).method_9626(class_2498.field_11533).method_26235(NO_SPAWN));
	public static final class_2248 turntable = new SpreaderTurntableBlock(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 tinyPlanet = new TinyPlanetBlock(class_4970.class_2251.method_9637(class_3614.field_15914).method_9629(20, 100).method_9626(class_2498.field_11544).method_29292());
	public static final class_2248 wildDrum = new DrumBlock(DrumBlock.Variant.WILD, class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 gatheringDrum = new DrumBlock(DrumBlock.Variant.GATHERING, class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 canopyDrum = new DrumBlock(DrumBlock.Variant.CANOPY, class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 spawnerClaw = new LifeImbuerBlock(class_4970.class_2251.method_9637(class_3614.field_15953).method_9632(3).method_29292());
	public static final class_2248 rfGenerator = new PowerGeneratorBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 prism = new ManaPrismBlock(class_4970.class_2251.method_9630(elfGlass).method_9634());
	public static final class_2248 pump = new ManaPumpBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 sparkChanger = new SparkTinkererBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 manaBomb = new ManastormChargeBlock(class_4970.class_2251.method_9637(class_3614.field_15932).method_9632(12).method_9626(class_2498.field_11547));
	public static final class_2248 bellows = new BellowsBlock(class_4970.class_2251.method_9630(livingwood));

	public static final class_2248 openCrate = new OpenCrateBlock(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 craftCrate = new CraftyCrateBlock(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 forestEye = new EyeOfTheAncientsBlock(class_4970.class_2251.method_9637(class_3614.field_15953).method_9629(5, 10).method_9626(class_2498.field_11533).method_29292());
	public static final class_2248 solidVines = new SolidVineBlock(class_4970.class_2251.method_9637(class_3614.field_15956).method_9632(0.2F).method_9626(class_2498.field_23083).method_22488());
	public static final class_2248 abstrusePlatform = new PlatformBlock(PlatformBlock.Variant.ABSTRUSE, class_4970.class_2251.method_9637(class_3614.field_15932).method_9629(2, 5).method_9626(class_2498.field_11547).method_26235(NO_SPAWN).method_22488().method_26245(NO_SUFFOCATION).method_26243(NO_SUFFOCATION));
	public static final class_2248 spectralPlatform = new PlatformBlock(PlatformBlock.Variant.SPECTRAL, class_4970.class_2251.method_9630(abstrusePlatform));
	public static final class_2248 infrangiblePlatform = new PlatformBlock(PlatformBlock.Variant.INFRANGIBLE, class_4970.class_2251.method_9637(class_3614.field_15932).method_9629(-1, Float.MAX_VALUE).method_9626(class_2498.field_11547).method_26235(NO_SPAWN).method_22488());
	public static final class_2248 tinyPotato = new TinyPotatoBlock(class_4970.class_2251.method_9637(class_3614.field_15931).method_9632(0.25F));
	public static final class_2248 enderEye = new EnderOverseerBlock(class_4970.class_2251.method_9630(manasteelBlock));
	public static final class_2248 redStringContainer = new RedStringContainerBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 redStringDispenser = new RedStringDispenserBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 redStringFertilizer = new RedStringNutrifierBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 redStringComparator = new RedStringComparatorBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 redStringRelay = new RedStringSpooferBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 redStringInterceptor = new RedStringInterceptorBlock(class_4970.class_2251.method_9630(livingrock));

	public static final class_2248 corporeaIndex = new CorporeaIndexBlock(class_4970.class_2251.method_9637(class_3614.field_15953).method_9632(5.5F).method_9626(class_2498.field_11533).method_22488().method_29292());
	public static final class_2248 corporeaFunnel = new CorporeaFunnelBlock(class_4970.class_2251.method_9637(class_3614.field_15953).method_9632(5.5F).method_9626(class_2498.field_11533).method_29292());
	public static final class_2248 corporeaInterceptor = new CorporeaInterceptorBlock(class_4970.class_2251.method_9637(class_3614.field_15953).method_9632(5.5F).method_9626(class_2498.field_11533).method_29292());
	public static final class_2248 corporeaCrystalCube = new CorporeaCrystalCubeBlock(class_4970.class_2251.method_9630(corporeaInterceptor));
	public static final class_2248 corporeaRetainer = new CorporeaRetainerBlock(class_4970.class_2251.method_9630(corporeaInterceptor));

	public static final class_2248 corporeaBlock = new BotaniaBlock(class_4970.class_2251.method_9637(class_3614.field_15953).method_9632(5.5F).method_9626(class_2498.field_11533).method_29292());
	public static final class_2248 corporeaBrick = new BotaniaBlock(class_4970.class_2251.method_9630(corporeaBlock));
	public static final class_2482 corporeaSlab = new class_2482(class_4970.class_2251.method_9630(corporeaBlock));
	public static final class_2510 corporeaStairs = new BotaniaStairBlock(corporeaBlock.method_9564(), class_4970.class_2251.method_9630(corporeaBlock));
	public static final class_2482 corporeaBrickSlab = new class_2482(class_4970.class_2251.method_9630(corporeaBrick));
	public static final class_2510 corporeaBrickStairs = new BotaniaStairBlock(corporeaBrick.method_9564(), class_4970.class_2251.method_9630(corporeaBrick));
	public static final class_2248 corporeaBrickWall = new class_2544(class_4970.class_2251.method_9630(corporeaBrick));

	public static final class_2248 incensePlate = new IncensePlateBlock(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 hourglass = new HoveringHourglassBlock(class_4970.class_2251.method_9637(class_3614.field_15953).method_9632(2).method_9626(class_2498.field_11533));
	public static final class_2248 ghostRail = new SpectralRailBlock(class_4970.class_2251.method_9630(class_2246.field_10167));
	public static final class_2248 lightRelayDefault = new LuminizerBlock(LuminizerVariant.DEFAULT, class_4970.class_2251.method_9637(class_3614.field_15942).method_9634());
	public static final class_2248 lightRelayDetector = new LuminizerBlock(LuminizerVariant.DETECTOR, class_4970.class_2251.method_9630(lightRelayDefault));
	public static final class_2248 lightRelayFork = new LuminizerBlock(LuminizerVariant.FORK, class_4970.class_2251.method_9630(lightRelayDefault));
	public static final class_2248 lightRelayToggle = new LuminizerBlock(LuminizerVariant.TOGGLE, class_4970.class_2251.method_9630(lightRelayDefault));
	public static final class_2248 lightLauncher = new LuminizerLauncherBlock(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 cacophonium = new CacophoniumBlock(class_4970.class_2251.method_9637(class_3614.field_15932).method_9632(0.8F));
	public static final class_2248 cellBlock = new CellularBlock(class_4970.class_2251.method_9637(class_3614.field_15954).method_9626(class_2498.field_11543));
	public static final class_2248 teruTeruBozu = new TeruTeruBozuBlock(class_4970.class_2251.method_9637(class_3614.field_15931));
	public static final class_2248 avatar = new AvatarBlock(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 fakeAir = new FakeAirBlock(class_4970.class_2251.method_9637(class_3614.field_15927).method_26250().method_9640());
	public static final class_2248 root = new LivingRootBlock(class_4970.class_2251.method_9637(class_3614.field_15935).method_9632(1.2F).method_9626(class_2498.field_11547));
	public static final class_2248 felPumpkin = new FelPumpkinBlock(class_4970.class_2251.method_9630(class_2246.field_10147));
	public static final class_2248 cocoon = new CocoonBlock(class_4970.class_2251.method_9637(class_3614.field_15931).method_9629(3, 60).method_9626(class_2498.field_11543));
	public static final class_2248 enchantedSoil = new EnchantedSoilBlock(class_4970.class_2251.method_9637(class_3614.field_15945).method_9632(0.6F).method_9626(class_2498.field_11535));
	public static final class_2248 animatedTorch = new AnimatedTorchBlock(class_4970.class_2251.method_9637(class_3614.field_15924).method_9631(s -> 7).method_22488());
	public static final class_2248 starfield = new StarfieldCreatorBlock(class_4970.class_2251.method_9637(class_3614.field_15953).method_9629(5, 2000).method_9626(class_2498.field_11533));

	public static final class_2248 azulejo0 = new BotaniaBlock(class_4970.class_2251.method_9637(class_3614.field_15914).method_9629(2, 5).method_9626(class_2498.field_11544).method_29292());
	public static final class_2248 azulejo1 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo2 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo3 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo4 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo5 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo6 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo7 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo8 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo9 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo10 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo11 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo12 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo13 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo14 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo15 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 manaFlame = new ManaFlameBlock(class_4970.class_2251.method_9637(class_3614.field_15924).method_9626(class_2498.field_11543).method_9631(s -> 15).method_9634());
	public static final class_2248 blazeBlock = new BotaniaBlock(class_4970.class_2251.method_9630(manasteelBlock).method_9631(s -> 15));
	public static final class_2248 gaiaHeadWall = new WallGaiaHeadBlock(class_4970.class_2251.method_9637(class_3614.field_15924).method_9632(1));
	public static final class_2248 gaiaHead = new GaiaHeadBlock(class_4970.class_2251.method_9637(class_3614.field_15924).method_9632(1));
	public static final class_2248 shimmerrock = new BotaniaBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 shimmerwoodPlanks = new BotaniaBlock(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 dryGrass = new BotaniaGrassBlock(BotaniaGrassBlock.Variant.DRY, class_4970.class_2251.method_9637(class_3614.field_15945).method_9632(0.6F).method_9640().method_9626(class_2498.field_11535));
	public static final class_2248 goldenGrass = new BotaniaGrassBlock(BotaniaGrassBlock.Variant.GOLDEN, class_4970.class_2251.method_9630(dryGrass));
	public static final class_2248 vividGrass = new BotaniaGrassBlock(BotaniaGrassBlock.Variant.VIVID, class_4970.class_2251.method_9630(dryGrass));
	public static final class_2248 scorchedGrass = new BotaniaGrassBlock(BotaniaGrassBlock.Variant.SCORCHED, class_4970.class_2251.method_9630(dryGrass));
	public static final class_2248 infusedGrass = new BotaniaGrassBlock(BotaniaGrassBlock.Variant.INFUSED, class_4970.class_2251.method_9630(dryGrass));
	public static final class_2248 mutatedGrass = new BotaniaGrassBlock(BotaniaGrassBlock.Variant.MUTATED, class_4970.class_2251.method_9630(dryGrass));

	public static final class_2248 motifDaybloom = new FlowerMotifBlock(class_1294.field_5919, 15, class_4970.class_2251.method_9630(class_2246.field_10449), true);
	public static final class_2248 motifNightshade = new FlowerMotifBlock(class_1294.field_5899, 20, class_4970.class_2251.method_9630(class_2246.field_10449), true);
	public static final class_2248 motifHydroangeas = new FlowerMotifBlock(class_1294.field_5908, 10, class_4970.class_2251.method_9630(class_2246.field_10449), false);

	public static void registerBlocks(BiConsumer<class_2248, class_2960> r) {
		r.accept(whiteFlower, prefix("white" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX));
		r.accept(orangeFlower, prefix("orange" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX));
		r.accept(magentaFlower, prefix("magenta" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX));
		r.accept(lightBlueFlower, prefix("light_blue" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX));
		r.accept(yellowFlower, prefix("yellow" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX));
		r.accept(limeFlower, prefix("lime" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX));
		r.accept(pinkFlower, prefix("pink" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX));
		r.accept(grayFlower, prefix("gray" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX));
		r.accept(lightGrayFlower, prefix("light_gray" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX));
		r.accept(cyanFlower, prefix("cyan" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX));
		r.accept(purpleFlower, prefix("purple" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX));
		r.accept(blueFlower, prefix("blue" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX));
		r.accept(brownFlower, prefix("brown" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX));
		r.accept(greenFlower, prefix("green" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX));
		r.accept(redFlower, prefix("red" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX));
		r.accept(blackFlower, prefix("black" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX));
		r.accept(whiteShinyFlower, prefix("white" + LibBlockNames.SHINY_FLOWER_SUFFIX));
		r.accept(orangeShinyFlower, prefix("orange" + LibBlockNames.SHINY_FLOWER_SUFFIX));
		r.accept(magentaShinyFlower, prefix("magenta" + LibBlockNames.SHINY_FLOWER_SUFFIX));
		r.accept(lightBlueShinyFlower, prefix("light_blue" + LibBlockNames.SHINY_FLOWER_SUFFIX));
		r.accept(yellowShinyFlower, prefix("yellow" + LibBlockNames.SHINY_FLOWER_SUFFIX));
		r.accept(limeShinyFlower, prefix("lime" + LibBlockNames.SHINY_FLOWER_SUFFIX));
		r.accept(pinkShinyFlower, prefix("pink" + LibBlockNames.SHINY_FLOWER_SUFFIX));
		r.accept(grayShinyFlower, prefix("gray" + LibBlockNames.SHINY_FLOWER_SUFFIX));
		r.accept(lightGrayShinyFlower, prefix("light_gray" + LibBlockNames.SHINY_FLOWER_SUFFIX));
		r.accept(cyanShinyFlower, prefix("cyan" + LibBlockNames.SHINY_FLOWER_SUFFIX));
		r.accept(purpleShinyFlower, prefix("purple" + LibBlockNames.SHINY_FLOWER_SUFFIX));
		r.accept(blueShinyFlower, prefix("blue" + LibBlockNames.SHINY_FLOWER_SUFFIX));
		r.accept(brownShinyFlower, prefix("brown" + LibBlockNames.SHINY_FLOWER_SUFFIX));
		r.accept(greenShinyFlower, prefix("green" + LibBlockNames.SHINY_FLOWER_SUFFIX));
		r.accept(redShinyFlower, prefix("red" + LibBlockNames.SHINY_FLOWER_SUFFIX));
		r.accept(blackShinyFlower, prefix("black" + LibBlockNames.SHINY_FLOWER_SUFFIX));
		r.accept(whiteBuriedPetals, prefix("white" + LibBlockNames.BURIED_PETALS_SUFFIX));
		r.accept(orangeBuriedPetals, prefix("orange" + LibBlockNames.BURIED_PETALS_SUFFIX));
		r.accept(magentaBuriedPetals, prefix("magenta" + LibBlockNames.BURIED_PETALS_SUFFIX));
		r.accept(lightBlueBuriedPetals, prefix("light_blue" + LibBlockNames.BURIED_PETALS_SUFFIX));
		r.accept(yellowBuriedPetals, prefix("yellow" + LibBlockNames.BURIED_PETALS_SUFFIX));
		r.accept(limeBuriedPetals, prefix("lime" + LibBlockNames.BURIED_PETALS_SUFFIX));
		r.accept(pinkBuriedPetals, prefix("pink" + LibBlockNames.BURIED_PETALS_SUFFIX));
		r.accept(grayBuriedPetals, prefix("gray" + LibBlockNames.BURIED_PETALS_SUFFIX));
		r.accept(lightGrayBuriedPetals, prefix("light_gray" + LibBlockNames.BURIED_PETALS_SUFFIX));
		r.accept(cyanBuriedPetals, prefix("cyan" + LibBlockNames.BURIED_PETALS_SUFFIX));
		r.accept(purpleBuriedPetals, prefix("purple" + LibBlockNames.BURIED_PETALS_SUFFIX));
		r.accept(blueBuriedPetals, prefix("blue" + LibBlockNames.BURIED_PETALS_SUFFIX));
		r.accept(brownBuriedPetals, prefix("brown" + LibBlockNames.BURIED_PETALS_SUFFIX));
		r.accept(greenBuriedPetals, prefix("green" + LibBlockNames.BURIED_PETALS_SUFFIX));
		r.accept(redBuriedPetals, prefix("red" + LibBlockNames.BURIED_PETALS_SUFFIX));
		r.accept(blackBuriedPetals, prefix("black" + LibBlockNames.BURIED_PETALS_SUFFIX));
		r.accept(whiteFloatingFlower, prefix("white" + LibBlockNames.FLOATING_FLOWER_SUFFIX));
		r.accept(orangeFloatingFlower, prefix("orange" + LibBlockNames.FLOATING_FLOWER_SUFFIX));
		r.accept(magentaFloatingFlower, prefix("magenta" + LibBlockNames.FLOATING_FLOWER_SUFFIX));
		r.accept(lightBlueFloatingFlower, prefix("light_blue" + LibBlockNames.FLOATING_FLOWER_SUFFIX));
		r.accept(yellowFloatingFlower, prefix("yellow" + LibBlockNames.FLOATING_FLOWER_SUFFIX));
		r.accept(limeFloatingFlower, prefix("lime" + LibBlockNames.FLOATING_FLOWER_SUFFIX));
		r.accept(pinkFloatingFlower, prefix("pink" + LibBlockNames.FLOATING_FLOWER_SUFFIX));
		r.accept(grayFloatingFlower, prefix("gray" + LibBlockNames.FLOATING_FLOWER_SUFFIX));
		r.accept(lightGrayFloatingFlower, prefix("light_gray" + LibBlockNames.FLOATING_FLOWER_SUFFIX));
		r.accept(cyanFloatingFlower, prefix("cyan" + LibBlockNames.FLOATING_FLOWER_SUFFIX));
		r.accept(purpleFloatingFlower, prefix("purple" + LibBlockNames.FLOATING_FLOWER_SUFFIX));
		r.accept(blueFloatingFlower, prefix("blue" + LibBlockNames.FLOATING_FLOWER_SUFFIX));
		r.accept(brownFloatingFlower, prefix("brown" + LibBlockNames.FLOATING_FLOWER_SUFFIX));
		r.accept(greenFloatingFlower, prefix("green" + LibBlockNames.FLOATING_FLOWER_SUFFIX));
		r.accept(redFloatingFlower, prefix("red" + LibBlockNames.FLOATING_FLOWER_SUFFIX));
		r.accept(blackFloatingFlower, prefix("black" + LibBlockNames.FLOATING_FLOWER_SUFFIX));
		r.accept(petalBlockWhite, prefix("white" + LibBlockNames.PETAL_BLOCK_SUFFIX));
		r.accept(petalBlockOrange, prefix("orange" + LibBlockNames.PETAL_BLOCK_SUFFIX));
		r.accept(petalBlockMagenta, prefix("magenta" + LibBlockNames.PETAL_BLOCK_SUFFIX));
		r.accept(petalBlockLightBlue, prefix("light_blue" + LibBlockNames.PETAL_BLOCK_SUFFIX));
		r.accept(petalBlockYellow, prefix("yellow" + LibBlockNames.PETAL_BLOCK_SUFFIX));
		r.accept(petalBlockLime, prefix("lime" + LibBlockNames.PETAL_BLOCK_SUFFIX));
		r.accept(petalBlockPink, prefix("pink" + LibBlockNames.PETAL_BLOCK_SUFFIX));
		r.accept(petalBlockGray, prefix("gray" + LibBlockNames.PETAL_BLOCK_SUFFIX));
		r.accept(petalBlockSilver, prefix("light_gray" + LibBlockNames.PETAL_BLOCK_SUFFIX));
		r.accept(petalBlockCyan, prefix("cyan" + LibBlockNames.PETAL_BLOCK_SUFFIX));
		r.accept(petalBlockPurple, prefix("purple" + LibBlockNames.PETAL_BLOCK_SUFFIX));
		r.accept(petalBlockBlue, prefix("blue" + LibBlockNames.PETAL_BLOCK_SUFFIX));
		r.accept(petalBlockBrown, prefix("brown" + LibBlockNames.PETAL_BLOCK_SUFFIX));
		r.accept(petalBlockGreen, prefix("green" + LibBlockNames.PETAL_BLOCK_SUFFIX));
		r.accept(petalBlockRed, prefix("red" + LibBlockNames.PETAL_BLOCK_SUFFIX));
		r.accept(petalBlockBlack, prefix("black" + LibBlockNames.PETAL_BLOCK_SUFFIX));
		r.accept(whiteMushroom, prefix("white" + LibBlockNames.MUSHROOM_SUFFIX));
		r.accept(orangeMushroom, prefix("orange" + LibBlockNames.MUSHROOM_SUFFIX));
		r.accept(magentaMushroom, prefix("magenta" + LibBlockNames.MUSHROOM_SUFFIX));
		r.accept(lightBlueMushroom, prefix("light_blue" + LibBlockNames.MUSHROOM_SUFFIX));
		r.accept(yellowMushroom, prefix("yellow" + LibBlockNames.MUSHROOM_SUFFIX));
		r.accept(limeMushroom, prefix("lime" + LibBlockNames.MUSHROOM_SUFFIX));
		r.accept(pinkMushroom, prefix("pink" + LibBlockNames.MUSHROOM_SUFFIX));
		r.accept(grayMushroom, prefix("gray" + LibBlockNames.MUSHROOM_SUFFIX));
		r.accept(lightGrayMushroom, prefix("light_gray" + LibBlockNames.MUSHROOM_SUFFIX));
		r.accept(cyanMushroom, prefix("cyan" + LibBlockNames.MUSHROOM_SUFFIX));
		r.accept(purpleMushroom, prefix("purple" + LibBlockNames.MUSHROOM_SUFFIX));
		r.accept(blueMushroom, prefix("blue" + LibBlockNames.MUSHROOM_SUFFIX));
		r.accept(brownMushroom, prefix("brown" + LibBlockNames.MUSHROOM_SUFFIX));
		r.accept(greenMushroom, prefix("green" + LibBlockNames.MUSHROOM_SUFFIX));
		r.accept(redMushroom, prefix("red" + LibBlockNames.MUSHROOM_SUFFIX));
		r.accept(blackMushroom, prefix("black" + LibBlockNames.MUSHROOM_SUFFIX));
		r.accept(doubleFlowerWhite, prefix("white" + LibBlockNames.DOUBLE_FLOWER_SUFFIX));
		r.accept(doubleFlowerOrange, prefix("orange" + LibBlockNames.DOUBLE_FLOWER_SUFFIX));
		r.accept(doubleFlowerMagenta, prefix("magenta" + LibBlockNames.DOUBLE_FLOWER_SUFFIX));
		r.accept(doubleFlowerLightBlue, prefix("light_blue" + LibBlockNames.DOUBLE_FLOWER_SUFFIX));
		r.accept(doubleFlowerYellow, prefix("yellow" + LibBlockNames.DOUBLE_FLOWER_SUFFIX));
		r.accept(doubleFlowerLime, prefix("lime" + LibBlockNames.DOUBLE_FLOWER_SUFFIX));
		r.accept(doubleFlowerPink, prefix("pink" + LibBlockNames.DOUBLE_FLOWER_SUFFIX));
		r.accept(doubleFlowerGray, prefix("gray" + LibBlockNames.DOUBLE_FLOWER_SUFFIX));
		r.accept(doubleFlowerLightGray, prefix("light_gray" + LibBlockNames.DOUBLE_FLOWER_SUFFIX));
		r.accept(doubleFlowerCyan, prefix("cyan" + LibBlockNames.DOUBLE_FLOWER_SUFFIX));
		r.accept(doubleFlowerPurple, prefix("purple" + LibBlockNames.DOUBLE_FLOWER_SUFFIX));
		r.accept(doubleFlowerBlue, prefix("blue" + LibBlockNames.DOUBLE_FLOWER_SUFFIX));
		r.accept(doubleFlowerBrown, prefix("brown" + LibBlockNames.DOUBLE_FLOWER_SUFFIX));
		r.accept(doubleFlowerGreen, prefix("green" + LibBlockNames.DOUBLE_FLOWER_SUFFIX));
		r.accept(doubleFlowerRed, prefix("red" + LibBlockNames.DOUBLE_FLOWER_SUFFIX));
		r.accept(doubleFlowerBlack, prefix("black" + LibBlockNames.DOUBLE_FLOWER_SUFFIX));
		r.accept(defaultAltar, prefix(LibBlockNames.APOTHECARY_PREFIX + PetalApothecaryBlock.Variant.DEFAULT.name().toLowerCase(Locale.ROOT)));
		r.accept(forestAltar, prefix(LibBlockNames.APOTHECARY_PREFIX + PetalApothecaryBlock.Variant.FOREST.name().toLowerCase(Locale.ROOT)));
		r.accept(plainsAltar, prefix(LibBlockNames.APOTHECARY_PREFIX + PetalApothecaryBlock.Variant.PLAINS.name().toLowerCase(Locale.ROOT)));
		r.accept(mountainAltar, prefix(LibBlockNames.APOTHECARY_PREFIX + PetalApothecaryBlock.Variant.MOUNTAIN.name().toLowerCase(Locale.ROOT)));
		r.accept(fungalAltar, prefix(LibBlockNames.APOTHECARY_PREFIX + PetalApothecaryBlock.Variant.FUNGAL.name().toLowerCase(Locale.ROOT)));
		r.accept(swampAltar, prefix(LibBlockNames.APOTHECARY_PREFIX + PetalApothecaryBlock.Variant.SWAMP.name().toLowerCase(Locale.ROOT)));
		r.accept(desertAltar, prefix(LibBlockNames.APOTHECARY_PREFIX + PetalApothecaryBlock.Variant.DESERT.name().toLowerCase(Locale.ROOT)));
		r.accept(taigaAltar, prefix(LibBlockNames.APOTHECARY_PREFIX + PetalApothecaryBlock.Variant.TAIGA.name().toLowerCase(Locale.ROOT)));
		r.accept(mesaAltar, prefix(LibBlockNames.APOTHECARY_PREFIX + PetalApothecaryBlock.Variant.MESA.name().toLowerCase(Locale.ROOT)));
		r.accept(mossyAltar, prefix(LibBlockNames.APOTHECARY_PREFIX + PetalApothecaryBlock.Variant.MOSSY.name().toLowerCase(Locale.ROOT)));
		r.accept(livingrockAltar, prefix(LibBlockNames.APOTHECARY_PREFIX + PetalApothecaryBlock.Variant.LIVINGROCK.name().toLowerCase(Locale.ROOT)));
		r.accept(deepslateAltar, prefix(LibBlockNames.APOTHECARY_PREFIX + PetalApothecaryBlock.Variant.DEEPSLATE.name().toLowerCase(Locale.ROOT)));
		r.accept(livingrock, prefix(LibBlockNames.LIVING_ROCK));
		r.accept(livingrockPolished, prefix(LibBlockNames.LIVING_ROCK_POLISHED));
		r.accept(livingrockBrick, prefix(LibBlockNames.LIVING_ROCK_BRICK));
		r.accept(livingrockBrickChiseled, prefix(LibBlockNames.LIVING_ROCK_BRICK_CHISELED));
		r.accept(livingrockBrickCracked, prefix(LibBlockNames.LIVING_ROCK_BRICK_CRACKED));
		r.accept(livingrockBrickMossy, prefix(LibBlockNames.LIVING_ROCK_BRICK_MOSSY));
		r.accept(livingwoodLog, prefix(LibBlockNames.LIVING_WOOD_LOG));
		r.accept(livingwoodLogStripped, prefix(LibBlockNames.LIVING_WOOD_LOG_STRIPPED));
		r.accept(livingwoodLogGlimmering, prefix(LibBlockNames.LIVING_WOOD_LOG_GLIMMERING));
		r.accept(livingwoodLogStrippedGlimmering, prefix(LibBlockNames.LIVING_WOOD_LOG_GLIMMERING_STRIPPED));
		r.accept(livingwood, prefix(LibBlockNames.LIVING_WOOD));
		r.accept(livingwoodGlimmering, prefix(LibBlockNames.LIVING_WOOD_GLIMMERING));
		r.accept(livingwoodStripped, prefix(LibBlockNames.LIVING_WOOD_STRIPPED));
		r.accept(livingwoodStrippedGlimmering, prefix(LibBlockNames.LIVING_WOOD_GLIMMERING_STRIPPED));
		r.accept(livingwoodPlanks, prefix(LibBlockNames.LIVING_WOOD_PLANKS));
		r.accept(livingwoodPlanksMossy, prefix(LibBlockNames.LIVING_WOOD_PLANKS_MOSSY));
		r.accept(livingwoodFramed, prefix(LibBlockNames.LIVING_WOOD_FRAMED));
		r.accept(livingwoodPatternFramed, prefix(LibBlockNames.LIVING_WOOD_PATTERN_FRAMED));
		r.accept(dreamwoodLog, prefix(LibBlockNames.DREAM_WOOD_LOG));
		r.accept(dreamwoodLogGlimmering, prefix(LibBlockNames.DREAM_WOOD_LOG_GLIMMERING));
		r.accept(dreamwoodLogStripped, prefix(LibBlockNames.DREAM_WOOD_LOG_STRIPPED));
		r.accept(dreamwoodLogStrippedGlimmering, prefix(LibBlockNames.DREAM_WOOD_LOG_GLIMMERING_STRIPPED));
		r.accept(dreamwood, prefix(LibBlockNames.DREAM_WOOD));
		r.accept(dreamwoodGlimmering, prefix(LibBlockNames.DREAM_WOOD_GLIMMERING));
		r.accept(dreamwoodStripped, prefix(LibBlockNames.DREAM_WOOD_STRIPPED));
		r.accept(dreamwoodStrippedGlimmering, prefix(LibBlockNames.DREAM_WOOD_GLIMMERING_STRIPPED));
		r.accept(dreamwoodPlanks, prefix(LibBlockNames.DREAM_WOOD_PLANKS));
		r.accept(dreamwoodPlanksMossy, prefix(LibBlockNames.DREAM_WOOD_PLANKS_MOSSY));
		r.accept(dreamwoodFramed, prefix(LibBlockNames.DREAM_WOOD_FRAMED));
		r.accept(dreamwoodPatternFramed, prefix(LibBlockNames.DREAM_WOOD_PATTERN_FRAMED));
		r.accept(manaSpreader, prefix(LibBlockNames.SPREADER));
		r.accept(redstoneSpreader, prefix(LibBlockNames.SPREADER_REDSTONE));
		r.accept(elvenSpreader, prefix(LibBlockNames.SPREADER_ELVEN));
		r.accept(gaiaSpreader, prefix(LibBlockNames.SPREADER_GAIA));
		r.accept(manaPool, prefix(LibBlockNames.POOL));
		r.accept(creativePool, prefix(LibBlockNames.POOL_CREATIVE));
		r.accept(dilutedPool, prefix(LibBlockNames.POOL_DILUTED));
		r.accept(fabulousPool, prefix(LibBlockNames.POOL_FABULOUS));
		r.accept(alchemyCatalyst, prefix(LibBlockNames.ALCHEMY_CATALYST));
		r.accept(conjurationCatalyst, prefix(LibBlockNames.CONJURATION_CATALYST));
		r.accept(manasteelBlock, prefix(LibBlockNames.MANASTEEL_BLOCK));
		r.accept(terrasteelBlock, prefix(LibBlockNames.TERRASTEEL_BLOCK));
		r.accept(elementiumBlock, prefix(LibBlockNames.ELEMENTIUM_BLOCK));
		r.accept(manaDiamondBlock, prefix(LibBlockNames.MANA_DIAMOND_BLOCK));
		r.accept(dragonstoneBlock, prefix(LibBlockNames.DRAGONSTONE_BLOCK));
		r.accept(manaGlass, prefix(LibBlockNames.MANA_GLASS));
		r.accept(elfGlass, prefix(LibBlockNames.ELF_GLASS));
		r.accept(bifrost, prefix(LibBlockNames.BIFROST));
		r.accept(bifrostPerm, prefix(LibBlockNames.BIFROST_PERM));
		r.accept(runeAltar, prefix(LibBlockNames.RUNE_ALTAR));
		r.accept(enchanter, prefix(LibBlockNames.ENCHANTER));
		r.accept(brewery, prefix(LibBlockNames.BREWERY));
		r.accept(terraPlate, prefix(LibBlockNames.TERRA_PLATE));
		r.accept(alfPortal, prefix(LibBlockNames.ALF_PORTAL));
		r.accept(manaPylon, prefix(LibBlockNames.PYLON));
		r.accept(naturaPylon, prefix(LibBlockNames.PYLON_NATURA));
		r.accept(gaiaPylon, prefix(LibBlockNames.PYLON_GAIA));
		r.accept(distributor, prefix(LibBlockNames.DISTRIBUTOR));
		r.accept(manaVoid, prefix(LibBlockNames.MANA_VOID));
		r.accept(manaDetector, prefix(LibBlockNames.MANA_DETECTOR));
		r.accept(pistonRelay, prefix(LibBlockNames.PISTON_RELAY));
		r.accept(turntable, prefix(LibBlockNames.TURNTABLE));
		r.accept(tinyPlanet, prefix(LibBlockNames.TINY_PLANET));
		r.accept(wildDrum, prefix(LibBlockNames.DRUM_WILD));
		r.accept(gatheringDrum, prefix(LibBlockNames.DRUM_GATHERING));
		r.accept(canopyDrum, prefix(LibBlockNames.DRUM_CANOPY));
		r.accept(spawnerClaw, prefix(LibBlockNames.SPAWNER_CLAW));
		r.accept(rfGenerator, prefix(LibBlockNames.FLUXFIELD));
		r.accept(prism, prefix(LibBlockNames.PRISM));
		r.accept(pump, prefix(LibBlockNames.PUMP));
		r.accept(sparkChanger, prefix(LibBlockNames.SPARK_CHANGER));
		r.accept(manaBomb, prefix(LibBlockNames.MANA_BOMB));
		r.accept(bellows, prefix(LibBlockNames.BELLOWS));
		r.accept(openCrate, prefix(LibBlockNames.OPEN_CRATE));
		r.accept(craftCrate, prefix(LibBlockNames.CRAFT_CRATE));
		r.accept(forestEye, prefix(LibBlockNames.FOREST_EYE));
		r.accept(solidVines, prefix(LibBlockNames.SOLID_VINE));
		r.accept(abstrusePlatform, prefix(LibBlockNames.PLATFORM_ABSTRUSE));
		r.accept(spectralPlatform, prefix(LibBlockNames.PLATFORM_SPECTRAL));
		r.accept(infrangiblePlatform, prefix(LibBlockNames.PLATFORM_INFRANGIBLE));
		r.accept(tinyPotato, prefix(LibBlockNames.TINY_POTATO));
		r.accept(enderEye, prefix(LibBlockNames.ENDER_EYE_BLOCK));
		r.accept(redStringContainer, prefix(LibBlockNames.RED_STRING_CONTAINER));
		r.accept(redStringDispenser, prefix(LibBlockNames.RED_STRING_DISPENSER));
		r.accept(redStringFertilizer, prefix(LibBlockNames.RED_STRING_FERTILIZER));
		r.accept(redStringComparator, prefix(LibBlockNames.RED_STRING_COMPARATOR));
		r.accept(redStringRelay, prefix(LibBlockNames.RED_STRING_RELAY));
		r.accept(redStringInterceptor, prefix(LibBlockNames.RED_STRING_INTERCEPTOR));
		r.accept(corporeaIndex, prefix(LibBlockNames.CORPOREA_INDEX));
		r.accept(corporeaFunnel, prefix(LibBlockNames.CORPOREA_FUNNEL));
		r.accept(corporeaInterceptor, prefix(LibBlockNames.CORPOREA_INTERCEPTOR));
		r.accept(corporeaCrystalCube, prefix(LibBlockNames.CORPOREA_CRYSTAL_CUBE));
		r.accept(corporeaRetainer, prefix(LibBlockNames.CORPOREA_RETAINER));
		r.accept(corporeaBlock, prefix(LibBlockNames.CORPOREA_BLOCK));
		r.accept(corporeaSlab, prefix(LibBlockNames.CORPOREA_SLAB));
		r.accept(corporeaStairs, prefix(LibBlockNames.CORPOREA_STAIRS));
		r.accept(corporeaBrick, prefix(LibBlockNames.CORPOREA_BRICK));
		r.accept(corporeaBrickSlab, prefix(LibBlockNames.CORPOREA_BRICK + LibBlockNames.SLAB_SUFFIX));
		r.accept(corporeaBrickStairs, prefix(LibBlockNames.CORPOREA_BRICK + LibBlockNames.STAIR_SUFFIX));
		r.accept(corporeaBrickWall, prefix(LibBlockNames.CORPOREA_BRICK + LibBlockNames.WALL_SUFFIX));
		r.accept(incensePlate, prefix(LibBlockNames.INCENSE_PLATE));
		r.accept(hourglass, prefix(LibBlockNames.HOURGLASS));
		r.accept(ghostRail, prefix(LibBlockNames.GHOST_RAIL));
		r.accept(lightRelayDefault, prefix(LibBlockNames.LIGHT_RELAY));
		r.accept(lightRelayDetector, prefix("detector" + LibBlockNames.LIGHT_RELAY_SUFFIX));
		r.accept(lightRelayFork, prefix("fork" + LibBlockNames.LIGHT_RELAY_SUFFIX));
		r.accept(lightRelayToggle, prefix("toggle" + LibBlockNames.LIGHT_RELAY_SUFFIX));
		r.accept(lightLauncher, prefix(LibBlockNames.LIGHT_LAUNCHER));
		r.accept(cacophonium, prefix(LibBlockNames.CACOPHONIUM));
		r.accept(cellBlock, prefix(LibBlockNames.CELL_BLOCK));
		r.accept(teruTeruBozu, prefix(LibBlockNames.TERU_TERU_BOZU));
		r.accept(avatar, prefix(LibBlockNames.AVATAR));
		r.accept(fakeAir, prefix(LibBlockNames.FAKE_AIR));
		r.accept(root, prefix(LibBlockNames.ROOT));
		r.accept(felPumpkin, prefix(LibBlockNames.FEL_PUMPKIN));
		r.accept(cocoon, prefix(LibBlockNames.COCOON));
		r.accept(enchantedSoil, prefix(LibBlockNames.ENCHANTED_SOIL));
		r.accept(animatedTorch, prefix(LibBlockNames.ANIMATED_TORCH));
		r.accept(starfield, prefix(LibBlockNames.STARFIELD));
		r.accept(azulejo0, prefix(LibBlockNames.AZULEJO_PREFIX + 0));
		r.accept(azulejo1, prefix(LibBlockNames.AZULEJO_PREFIX + 1));
		r.accept(azulejo2, prefix(LibBlockNames.AZULEJO_PREFIX + 2));
		r.accept(azulejo3, prefix(LibBlockNames.AZULEJO_PREFIX + 3));
		r.accept(azulejo4, prefix(LibBlockNames.AZULEJO_PREFIX + 4));
		r.accept(azulejo5, prefix(LibBlockNames.AZULEJO_PREFIX + 5));
		r.accept(azulejo6, prefix(LibBlockNames.AZULEJO_PREFIX + 6));
		r.accept(azulejo7, prefix(LibBlockNames.AZULEJO_PREFIX + 7));
		r.accept(azulejo8, prefix(LibBlockNames.AZULEJO_PREFIX + 8));
		r.accept(azulejo9, prefix(LibBlockNames.AZULEJO_PREFIX + 9));
		r.accept(azulejo10, prefix(LibBlockNames.AZULEJO_PREFIX + 10));
		r.accept(azulejo11, prefix(LibBlockNames.AZULEJO_PREFIX + 11));
		r.accept(azulejo12, prefix(LibBlockNames.AZULEJO_PREFIX + 12));
		r.accept(azulejo13, prefix(LibBlockNames.AZULEJO_PREFIX + 13));
		r.accept(azulejo14, prefix(LibBlockNames.AZULEJO_PREFIX + 14));
		r.accept(azulejo15, prefix(LibBlockNames.AZULEJO_PREFIX + 15));
		r.accept(manaFlame, prefix(LibBlockNames.MANA_FLAME));
		r.accept(blazeBlock, prefix(LibBlockNames.BLAZE_BLOCK));
		r.accept(gaiaHeadWall, prefix(LibBlockNames.GAIA_WALL_HEAD));
		r.accept(gaiaHead, prefix(LibBlockNames.GAIA_HEAD));
		r.accept(shimmerrock, prefix(LibBlockNames.SHIMMERROCK));
		r.accept(shimmerwoodPlanks, prefix(LibBlockNames.SHIMMERWOOD_PLANKS));
		r.accept(dryGrass, prefix(BotaniaGrassBlock.Variant.DRY.name().toLowerCase(Locale.ROOT) + LibBlockNames.ALT_GRASS_SUFFIX));
		r.accept(goldenGrass, prefix(BotaniaGrassBlock.Variant.GOLDEN.name().toLowerCase(Locale.ROOT) + LibBlockNames.ALT_GRASS_SUFFIX));
		r.accept(vividGrass, prefix(BotaniaGrassBlock.Variant.VIVID.name().toLowerCase(Locale.ROOT) + LibBlockNames.ALT_GRASS_SUFFIX));
		r.accept(scorchedGrass, prefix(BotaniaGrassBlock.Variant.SCORCHED.name().toLowerCase(Locale.ROOT) + LibBlockNames.ALT_GRASS_SUFFIX));
		r.accept(infusedGrass, prefix(BotaniaGrassBlock.Variant.INFUSED.name().toLowerCase(Locale.ROOT) + LibBlockNames.ALT_GRASS_SUFFIX));
		r.accept(mutatedGrass, prefix(BotaniaGrassBlock.Variant.MUTATED.name().toLowerCase(Locale.ROOT) + LibBlockNames.ALT_GRASS_SUFFIX));
		r.accept(motifDaybloom, prefix(LibBlockNames.MOTIF_DAYBLOOM));
		r.accept(motifNightshade, prefix(LibBlockNames.MOTIF_NIGHTSHADE));
		r.accept(motifHydroangeas, prefix(LibBlockNames.MOTIF_HYDROANGEAS));
	}

	public static void registerItemBlocks(BiConsumer<class_1792, class_2960> r) {
		class_1792.class_1793 props = BotaniaItems.defaultBuilder();
		r.accept(new class_1747(whiteFlower, props), class_2378.field_11146.method_10221(whiteFlower));
		r.accept(new class_1747(orangeFlower, props), class_2378.field_11146.method_10221(orangeFlower));
		r.accept(new class_1747(magentaFlower, props), class_2378.field_11146.method_10221(magentaFlower));
		r.accept(new class_1747(lightBlueFlower, props), class_2378.field_11146.method_10221(lightBlueFlower));
		r.accept(new class_1747(yellowFlower, props), class_2378.field_11146.method_10221(yellowFlower));
		r.accept(new class_1747(limeFlower, props), class_2378.field_11146.method_10221(limeFlower));
		r.accept(new class_1747(pinkFlower, props), class_2378.field_11146.method_10221(pinkFlower));
		r.accept(new class_1747(grayFlower, props), class_2378.field_11146.method_10221(grayFlower));
		r.accept(new class_1747(lightGrayFlower, props), class_2378.field_11146.method_10221(lightGrayFlower));
		r.accept(new class_1747(cyanFlower, props), class_2378.field_11146.method_10221(cyanFlower));
		r.accept(new class_1747(purpleFlower, props), class_2378.field_11146.method_10221(purpleFlower));
		r.accept(new class_1747(blueFlower, props), class_2378.field_11146.method_10221(blueFlower));
		r.accept(new class_1747(brownFlower, props), class_2378.field_11146.method_10221(brownFlower));
		r.accept(new class_1747(greenFlower, props), class_2378.field_11146.method_10221(greenFlower));
		r.accept(new class_1747(redFlower, props), class_2378.field_11146.method_10221(redFlower));
		r.accept(new class_1747(blackFlower, props), class_2378.field_11146.method_10221(blackFlower));
		r.accept(new class_1747(whiteShinyFlower, props), class_2378.field_11146.method_10221(whiteShinyFlower));
		r.accept(new class_1747(orangeShinyFlower, props), class_2378.field_11146.method_10221(orangeShinyFlower));
		r.accept(new class_1747(magentaShinyFlower, props), class_2378.field_11146.method_10221(magentaShinyFlower));
		r.accept(new class_1747(lightBlueShinyFlower, props), class_2378.field_11146.method_10221(lightBlueShinyFlower));
		r.accept(new class_1747(yellowShinyFlower, props), class_2378.field_11146.method_10221(yellowShinyFlower));
		r.accept(new class_1747(limeShinyFlower, props), class_2378.field_11146.method_10221(limeShinyFlower));
		r.accept(new class_1747(pinkShinyFlower, props), class_2378.field_11146.method_10221(pinkShinyFlower));
		r.accept(new class_1747(grayShinyFlower, props), class_2378.field_11146.method_10221(grayShinyFlower));
		r.accept(new class_1747(lightGrayShinyFlower, props), class_2378.field_11146.method_10221(lightGrayShinyFlower));
		r.accept(new class_1747(cyanShinyFlower, props), class_2378.field_11146.method_10221(cyanShinyFlower));
		r.accept(new class_1747(purpleShinyFlower, props), class_2378.field_11146.method_10221(purpleShinyFlower));
		r.accept(new class_1747(blueShinyFlower, props), class_2378.field_11146.method_10221(blueShinyFlower));
		r.accept(new class_1747(brownShinyFlower, props), class_2378.field_11146.method_10221(brownShinyFlower));
		r.accept(new class_1747(greenShinyFlower, props), class_2378.field_11146.method_10221(greenShinyFlower));
		r.accept(new class_1747(redShinyFlower, props), class_2378.field_11146.method_10221(redShinyFlower));
		r.accept(new class_1747(blackShinyFlower, props), class_2378.field_11146.method_10221(blackShinyFlower));
		r.accept(new class_1747(whiteFloatingFlower, props), class_2378.field_11146.method_10221(whiteFloatingFlower));
		r.accept(new class_1747(orangeFloatingFlower, props), class_2378.field_11146.method_10221(orangeFloatingFlower));
		r.accept(new class_1747(magentaFloatingFlower, props), class_2378.field_11146.method_10221(magentaFloatingFlower));
		r.accept(new class_1747(lightBlueFloatingFlower, props), class_2378.field_11146.method_10221(lightBlueFloatingFlower));
		r.accept(new class_1747(yellowFloatingFlower, props), class_2378.field_11146.method_10221(yellowFloatingFlower));
		r.accept(new class_1747(limeFloatingFlower, props), class_2378.field_11146.method_10221(limeFloatingFlower));
		r.accept(new class_1747(pinkFloatingFlower, props), class_2378.field_11146.method_10221(pinkFloatingFlower));
		r.accept(new class_1747(grayFloatingFlower, props), class_2378.field_11146.method_10221(grayFloatingFlower));
		r.accept(new class_1747(lightGrayFloatingFlower, props), class_2378.field_11146.method_10221(lightGrayFloatingFlower));
		r.accept(new class_1747(cyanFloatingFlower, props), class_2378.field_11146.method_10221(cyanFloatingFlower));
		r.accept(new class_1747(purpleFloatingFlower, props), class_2378.field_11146.method_10221(purpleFloatingFlower));
		r.accept(new class_1747(blueFloatingFlower, props), class_2378.field_11146.method_10221(blueFloatingFlower));
		r.accept(new class_1747(brownFloatingFlower, props), class_2378.field_11146.method_10221(brownFloatingFlower));
		r.accept(new class_1747(greenFloatingFlower, props), class_2378.field_11146.method_10221(greenFloatingFlower));
		r.accept(new class_1747(redFloatingFlower, props), class_2378.field_11146.method_10221(redFloatingFlower));
		r.accept(new class_1747(blackFloatingFlower, props), class_2378.field_11146.method_10221(blackFloatingFlower));
		r.accept(new class_1747(petalBlockWhite, props), class_2378.field_11146.method_10221(petalBlockWhite));
		r.accept(new class_1747(petalBlockOrange, props), class_2378.field_11146.method_10221(petalBlockOrange));
		r.accept(new class_1747(petalBlockMagenta, props), class_2378.field_11146.method_10221(petalBlockMagenta));
		r.accept(new class_1747(petalBlockLightBlue, props), class_2378.field_11146.method_10221(petalBlockLightBlue));
		r.accept(new class_1747(petalBlockYellow, props), class_2378.field_11146.method_10221(petalBlockYellow));
		r.accept(new class_1747(petalBlockLime, props), class_2378.field_11146.method_10221(petalBlockLime));
		r.accept(new class_1747(petalBlockPink, props), class_2378.field_11146.method_10221(petalBlockPink));
		r.accept(new class_1747(petalBlockGray, props), class_2378.field_11146.method_10221(petalBlockGray));
		r.accept(new class_1747(petalBlockSilver, props), class_2378.field_11146.method_10221(petalBlockSilver));
		r.accept(new class_1747(petalBlockCyan, props), class_2378.field_11146.method_10221(petalBlockCyan));
		r.accept(new class_1747(petalBlockPurple, props), class_2378.field_11146.method_10221(petalBlockPurple));
		r.accept(new class_1747(petalBlockBlue, props), class_2378.field_11146.method_10221(petalBlockBlue));
		r.accept(new class_1747(petalBlockBrown, props), class_2378.field_11146.method_10221(petalBlockBrown));
		r.accept(new class_1747(petalBlockGreen, props), class_2378.field_11146.method_10221(petalBlockGreen));
		r.accept(new class_1747(petalBlockRed, props), class_2378.field_11146.method_10221(petalBlockRed));
		r.accept(new class_1747(petalBlockBlack, props), class_2378.field_11146.method_10221(petalBlockBlack));
		r.accept(new class_1747(whiteMushroom, props), class_2378.field_11146.method_10221(whiteMushroom));
		r.accept(new class_1747(orangeMushroom, props), class_2378.field_11146.method_10221(orangeMushroom));
		r.accept(new class_1747(magentaMushroom, props), class_2378.field_11146.method_10221(magentaMushroom));
		r.accept(new class_1747(lightBlueMushroom, props), class_2378.field_11146.method_10221(lightBlueMushroom));
		r.accept(new class_1747(yellowMushroom, props), class_2378.field_11146.method_10221(yellowMushroom));
		r.accept(new class_1747(limeMushroom, props), class_2378.field_11146.method_10221(limeMushroom));
		r.accept(new class_1747(pinkMushroom, props), class_2378.field_11146.method_10221(pinkMushroom));
		r.accept(new class_1747(grayMushroom, props), class_2378.field_11146.method_10221(grayMushroom));
		r.accept(new class_1747(lightGrayMushroom, props), class_2378.field_11146.method_10221(lightGrayMushroom));
		r.accept(new class_1747(cyanMushroom, props), class_2378.field_11146.method_10221(cyanMushroom));
		r.accept(new class_1747(purpleMushroom, props), class_2378.field_11146.method_10221(purpleMushroom));
		r.accept(new class_1747(blueMushroom, props), class_2378.field_11146.method_10221(blueMushroom));
		r.accept(new class_1747(brownMushroom, props), class_2378.field_11146.method_10221(brownMushroom));
		r.accept(new class_1747(greenMushroom, props), class_2378.field_11146.method_10221(greenMushroom));
		r.accept(new class_1747(redMushroom, props), class_2378.field_11146.method_10221(redMushroom));
		r.accept(new class_1747(blackMushroom, props), class_2378.field_11146.method_10221(blackMushroom));
		r.accept(new class_1747(doubleFlowerWhite, props), class_2378.field_11146.method_10221(doubleFlowerWhite));
		r.accept(new class_1747(doubleFlowerOrange, props), class_2378.field_11146.method_10221(doubleFlowerOrange));
		r.accept(new class_1747(doubleFlowerMagenta, props), class_2378.field_11146.method_10221(doubleFlowerMagenta));
		r.accept(new class_1747(doubleFlowerLightBlue, props), class_2378.field_11146.method_10221(doubleFlowerLightBlue));
		r.accept(new class_1747(doubleFlowerYellow, props), class_2378.field_11146.method_10221(doubleFlowerYellow));
		r.accept(new class_1747(doubleFlowerLime, props), class_2378.field_11146.method_10221(doubleFlowerLime));
		r.accept(new class_1747(doubleFlowerPink, props), class_2378.field_11146.method_10221(doubleFlowerPink));
		r.accept(new class_1747(doubleFlowerGray, props), class_2378.field_11146.method_10221(doubleFlowerGray));
		r.accept(new class_1747(doubleFlowerLightGray, props), class_2378.field_11146.method_10221(doubleFlowerLightGray));
		r.accept(new class_1747(doubleFlowerCyan, props), class_2378.field_11146.method_10221(doubleFlowerCyan));
		r.accept(new class_1747(doubleFlowerPurple, props), class_2378.field_11146.method_10221(doubleFlowerPurple));
		r.accept(new class_1747(doubleFlowerBlue, props), class_2378.field_11146.method_10221(doubleFlowerBlue));
		r.accept(new class_1747(doubleFlowerBrown, props), class_2378.field_11146.method_10221(doubleFlowerBrown));
		r.accept(new class_1747(doubleFlowerGreen, props), class_2378.field_11146.method_10221(doubleFlowerGreen));
		r.accept(new class_1747(doubleFlowerRed, props), class_2378.field_11146.method_10221(doubleFlowerRed));
		r.accept(new class_1747(doubleFlowerBlack, props), class_2378.field_11146.method_10221(doubleFlowerBlack));
		r.accept(new class_1747(defaultAltar, props), class_2378.field_11146.method_10221(defaultAltar));
		r.accept(new class_1747(forestAltar, props), class_2378.field_11146.method_10221(forestAltar));
		r.accept(new class_1747(plainsAltar, props), class_2378.field_11146.method_10221(plainsAltar));
		r.accept(new class_1747(mountainAltar, props), class_2378.field_11146.method_10221(mountainAltar));
		r.accept(new class_1747(fungalAltar, props), class_2378.field_11146.method_10221(fungalAltar));
		r.accept(new class_1747(swampAltar, props), class_2378.field_11146.method_10221(swampAltar));
		r.accept(new class_1747(desertAltar, props), class_2378.field_11146.method_10221(desertAltar));
		r.accept(new class_1747(taigaAltar, props), class_2378.field_11146.method_10221(taigaAltar));
		r.accept(new class_1747(mesaAltar, props), class_2378.field_11146.method_10221(mesaAltar));
		r.accept(new class_1747(mossyAltar, props), class_2378.field_11146.method_10221(mossyAltar));
		r.accept(new class_1747(livingrockAltar, props), class_2378.field_11146.method_10221(livingrockAltar));
		r.accept(new class_1747(deepslateAltar, props), class_2378.field_11146.method_10221(deepslateAltar));
		r.accept(new class_1747(livingrock, props), class_2378.field_11146.method_10221(livingrock));
		r.accept(new class_1747(livingrockPolished, props), class_2378.field_11146.method_10221(livingrockPolished));
		r.accept(new class_1747(livingrockBrick, props), class_2378.field_11146.method_10221(livingrockBrick));
		r.accept(new class_1747(livingrockBrickChiseled, props), class_2378.field_11146.method_10221(livingrockBrickChiseled));
		r.accept(new class_1747(livingrockBrickCracked, props), class_2378.field_11146.method_10221(livingrockBrickCracked));
		r.accept(new class_1747(livingrockBrickMossy, props), class_2378.field_11146.method_10221(livingrockBrickMossy));
		r.accept(new class_1747(livingwoodLog, props), class_2378.field_11146.method_10221(livingwoodLog));
		r.accept(new class_1747(livingwoodLogStripped, props), class_2378.field_11146.method_10221(livingwoodLogStripped));
		r.accept(new class_1747(livingwoodLogGlimmering, props), class_2378.field_11146.method_10221(livingwoodLogGlimmering));
		r.accept(new class_1747(livingwoodLogStrippedGlimmering, props), class_2378.field_11146.method_10221(livingwoodLogStrippedGlimmering));
		r.accept(new class_1747(livingwood, props), class_2378.field_11146.method_10221(livingwood));
		r.accept(new class_1747(livingwoodStripped, props), class_2378.field_11146.method_10221(livingwoodStripped));
		r.accept(new class_1747(livingwoodStrippedGlimmering, props), class_2378.field_11146.method_10221(livingwoodStrippedGlimmering));
		r.accept(new class_1747(livingwoodPlanks, props), class_2378.field_11146.method_10221(livingwoodPlanks));
		r.accept(new class_1747(livingwoodPlanksMossy, props), class_2378.field_11146.method_10221(livingwoodPlanksMossy));
		r.accept(new class_1747(livingwoodFramed, props), class_2378.field_11146.method_10221(livingwoodFramed));
		r.accept(new class_1747(livingwoodPatternFramed, props), class_2378.field_11146.method_10221(livingwoodPatternFramed));
		r.accept(new class_1747(livingwoodGlimmering, props), class_2378.field_11146.method_10221(livingwoodGlimmering));
		r.accept(new class_1747(dreamwoodLog, props), class_2378.field_11146.method_10221(dreamwoodLog));
		r.accept(new class_1747(dreamwoodLogGlimmering, props), class_2378.field_11146.method_10221(dreamwoodLogGlimmering));
		r.accept(new class_1747(dreamwoodLogStripped, props), class_2378.field_11146.method_10221(dreamwoodLogStripped));
		r.accept(new class_1747(dreamwoodLogStrippedGlimmering, props), class_2378.field_11146.method_10221(dreamwoodLogStrippedGlimmering));
		r.accept(new class_1747(dreamwood, props), class_2378.field_11146.method_10221(dreamwood));
		r.accept(new class_1747(dreamwoodStripped, props), class_2378.field_11146.method_10221(dreamwoodStripped));
		r.accept(new class_1747(dreamwoodStrippedGlimmering, props), class_2378.field_11146.method_10221(dreamwoodStrippedGlimmering));
		r.accept(new class_1747(dreamwoodPlanks, props), class_2378.field_11146.method_10221(dreamwoodPlanks));
		r.accept(new class_1747(dreamwoodPlanksMossy, props), class_2378.field_11146.method_10221(dreamwoodPlanksMossy));
		r.accept(new class_1747(dreamwoodFramed, props), class_2378.field_11146.method_10221(dreamwoodFramed));
		r.accept(new class_1747(dreamwoodPatternFramed, props), class_2378.field_11146.method_10221(dreamwoodPatternFramed));
		r.accept(new class_1747(dreamwoodGlimmering, props), class_2378.field_11146.method_10221(dreamwoodGlimmering));
		r.accept(new class_1747(manaSpreader, props), class_2378.field_11146.method_10221(manaSpreader));
		r.accept(new class_1747(redstoneSpreader, props), class_2378.field_11146.method_10221(redstoneSpreader));
		r.accept(new class_1747(elvenSpreader, props), class_2378.field_11146.method_10221(elvenSpreader));
		r.accept(new class_1747(gaiaSpreader, props), class_2378.field_11146.method_10221(gaiaSpreader));
		r.accept(new class_1747(manaPool, props), class_2378.field_11146.method_10221(manaPool));
		r.accept(new class_1747(creativePool, BotaniaItems.defaultBuilder().method_7894(class_1814.field_8904)), class_2378.field_11146.method_10221(creativePool));
		r.accept(new class_1747(dilutedPool, props), class_2378.field_11146.method_10221(dilutedPool));
		r.accept(new class_1747(fabulousPool, props), class_2378.field_11146.method_10221(fabulousPool));
		r.accept(new class_1747(alchemyCatalyst, props), class_2378.field_11146.method_10221(alchemyCatalyst));
		r.accept(new class_1747(conjurationCatalyst, props), class_2378.field_11146.method_10221(conjurationCatalyst));
		r.accept(new class_1747(manasteelBlock, props), class_2378.field_11146.method_10221(manasteelBlock));
		r.accept(new class_1747(terrasteelBlock, BotaniaItems.defaultBuilder().method_7894(class_1814.field_8907)), class_2378.field_11146.method_10221(terrasteelBlock));
		r.accept(new class_1747(elementiumBlock, props), class_2378.field_11146.method_10221(elementiumBlock));
		r.accept(new class_1747(manaDiamondBlock, props), class_2378.field_11146.method_10221(manaDiamondBlock));
		r.accept(new class_1747(dragonstoneBlock, props), class_2378.field_11146.method_10221(dragonstoneBlock));
		r.accept(new class_1747(manaGlass, props), class_2378.field_11146.method_10221(manaGlass));
		r.accept(new class_1747(elfGlass, props), class_2378.field_11146.method_10221(elfGlass));
		r.accept(new class_1747(bifrostPerm, props), class_2378.field_11146.method_10221(bifrostPerm));
		r.accept(new class_1747(runeAltar, props), class_2378.field_11146.method_10221(runeAltar));
		r.accept(new class_1747(enchanter, props), class_2378.field_11146.method_10221(enchanter));
		r.accept(new BlockItemWithSpecialRenderer(brewery, props), class_2378.field_11146.method_10221(brewery));
		r.accept(new class_1747(terraPlate, props), class_2378.field_11146.method_10221(terraPlate));
		r.accept(new class_1747(alfPortal, BotaniaItems.defaultBuilder().method_7894(class_1814.field_8907)), class_2378.field_11146.method_10221(alfPortal));

		r.accept(new BlockItemWithSpecialRenderer(manaPylon, props), class_2378.field_11146.method_10221(manaPylon));
		r.accept(new BlockItemWithSpecialRenderer(naturaPylon, props), class_2378.field_11146.method_10221(naturaPylon));
		r.accept(new BlockItemWithSpecialRenderer(gaiaPylon, props), class_2378.field_11146.method_10221(gaiaPylon));
		r.accept(new class_1747(distributor, props), class_2378.field_11146.method_10221(distributor));
		r.accept(new class_1747(manaVoid, props), class_2378.field_11146.method_10221(manaVoid));
		r.accept(new class_1747(manaDetector, props), class_2378.field_11146.method_10221(manaDetector));
		r.accept(new class_1747(pistonRelay, props), class_2378.field_11146.method_10221(pistonRelay));
		r.accept(new class_1747(turntable, props), class_2378.field_11146.method_10221(turntable));
		r.accept(new class_1747(tinyPlanet, props), class_2378.field_11146.method_10221(tinyPlanet));
		r.accept(new class_1747(wildDrum, props), class_2378.field_11146.method_10221(wildDrum));
		r.accept(new class_1747(gatheringDrum, props), class_2378.field_11146.method_10221(gatheringDrum));
		r.accept(new class_1747(canopyDrum, props), class_2378.field_11146.method_10221(canopyDrum));
		r.accept(new class_1747(spawnerClaw, props), class_2378.field_11146.method_10221(spawnerClaw));
		r.accept(new class_1747(rfGenerator, props), class_2378.field_11146.method_10221(rfGenerator));
		r.accept(new class_1747(prism, props), class_2378.field_11146.method_10221(prism));
		r.accept(new class_1747(pump, props), class_2378.field_11146.method_10221(pump));
		r.accept(new class_1747(sparkChanger, props), class_2378.field_11146.method_10221(sparkChanger));
		r.accept(new class_1747(manaBomb, props), class_2378.field_11146.method_10221(manaBomb));
		r.accept(new BlockItemWithSpecialRenderer(bellows, props), class_2378.field_11146.method_10221(bellows));
		r.accept(new class_1747(openCrate, props), class_2378.field_11146.method_10221(openCrate));
		r.accept(new class_1747(craftCrate, props), class_2378.field_11146.method_10221(craftCrate));
		r.accept(new class_1747(forestEye, props), class_2378.field_11146.method_10221(forestEye));
		r.accept(new class_1747(abstrusePlatform, props), class_2378.field_11146.method_10221(abstrusePlatform));
		r.accept(new class_1747(spectralPlatform, props), class_2378.field_11146.method_10221(spectralPlatform));
		r.accept(new class_1747(infrangiblePlatform, BotaniaItems.defaultBuilder().method_7894(class_1814.field_8904)), class_2378.field_11146.method_10221(infrangiblePlatform));
		r.accept(new TinyPotatoBlockItem(tinyPotato, BotaniaItems.defaultBuilder().method_7894(class_1814.field_8907)), class_2378.field_11146.method_10221(tinyPotato));
		r.accept(new class_1747(enderEye, props), class_2378.field_11146.method_10221(enderEye));
		r.accept(new class_1747(redStringContainer, props), class_2378.field_11146.method_10221(redStringContainer));
		r.accept(new class_1747(redStringDispenser, props), class_2378.field_11146.method_10221(redStringDispenser));
		r.accept(new class_1747(redStringFertilizer, props), class_2378.field_11146.method_10221(redStringFertilizer));
		r.accept(new class_1747(redStringComparator, props), class_2378.field_11146.method_10221(redStringComparator));
		r.accept(new class_1747(redStringRelay, props), class_2378.field_11146.method_10221(redStringRelay));
		r.accept(new class_1747(redStringInterceptor, props), class_2378.field_11146.method_10221(redStringInterceptor));
		r.accept(new BlockItemWithSpecialRenderer(corporeaIndex, props), class_2378.field_11146.method_10221(corporeaIndex));
		r.accept(new class_1747(corporeaFunnel, props), class_2378.field_11146.method_10221(corporeaFunnel));
		r.accept(new class_1747(corporeaInterceptor, props), class_2378.field_11146.method_10221(corporeaInterceptor));
		r.accept(new class_1747(corporeaCrystalCube, props), class_2378.field_11146.method_10221(corporeaCrystalCube));
		r.accept(new class_1747(corporeaRetainer, props), class_2378.field_11146.method_10221(corporeaRetainer));
		r.accept(new class_1747(corporeaBlock, props), class_2378.field_11146.method_10221(corporeaBlock));
		r.accept(new class_1747(corporeaSlab, props), class_2378.field_11146.method_10221(corporeaSlab));
		r.accept(new class_1747(corporeaStairs, props), class_2378.field_11146.method_10221(corporeaStairs));
		r.accept(new class_1747(corporeaBrick, props), class_2378.field_11146.method_10221(corporeaBrick));
		r.accept(new class_1747(corporeaBrickSlab, props), class_2378.field_11146.method_10221(corporeaBrickSlab));
		r.accept(new class_1747(corporeaBrickStairs, props), class_2378.field_11146.method_10221(corporeaBrickStairs));
		r.accept(new class_1747(corporeaBrickWall, props), class_2378.field_11146.method_10221(corporeaBrickWall));
		r.accept(new class_1747(incensePlate, props), class_2378.field_11146.method_10221(incensePlate));
		r.accept(new BlockItemWithSpecialRenderer(hourglass, props), class_2378.field_11146.method_10221(hourglass));
		r.accept(new class_1747(ghostRail, props), class_2378.field_11146.method_10221(ghostRail));
		r.accept(new class_1747(lightRelayDefault, props), class_2378.field_11146.method_10221(lightRelayDefault));
		r.accept(new class_1747(lightRelayDetector, props), class_2378.field_11146.method_10221(lightRelayDetector));
		r.accept(new class_1747(lightRelayFork, props), class_2378.field_11146.method_10221(lightRelayFork));
		r.accept(new class_1747(lightRelayToggle, props), class_2378.field_11146.method_10221(lightRelayToggle));
		r.accept(new class_1747(lightLauncher, props), class_2378.field_11146.method_10221(lightLauncher));
		r.accept(new class_1747(cacophonium, props), class_2378.field_11146.method_10221(cacophonium));
		r.accept(new class_1747(cellBlock, props), class_2378.field_11146.method_10221(cellBlock));
		r.accept(new BlockItemWithSpecialRenderer(teruTeruBozu, props), class_2378.field_11146.method_10221(teruTeruBozu));
		r.accept(new BlockItemWithSpecialRenderer(avatar, props), class_2378.field_11146.method_10221(avatar));
		r.accept(new class_1747(root, props), class_2378.field_11146.method_10221(root));
		r.accept(new class_1747(felPumpkin, props), class_2378.field_11146.method_10221(felPumpkin));
		r.accept(new class_1747(cocoon, props), class_2378.field_11146.method_10221(cocoon));
		r.accept(new class_1747(enchantedSoil, BotaniaItems.defaultBuilder().method_7894(class_1814.field_8903)), class_2378.field_11146.method_10221(enchantedSoil));
		r.accept(new class_1747(animatedTorch, props), class_2378.field_11146.method_10221(animatedTorch));
		r.accept(new class_1747(starfield, props), class_2378.field_11146.method_10221(starfield));
		r.accept(new class_1747(azulejo0, props), class_2378.field_11146.method_10221(azulejo0));
		r.accept(new class_1747(azulejo1, props), class_2378.field_11146.method_10221(azulejo1));
		r.accept(new class_1747(azulejo2, props), class_2378.field_11146.method_10221(azulejo2));
		r.accept(new class_1747(azulejo3, props), class_2378.field_11146.method_10221(azulejo3));
		r.accept(new class_1747(azulejo4, props), class_2378.field_11146.method_10221(azulejo4));
		r.accept(new class_1747(azulejo5, props), class_2378.field_11146.method_10221(azulejo5));
		r.accept(new class_1747(azulejo6, props), class_2378.field_11146.method_10221(azulejo6));
		r.accept(new class_1747(azulejo7, props), class_2378.field_11146.method_10221(azulejo7));
		r.accept(new class_1747(azulejo8, props), class_2378.field_11146.method_10221(azulejo8));
		r.accept(new class_1747(azulejo9, props), class_2378.field_11146.method_10221(azulejo9));
		r.accept(new class_1747(azulejo10, props), class_2378.field_11146.method_10221(azulejo10));
		r.accept(new class_1747(azulejo11, props), class_2378.field_11146.method_10221(azulejo11));
		r.accept(new class_1747(azulejo12, props), class_2378.field_11146.method_10221(azulejo12));
		r.accept(new class_1747(azulejo13, props), class_2378.field_11146.method_10221(azulejo13));
		r.accept(new class_1747(azulejo14, props), class_2378.field_11146.method_10221(azulejo14));
		r.accept(new class_1747(azulejo15, props), class_2378.field_11146.method_10221(azulejo15));
		r.accept(new BlazeItemBlock(blazeBlock, props), class_2378.field_11146.method_10221(blazeBlock));
		r.accept(new class_1827(gaiaHead, gaiaHeadWall, BotaniaItems.defaultBuilder().method_7894(class_1814.field_8907)), class_2378.field_11146.method_10221(gaiaHead));
		r.accept(new class_1747(shimmerrock, props), class_2378.field_11146.method_10221(shimmerrock));
		r.accept(new class_1747(shimmerwoodPlanks, props), class_2378.field_11146.method_10221(shimmerwoodPlanks));
		r.accept(new class_1747(dryGrass, props), class_2378.field_11146.method_10221(dryGrass));
		r.accept(new class_1747(goldenGrass, props), class_2378.field_11146.method_10221(goldenGrass));
		r.accept(new class_1747(vividGrass, props), class_2378.field_11146.method_10221(vividGrass));
		r.accept(new class_1747(scorchedGrass, props), class_2378.field_11146.method_10221(scorchedGrass));
		r.accept(new class_1747(infusedGrass, props), class_2378.field_11146.method_10221(infusedGrass));
		r.accept(new class_1747(mutatedGrass, props), class_2378.field_11146.method_10221(mutatedGrass));
		r.accept(new class_1747(motifDaybloom, props), class_2378.field_11146.method_10221(motifDaybloom));
		r.accept(new class_1747(motifNightshade, props), class_2378.field_11146.method_10221(motifNightshade));
		r.accept(new class_1747(motifHydroangeas, props), class_2378.field_11146.method_10221(motifHydroangeas));
	}

	public static void addDispenserBehaviours() {
		class_2315.method_10009(BotaniaItems.twigWand, new WandBehavior());
		class_2315.method_10009(BotaniaItems.dreamwoodWand, new WandBehavior());
		class_2315.method_10009(BotaniaItems.obedienceStick, new StickBehavior());
		class_2315.method_10009(BotaniaItems.poolMinecart, new ManaPoolMinecartBehavior());
		class_2315.method_10009(BotaniaBlocks.felPumpkin, new FelPumpkinBehavior());
		class_2315.method_10009(BotaniaItems.spark, new ManaSparkBehavior());
		class_2315.method_10009(BotaniaBlocks.gaiaHead, new class_2969() {
			@NotNull
			@Override
			protected class_1799 method_10135(@NotNull class_2342 source, @NotNull class_1799 stack) {
				method_27955(class_1738.method_7684(source, stack));
				return stack;
			}
		});

		class_2357 behavior = new CorporeaSparkBehavior();
		class_2315.method_10009(BotaniaItems.corporeaSpark, behavior);
		class_2315.method_10009(BotaniaItems.corporeaSparkMaster, behavior);
		class_2315.method_10009(BotaniaItems.corporeaSparkCreative, behavior);
		class_2315.method_10009(BotaniaItems.enderAirBottle, new class_2965() {
			@NotNull
			@Override
			protected class_1676 method_12844(@NotNull class_1937 world, @NotNull class_2374 pos, @NotNull class_1799 stack) {
				return new EnderAirBottleEntity(pos.method_10216(), pos.method_10214(), pos.method_10215(), world);
			}
		});

		behavior = DispenserBlockAccessor.getDispenserRegistry().get(class_1802.field_8469);
		class_2315.method_10009(class_1802.field_8469, new EnderAirBottlingBehavior(behavior));

		class_2315.method_10009(BotaniaItems.manasteelShears, new class_5168());
		class_2315.method_10009(BotaniaItems.elementiumShears, new class_5168());
		class_2315.method_10009(BotaniaItems.vineBall, new class_2965() {
			@NotNull
			@Override
			protected class_1676 method_12844(@NotNull class_1937 world, @NotNull class_2374 pos, @NotNull class_1799 stack) {
				return new VineBallEntity(pos.method_10216(), pos.method_10214(), pos.method_10215(), world);
			}
		});

		SeedBehaviors.init();
	}

	public static void addAxeStripping() {
		XplatAbstractions xplat = XplatAbstractions.INSTANCE;
		xplat.addAxeStripping(livingwoodLog, livingwoodLogStripped);
		xplat.addAxeStripping(livingwoodLogGlimmering, livingwoodLogStrippedGlimmering);
		xplat.addAxeStripping(livingwood, livingwoodStripped);
		xplat.addAxeStripping(livingwoodGlimmering, livingwoodStrippedGlimmering);
		xplat.addAxeStripping(dreamwoodLog, dreamwoodLogStripped);
		xplat.addAxeStripping(dreamwoodLogGlimmering, dreamwoodLogStrippedGlimmering);
		xplat.addAxeStripping(dreamwood, dreamwoodStripped);
		xplat.addAxeStripping(dreamwoodGlimmering, dreamwoodStrippedGlimmering);

		xplat.addAxeStripping(BotaniaFluffBlocks.livingwoodStairs, BotaniaFluffBlocks.livingwoodStrippedStairs);
		xplat.addAxeStripping(BotaniaFluffBlocks.livingwoodSlab, BotaniaFluffBlocks.livingwoodStrippedSlab);
		xplat.addAxeStripping(BotaniaFluffBlocks.livingwoodWall, BotaniaFluffBlocks.livingwoodStrippedWall);
		xplat.addAxeStripping(BotaniaFluffBlocks.dreamwoodStairs, BotaniaFluffBlocks.dreamwoodStrippedStairs);
		xplat.addAxeStripping(BotaniaFluffBlocks.dreamwoodSlab, BotaniaFluffBlocks.dreamwoodStrippedSlab);
		xplat.addAxeStripping(BotaniaFluffBlocks.dreamwoodWall, BotaniaFluffBlocks.dreamwoodStrippedWall);
	}

	public static class_2248 getFlower(class_1767 color) {
		return switch (color) {
			case field_7952 -> whiteFlower;
			case field_7946 -> orangeFlower;
			case field_7958 -> magentaFlower;
			case field_7951 -> lightBlueFlower;
			case field_7947 -> yellowFlower;
			case field_7961 -> limeFlower;
			case field_7954 -> pinkFlower;
			case field_7944 -> grayFlower;
			case field_7967 -> lightGrayFlower;
			case field_7955 -> cyanFlower;
			case field_7945 -> purpleFlower;
			case field_7966 -> blueFlower;
			case field_7957 -> brownFlower;
			case field_7942 -> greenFlower;
			case field_7964 -> redFlower;
			case field_7963 -> blackFlower;
		};
	}

	public static class_2248 getMushroom(class_1767 color) {
		return switch (color) {
			case field_7952 -> whiteMushroom;
			case field_7946 -> orangeMushroom;
			case field_7958 -> magentaMushroom;
			case field_7951 -> lightBlueMushroom;
			case field_7947 -> yellowMushroom;
			case field_7961 -> limeMushroom;
			case field_7954 -> pinkMushroom;
			case field_7944 -> grayMushroom;
			case field_7967 -> lightGrayMushroom;
			case field_7955 -> cyanMushroom;
			case field_7945 -> purpleMushroom;
			case field_7966 -> blueMushroom;
			case field_7957 -> brownMushroom;
			case field_7942 -> greenMushroom;
			case field_7964 -> redMushroom;
			case field_7963 -> blackMushroom;
		};
	}

	public static class_2248 getBuriedPetal(class_1767 color) {
		return switch (color) {
			case field_7952 -> whiteBuriedPetals;
			case field_7946 -> orangeBuriedPetals;
			case field_7958 -> magentaBuriedPetals;
			case field_7951 -> lightBlueBuriedPetals;
			case field_7947 -> yellowBuriedPetals;
			case field_7961 -> limeBuriedPetals;
			case field_7954 -> pinkBuriedPetals;
			case field_7944 -> grayBuriedPetals;
			case field_7967 -> lightGrayBuriedPetals;
			case field_7955 -> cyanBuriedPetals;
			case field_7945 -> purpleBuriedPetals;
			case field_7966 -> blueBuriedPetals;
			case field_7957 -> brownBuriedPetals;
			case field_7942 -> greenBuriedPetals;
			case field_7964 -> redBuriedPetals;
			case field_7963 -> blackBuriedPetals;
		};
	}

	public static class_2248 getShinyFlower(class_1767 color) {
		return switch (color) {
			case field_7952 -> whiteShinyFlower;
			case field_7946 -> orangeShinyFlower;
			case field_7958 -> magentaShinyFlower;
			case field_7951 -> lightBlueShinyFlower;
			case field_7947 -> yellowShinyFlower;
			case field_7961 -> limeShinyFlower;
			case field_7954 -> pinkShinyFlower;
			case field_7944 -> grayShinyFlower;
			case field_7967 -> lightGrayShinyFlower;
			case field_7955 -> cyanShinyFlower;
			case field_7945 -> purpleShinyFlower;
			case field_7966 -> blueShinyFlower;
			case field_7957 -> brownShinyFlower;
			case field_7942 -> greenShinyFlower;
			case field_7964 -> redShinyFlower;
			case field_7963 -> blackShinyFlower;
		};
	}

	public static class_2248 getFloatingFlower(class_1767 color) {
		return switch (color) {
			case field_7952 -> whiteFloatingFlower;
			case field_7946 -> orangeFloatingFlower;
			case field_7958 -> magentaFloatingFlower;
			case field_7951 -> lightBlueFloatingFlower;
			case field_7947 -> yellowFloatingFlower;
			case field_7961 -> limeFloatingFlower;
			case field_7954 -> pinkFloatingFlower;
			case field_7944 -> grayFloatingFlower;
			case field_7967 -> lightGrayFloatingFlower;
			case field_7955 -> cyanFloatingFlower;
			case field_7945 -> purpleFloatingFlower;
			case field_7966 -> blueFloatingFlower;
			case field_7957 -> brownFloatingFlower;
			case field_7942 -> greenFloatingFlower;
			case field_7964 -> redFloatingFlower;
			case field_7963 -> blackFloatingFlower;
		};
	}

	public static class_2248 getDoubleFlower(class_1767 color) {
		return switch (color) {
			case field_7952 -> doubleFlowerWhite;
			case field_7946 -> doubleFlowerOrange;
			case field_7958 -> doubleFlowerMagenta;
			case field_7951 -> doubleFlowerLightBlue;
			case field_7947 -> doubleFlowerYellow;
			case field_7961 -> doubleFlowerLime;
			case field_7954 -> doubleFlowerPink;
			case field_7944 -> doubleFlowerGray;
			case field_7967 -> doubleFlowerLightGray;
			case field_7955 -> doubleFlowerCyan;
			case field_7945 -> doubleFlowerPurple;
			case field_7966 -> doubleFlowerBlue;
			case field_7957 -> doubleFlowerBrown;
			case field_7942 -> doubleFlowerGreen;
			case field_7964 -> doubleFlowerRed;
			case field_7963 -> doubleFlowerBlack;
		};
	}

	public static class_2248 getPetalBlock(class_1767 color) {
		return switch (color) {
			case field_7952 -> petalBlockWhite;
			case field_7946 -> petalBlockOrange;
			case field_7958 -> petalBlockMagenta;
			case field_7951 -> petalBlockLightBlue;
			case field_7947 -> petalBlockYellow;
			case field_7961 -> petalBlockLime;
			case field_7954 -> petalBlockPink;
			case field_7944 -> petalBlockGray;
			case field_7967 -> petalBlockSilver;
			case field_7955 -> petalBlockCyan;
			case field_7945 -> petalBlockPurple;
			case field_7966 -> petalBlockBlue;
			case field_7957 -> petalBlockBrown;
			case field_7942 -> petalBlockGreen;
			case field_7964 -> petalBlockRed;
			case field_7963 -> petalBlockBlack;
		};
	}
}
