/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import vazkii.botania.common.lib.LibMisc;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2582;
import net.minecraft.class_2960;

public final class BotaniaBannerPatterns {
	private static final List<class_2582> ALL = new ArrayList<>();
	public static final class_2582 FLOWER = make(LibMisc.MOD_ID + ":flower");
	public static final class_2582 LEXICON = make(LibMisc.MOD_ID + ":lexicon");
	public static final class_2582 LOGO = make(LibMisc.MOD_ID + ":logo");
	public static final class_2582 SAPLING = make(LibMisc.MOD_ID + ":sapling");
	public static final class_2582 TINY_POTATO = make(LibMisc.MOD_ID + ":tiny_potato");
	public static final class_2582 SPARK_DISPERSIVE = make(LibMisc.MOD_ID + ":spark_dispersive");
	public static final class_2582 SPARK_DOMINANT = make(LibMisc.MOD_ID + ":spark_dominant");
	public static final class_2582 SPARK_RECESSIVE = make(LibMisc.MOD_ID + ":spark_recessive");
	public static final class_2582 SPARK_ISOLATED = make(LibMisc.MOD_ID + ":spark_isolated");

	public static final class_2582 FISH = make(LibMisc.MOD_ID + ":fish");
	public static final class_2582 AXE = make(LibMisc.MOD_ID + ":axe");
	public static final class_2582 HOE = make(LibMisc.MOD_ID + ":hoe");
	public static final class_2582 PICKAXE = make(LibMisc.MOD_ID + ":pickaxe");
	public static final class_2582 SHOVEL = make(LibMisc.MOD_ID + ":shovel");
	public static final class_2582 SWORD = make(LibMisc.MOD_ID + ":sword");

	private static class_2582 make(String hashName) {
		var pattern = new class_2582(hashName);
		ALL.add(pattern);
		return pattern;
	}

	public static void submitRegistrations(BiConsumer<class_2582, class_2960> consumer) {
		for (var pattern : ALL) {
			consumer.accept(pattern, new class_2960(pattern.method_10945()));
		}
	}
}
