/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonObject;

import net.minecraft.advancements.critereon.*;
import net.minecraft.class_1799;
import net.minecraft.class_195;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5267;
import org.jetbrains.annotations.NotNull;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class RelicBindTrigger extends class_4558<RelicBindTrigger.Instance> {
	public static final class_2960 ID = prefix("relic_bind");
	public static final RelicBindTrigger INSTANCE = new RelicBindTrigger();

	private RelicBindTrigger() {}

	@NotNull
	@Override
	public class_2960 method_794() {
		return ID;
	}

	@NotNull
	@Override
	public Instance method_27854(@NotNull JsonObject json, @NotNull class_2048.class_5258 playerPred, class_5257 conditions) {
		return new Instance(playerPred, class_2073.method_8969(json.get("relic")));
	}

	public void trigger(class_3222 player, class_1799 relic) {
		method_22510(player, instance -> instance.test(relic));
	}

	public static class Instance extends class_195 {
		private final class_2073 predicate;

		public Instance(class_2048.class_5258 playerPred, class_2073 predicate) {
			super(ID, playerPred);
			this.predicate = predicate;
		}

		@NotNull
		@Override
		public class_2960 method_806() {
			return ID;
		}

		boolean test(class_1799 stack) {
			return predicate.method_8970(stack);
		}

		@Override
		public JsonObject method_807(class_5267 context) {
			JsonObject json = super.method_807(context);
			if (predicate != class_2073.field_9640) {
				json.add("relic", predicate.method_8971());
			}
			return json;
		}

		public class_2073 getPredicate() {
			return this.predicate;
		}
	}
}
