/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonObject;

import net.minecraft.advancements.critereon.*;
import net.minecraft.class_1799;
import net.minecraft.class_195;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5267;
import org.jetbrains.annotations.NotNull;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class LokiPlaceTrigger extends class_4558<LokiPlaceTrigger.Instance> {
	public static final class_2960 ID = prefix("loki_placed_blocks");
	public static final LokiPlaceTrigger INSTANCE = new LokiPlaceTrigger();

	private LokiPlaceTrigger() {}

	@NotNull
	@Override
	public class_2960 method_794() {
		return ID;
	}

	@NotNull
	@Override
	public LokiPlaceTrigger.Instance method_27854(@NotNull JsonObject json, class_2048.class_5258 playerPred, class_5257 conditions) {
		return new LokiPlaceTrigger.Instance(playerPred, class_2048.method_8913(json.get("player")),
				class_2073.method_8969(json.get("ring")), class_2096.class_2100.method_9056(json.get("blocks_placed")));
	}

	public void trigger(class_3222 player, class_1799 ring, int blocksPlaced) {
		method_22510(player, instance -> instance.test(player, ring, blocksPlaced));
	}

	public static class Instance extends class_195 {
		private final class_2048 player;
		private final class_2073 ring;
		private final class_2096.class_2100 blocksPlaced;

		public Instance(class_2048.class_5258 playerPred, class_2048 player, class_2073 ring, class_2096.class_2100 blocksPlaced) {
			super(ID, playerPred);
			this.player = player;
			this.ring = ring;
			this.blocksPlaced = blocksPlaced;
		}

		@NotNull
		@Override
		public class_2960 method_806() {
			return ID;
		}

		boolean test(class_3222 player, class_1799 ring, int blocksPlaced) {
			return this.player.method_8914(player, null) && this.ring.method_8970(ring) && this.blocksPlaced.method_9054(blocksPlaced);
		}

		@Override
		public JsonObject method_807(class_5267 context) {
			JsonObject json = super.method_807(context);
			if (ring != class_2073.field_9640) {
				json.add("ring", ring.method_8971());
			}
			if (blocksPlaced != class_2096.class_2100.field_9708) {
				json.add("blocks_placed", blocksPlaced.method_9036());
			}
			return json;
		}

		public class_2048 getPlayer() {
			return this.player;
		}

		public class_2073 getRing() {
			return this.ring;
		}

		public class_2096.class_2100 getBlocksPlaced() {
			return this.blocksPlaced;
		}
	}
}
