/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonObject;

import net.minecraft.advancements.critereon.*;
import net.minecraft.class_1282;
import net.minecraft.class_195;
import net.minecraft.class_2022;
import net.minecraft.class_2048;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5267;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.entity.GaiaGuardianEntity;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class GaiaGuardianNoArmorTrigger extends class_4558<GaiaGuardianNoArmorTrigger.Instance> {
	public static final class_2960 ID = prefix("gaia_guardian_no_armor");
	public static final GaiaGuardianNoArmorTrigger INSTANCE = new GaiaGuardianNoArmorTrigger();

	private GaiaGuardianNoArmorTrigger() {}

	@NotNull
	@Override
	public class_2960 method_794() {
		return ID;
	}

	@NotNull
	@Override
	public GaiaGuardianNoArmorTrigger.Instance method_27854(@NotNull JsonObject json, class_2048.class_5258 playerPred, class_5257 conditions) {
		return new GaiaGuardianNoArmorTrigger.Instance(playerPred,
				class_2048.method_8913(json.get("guardian")),
				class_2022.method_8846(json.get("killing_blow"))
		);
	}

	public void trigger(class_3222 player, GaiaGuardianEntity guardian, class_1282 src) {
		method_22510(player, instance -> instance.test(player, guardian, src));
	}

	public static class Instance extends class_195 {
		private final class_2048 guardian;
		private final class_2022 killingBlow;

		public Instance(class_2048.class_5258 playerPred, class_2048 count, class_2022 indexPos) {
			super(ID, playerPred);
			this.guardian = count;
			this.killingBlow = indexPos;
		}

		@NotNull
		@Override
		public class_2960 method_806() {
			return ID;
		}

		boolean test(class_3222 player, GaiaGuardianEntity guardian, class_1282 src) {
			return this.guardian.method_8914(player, guardian) && this.killingBlow.method_8847(player, src);
		}

		@Override
		public JsonObject method_807(class_5267 context) {
			JsonObject json = super.method_807(context);
			if (guardian != class_2048.field_9599) {
				json.add("guardian", guardian.method_8912());
			}
			if (killingBlow != class_2022.field_9533) {
				json.add("killing_blow", killingBlow.method_8848());
			}
			return json;
		}

		public class_2048 getGuardian() {
			return this.guardian;
		}

		public class_2022 getKillingBlow() {
			return this.killingBlow;
		}
	}
}
