/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonObject;

import net.minecraft.advancements.critereon.*;
import net.minecraft.class_1799;
import net.minecraft.class_195;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5267;
import org.jetbrains.annotations.NotNull;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class AlfheimPortalTrigger extends class_4558<AlfheimPortalTrigger.Instance> {
	public static final class_2960 ID = prefix("open_elf_portal");
	public static final AlfheimPortalTrigger INSTANCE = new AlfheimPortalTrigger();

	private AlfheimPortalTrigger() {}

	@NotNull
	@Override
	public class_2960 method_794() {
		return ID;
	}

	@NotNull
	@Override
	public Instance method_27854(@NotNull JsonObject json, class_2048.class_5258 playerPred, class_5257 conditions) {
		return new Instance(playerPred, class_2073.method_8969(json.get("wand")), class_2090.method_9021(json.get("location")));
	}

	public void trigger(class_3222 player, class_3218 world, class_2338 pos, class_1799 wand) {
		method_22510(player, instance -> instance.test(world, pos, wand));
	}

	public static class Instance extends class_195 {
		private final class_2073 wand;
		private final class_2090 pos;

		public Instance(class_2048.class_5258 playerPred, class_2073 predicate, class_2090 pos) {
			super(ID, playerPred);
			this.wand = predicate;
			this.pos = pos;
		}

		@NotNull
		@Override
		public class_2960 method_806() {
			return ID;
		}

		boolean test(class_3218 world, class_2338 pos, class_1799 wand) {
			return this.wand.method_8970(wand) && this.pos.method_9018(world, pos.method_10263(), pos.method_10264(), pos.method_10260());
		}

		@Override
		public JsonObject method_807(class_5267 context) {
			JsonObject json = super.method_807(context);
			if (wand != class_2073.field_9640) {
				json.add("wand", wand.method_8971());
			}
			if (pos != class_2090.field_9685) {
				json.add("location", pos.method_9019());
			}
			return json;
		}

		public class_2073 getWand() {
			return this.wand;
		}

		public class_2090 getPos() {
			return this.pos;
		}
	}
}
