/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.entity;

import net.minecraft.class_1723;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.render.block_entity.SpecialFlowerBlockEntityRenderer;
import vazkii.botania.common.entity.MagicLandmineEntity;

public class MagicLandmineRenderer extends class_897<MagicLandmineEntity> {
	private static final double INITIAL_OFFSET = -1.0 / 16 + 0.005;
	// Global y offset so that overlapping landmines do not Z-fight
	public static double offY = INITIAL_OFFSET;

	public MagicLandmineRenderer(class_5617.class_5618 ctx) {
		super(ctx);
	}

	public static void onWorldRenderLast() {
		offY = INITIAL_OFFSET;
	}

	@Override
	public void render(MagicLandmineEntity e, float entityYaw, float partialTicks, class_4587 ms, class_4597 buffers, int light) {
		super.method_3936(e, entityYaw, partialTicks, ms, buffers, light);

		ms.method_22903();
		class_238 aabb = e.method_5829().method_997(e.method_19538().method_1021(-1));

		float gs = (float) (Math.sin(ClientTickHandler.total() / 20) + 1) * 0.2F + 0.6F;
		int r = (int) (105 * gs);
		int g = (int) (25 * gs);
		int b = (int) (145 * gs);
		int color = r << 16 | g << 8 | b;

		int alpha = 32;
		if (e.field_6012 < 8) {
			alpha *= Math.min((e.field_6012 + partialTicks) / 8F, 1F);
		} else if (e.field_6012 > 47) {
			alpha *= Math.min(1F - (e.field_6012 - 47 + partialTicks) / 8F, 1F);
		}

		SpecialFlowerBlockEntityRenderer.renderRectangle(ms, buffers, aabb, false, color, (byte) alpha);
		offY += 0.001;
		ms.method_22909();
	}

	@NotNull
	@Override
	public class_2960 getTextureLocation(@NotNull MagicLandmineEntity entity) {
		return class_1723.field_21668;
	}
}
