/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.entity;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.common.handler.ContributorList;

import java.util.*;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_591;
import net.minecraft.class_742;
import net.minecraft.class_809;

public final class ContributorFancinessHandler extends class_3887<class_742, class_591<class_742>> {

	public ContributorFancinessHandler(class_3883<class_742, class_591<class_742>> renderer) {
		super(renderer);
	}

	@Override
	public void render(class_4587 ms, class_4597 buffers, int light, @NotNull class_742 player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
		ContributorList.firstStart();

		if (player.method_5767()) {
			return;
		}

		String name = player.method_7334().getName();

		if (name.equals("haighyorkie")) {
			renderGoldfish(ms, buffers);
		}

		if (player.method_7348(class_1664.field_7559)) {
			class_1799 flower = ContributorList.getFlower(name.toLowerCase(Locale.ROOT));
			if (!flower.method_7960()) {
				renderFlower(ms, buffers, player, flower);
			}
		}

	}

	private void renderGoldfish(class_4587 ms, class_4597 buffers) {
		ms.method_22903();
		method_17165().field_3398.method_22703(ms);
		ms.method_22904(-0.15F, -0.60F, 0F);
		ms.method_22905(0.4F, -0.4F, -0.4F);
		class_310.method_1551().method_1541().method_3350().method_3367(ms.method_23760(), buffers.getBuffer(class_4722.method_24076()), null, MiscellaneousModels.INSTANCE.goldfishModel, 1, 1, 1, 0xF000F0, class_4608.field_21444);
		ms.method_22909();
	}

	private void renderFlower(class_4587 ms, class_4597 buffers, class_1657 player, class_1799 flower) {
		ms.method_22903();
		method_17165().field_3398.method_22703(ms);
		ms.method_22904(0, -0.75, 0);
		ms.method_22905(0.5F, -0.5F, -0.5F);
		class_310.method_1551().method_1480().method_23177(player, flower, class_809.class_811.field_4315, false,
				ms, buffers, player.field_6002, 0xF000F0, class_4608.field_21444, player.method_5628());
		ms.method_22909();
	}
}
