/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.block_entity;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.common.block.block_entity.TinyPotatoBlockEntity;
import vazkii.botania.common.handler.ContributorList;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.block.TinyPotatoBlockItem;
import vazkii.botania.common.item.equipment.bauble.FlugelTiaraItem;
import vazkii.botania.mixin.client.ModelManagerAccessor;
import vazkii.botania.xplat.ClientXplatAbstractions;

import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_1160;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_5614;
import net.minecraft.class_776;
import net.minecraft.class_809;
import net.minecraft.class_827;
import net.minecraft.class_918;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class TinyPotatoBlockEntityRenderer implements class_827<TinyPotatoBlockEntity> {
	public static final String DEFAULT = "default";
	public static final String HALLOWEEN = "halloween";
	private static final Pattern ESCAPED = Pattern.compile("[^a-z0-9/._-]");
	private final class_776 blockRenderDispatcher;

	public TinyPotatoBlockEntityRenderer(class_5614.class_5615 ctx) {
		this.blockRenderDispatcher = ctx.method_32141();
	}

	private static String removeFromFront(String name, String match) {
		return name.substring(match.length()).trim();
	}

	public static class_1087 getModelFromDisplayName(class_2561 displayName) {
		var name = displayName.getString().trim().toLowerCase(Locale.ROOT);
		if (TinyPotatoBlockItem.isEnchantedName(displayName)) {
			name = removeFromFront(name, "enchanted");
		}
		return getModel(name);
	}

	private static class_1087 getModel(String name) {
		class_1092 bmm = class_310.method_1551().method_1554();
		Map<class_2960, class_1087> mm = ((ModelManagerAccessor) bmm).getBakedRegistry();
		class_1087 missing = bmm.method_4744();
		class_2960 location = taterLocation(name);
		class_1087 model = mm.get(location);
		if (model == null) {
			if (ClientProxy.dootDoot) {
				return mm.getOrDefault(taterLocation(HALLOWEEN), missing);
			} else {
				return mm.getOrDefault(taterLocation(DEFAULT), missing);
			}
		}
		return model;
	}

	private static class_2960 taterLocation(String name) {
		return prefix(ResourcesLib.PREFIX_TINY_POTATO + "/" + normalizeName(name));
	}

	private static String normalizeName(String name) {
		return ESCAPED.matcher(name).replaceAll("_");
	}

	@Override
	public void render(@NotNull TinyPotatoBlockEntity potato, float partialTicks, class_4587 ms, @NotNull class_4597 buffers, int light, int overlay) {
		ms.method_22903();

		String name = potato.name.getString().toLowerCase(Locale.ROOT).trim();
		boolean enchanted = TinyPotatoBlockItem.isEnchantedName(potato.name);
		if (enchanted) {
			name = removeFromFront(name, "enchanted");
		}
		class_1921 layer = class_4722.method_24076();
		class_1087 model = getModel(name);

		ms.method_22904(0.5F, 0F, 0.5F);
		class_2350 potatoFacing = potato.method_11010().method_11654(class_2741.field_12481);
		float rotY = 0;
		switch (potatoFacing) {
			default:
			case field_11035:
				rotY = 180F;
				break;
			case field_11043:
				break;
			case field_11034:
				rotY = 90F;
				break;
			case field_11039:
				rotY = 270F;
				break;
		}
		ms.method_22907(class_1160.field_20704.method_23214(rotY));

		float jump = potato.jumpTicks;
		if (jump > 0) {
			jump -= partialTicks;
		}

		float up = (float) Math.abs(Math.sin(jump / 10 * Math.PI)) * 0.2F;
		float rotZ = (float) Math.sin(jump / 10 * Math.PI) * 2;
		float wiggle = (float) Math.sin(jump / 10 * Math.PI) * 0.05F;

		ms.method_22904(wiggle, up, 0F);
		ms.method_22907(class_1160.field_20707.method_23214(rotZ));

		boolean render = !(name.equals("mami") || name.equals("soaryn") || name.equals("eloraam") && jump != 0);
		if (render) {
			ms.method_22903();
			ms.method_22904(-0.5F, 0, -0.5F);
			class_4588 buffer = class_918.method_23181(buffers, layer, true, enchanted);

			renderModel(ms, buffer, light, overlay, model);
			ms.method_22909();
		}

		ms.method_22904(0F, 1.5F, 0F);
		ms.method_22903();
		ms.method_22907(class_1160.field_20707.method_23214(180F));
		renderItems(potato, potatoFacing, name, partialTicks, ms, buffers, light, overlay);

		ms.method_22903();
		ClientXplatAbstractions.INSTANCE.fireRenderTinyPotato(potato, potato.name, partialTicks, ms, buffers, light, overlay);
		ms.method_22909();
		ms.method_22909();

		ms.method_22907(class_1160.field_20707.method_23214(-rotZ));
		ms.method_22907(class_1160.field_20704.method_23214(-rotY));

		renderName(potato, name, ms, buffers, light);
		ms.method_22909();
	}

	private void renderName(TinyPotatoBlockEntity potato, String name, class_4587 ms, class_4597 buffers, int light) {
		class_310 mc = class_310.method_1551();
		class_239 pos = mc.field_1765;
		if (class_310.method_1498()
				&& !name.isEmpty() && pos != null && pos.method_17783() == class_239.class_240.field_1332
				&& potato.method_11016().equals(((class_3965) pos).method_17777())) {
			ms.method_22903();
			ms.method_22904(0F, -0.6F, 0F);
			ms.method_22907(mc.method_1561().method_24197());
			float f1 = 0.016666668F * 1.6F;
			ms.method_22905(-f1, -f1, f1);
			int halfWidth = mc.field_1772.method_1727(potato.name.getString()) / 2;

			float opacity = class_310.method_1551().field_1690.method_19343(0.25F);
			int opacityRGB = (int) (opacity * 255.0F) << 24;
			mc.field_1772.method_30882(potato.name, -halfWidth, 0, 0x20FFFFFF, false, ms.method_23760().method_23761(), buffers, true, opacityRGB, light);
			mc.field_1772.method_30882(potato.name, -halfWidth, 0, 0xFFFFFFFF, false, ms.method_23760().method_23761(), buffers, false, 0, light);
			if (name.equals("pahimar") || name.equals("soaryn")) {
				ms.method_22904(0F, 14F, 0F);
				String str = name.equals("pahimar") ? "[WIP]" : "(soon)";
				halfWidth = mc.field_1772.method_1727(str) / 2;

				mc.field_1772.method_27521(str, -halfWidth, 0, 0x20FFFFFF, false, ms.method_23760().method_23761(), buffers, true, opacityRGB, light);
				mc.field_1772.method_27521(str, -halfWidth, 0, 0xFFFFFFFF, false, ms.method_23760().method_23761(), buffers, true, 0, light);
			}

			ms.method_22909();
		}
	}

	private void renderItems(TinyPotatoBlockEntity potato, class_2350 facing, String name, float partialTicks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		ms.method_22903();
		ms.method_22907(class_1160.field_20707.method_23214(180F));
		ms.method_22904(0F, -1F, 0F);
		float s = 1F / 3.5F;
		ms.method_22905(s, s, s);

		for (int i = 0; i < potato.inventorySize(); i++) {
			class_1799 stack = potato.getItemHandler().method_5438(i);
			if (stack.method_7960()) {
				continue;
			}

			ms.method_22903();
			class_2350 side = class_2350.values()[i];
			if (side.method_10166() != class_2351.field_11052) {
				float sideAngle = side.method_10144() - facing.method_10144();
				side = class_2350.method_10150(sideAngle);
			}

			boolean block = stack.method_7909() instanceof class_1747;
			boolean mySon = stack.method_7909() instanceof TinyPotatoBlockItem;

			switch (side) {
				case field_11036 -> {
					if (mySon) {
						ms.method_22904(0F, 0.6F, 0.5F);
					} else if (block) {
						ms.method_22904(0F, 0.3F, 0.5F);
					}
					ms.method_22904(0F, -0.5F, -0.4F);
				}
				case field_11033 -> {
					ms.method_22904(0, -2.3F, -0.88F);
					if (mySon) {
						ms.method_22904(0, .65F, 0.6F);
					} else if (block) {
						ms.method_22904(0, 1, 0.6F);
					}
				}
				case field_11043 -> {
					ms.method_22904(0, -1.9F, 0.02F);
					if (mySon) {
						ms.method_22904(0, 1, 0.6F);
					} else if (block) {
						ms.method_22904(0, 1, 0.6F);
					}
				}
				case field_11035 -> {
					ms.method_22904(0, -1.6F, -0.89F);
					if (mySon) {
						ms.method_22904(0, 1.4F, 0.5F);
					} else if (block) {
						ms.method_22904(0, 1.0F, 0.5F);
					}
				}
				case field_11034 -> {
					if (mySon) {
						ms.method_22904(-0.4F, 0.65F, 0F);
					} else if (block) {
						ms.method_22904(-0.4F, 0.8F, 0F);
					} else {
						ms.method_22907(class_1160.field_20705.method_23214(-90F));
					}
					ms.method_22904(-0.3F, -1.9F, 0.04F);
				}
				case field_11039 -> {
					if (mySon) {
						ms.method_22904(1F, 0.65F, 1F);
					} else if (block) {
						ms.method_22904(1F, 0.8F, 1F);
					} else {
						ms.method_22907(class_1160.field_20705.method_23214(-90F));
					}
					ms.method_22904(-0.3F, -1.9F, -0.92F);
				}
			}

			if (mySon) {
				ms.method_22905(1.1F, 1.1F, 1.1F);
			} else if (block) {
				ms.method_22905(0.5F, 0.5F, 0.5F);
			}
			if (block && side == class_2350.field_11043) {
				ms.method_22907(class_1160.field_20705.method_23214(180F));
			}
			renderItem(ms, buffers, light, overlay, stack);
			ms.method_22909();
		}
		ms.method_22909();

		ms.method_22903();
		if (!name.isEmpty()) {
			ContributorList.firstStart();

			float scale = 1F / 4F;
			ms.method_22904(0F, 1F, 0F);
			ms.method_22905(scale, scale, scale);
			switch (name) {
				case "phi", "vazkii" -> {
					ms.method_22903();
					ms.method_22904(-0.15, 0.1, 0.4);
					ms.method_22907(class_1160.field_20705.method_23214(90F));
					ms.method_22907(new class_1160(1, 0, 1).method_23214(20));
					renderModel(ms, buffers, light, overlay, MiscellaneousModels.INSTANCE.phiFlowerModel);
					ms.method_22909();
					if (name.equals("vazkii")) {
						ms.method_22905(1.25F, 1.25F, 1.25F);
						ms.method_22907(class_1160.field_20703.method_23214(180F));
						ms.method_22907(class_1160.field_20705.method_23214(-90F));
						ms.method_22904(0.2, -1.25, 0);
						renderModel(ms, buffers, light, overlay, MiscellaneousModels.INSTANCE.nerfBatModel);
					}
				}
				case "haighyorkie" -> {
					ms.method_22905(1.25F, 1.25F, 1.25F);
					ms.method_22907(class_1160.field_20707.method_23214(180F));
					ms.method_22907(class_1160.field_20705.method_23214(-90F));
					ms.method_22904(-0.5F, -1.2F, -0.075F);
					renderModel(ms, buffers, light, overlay, MiscellaneousModels.INSTANCE.goldfishModel);
				}
				case "martysgames", "marty" -> {
					ms.method_22905(0.7F, 0.7F, 0.7F);
					ms.method_22907(class_1160.field_20707.method_23214(180F));
					ms.method_22904(-0.3F, -2.7F, -1.2F);
					ms.method_22907(class_1160.field_20707.method_23214(15F));
					renderItem(ms, buffers, light, overlay, new class_1799(BotaniaItems.infiniteFruit, 1).method_7977(class_2561.method_43470("das boot")));
				}
				case "jibril" -> {
					ms.method_22905(1.5F, 1.5F, 1.5F);
					ms.method_22904(0F, 0.8F, 0F);
					FlugelTiaraItem.ClientLogic.renderHalo(null, null, ms, buffers, partialTicks);
				}
				case "kingdaddydmac" -> {
					ms.method_22905(0.5F, 0.5F, 0.5F);
					ms.method_22907(class_1160.field_20707.method_23214(180));
					ms.method_22907(class_1160.field_20705.method_23214(90));
					ms.method_22903();
					ms.method_22904(0F, -2.5F, 0.65F);
					class_1799 ring = new class_1799(BotaniaItems.manaRing);
					renderItem(ms, buffers, light, overlay, ring);
					ms.method_22904(0F, 0F, -4F);
					renderItem(ms, buffers, light, overlay, ring);
					ms.method_22909();
					ms.method_22904(1.5, -4, -2.5);
					renderBlock(ms, buffers, light, overlay, class_2246.field_10183);
				}
				default -> {
					class_1799 icon = ContributorList.getFlower(name);
					if (!icon.method_7960()) {
						ms.method_22907(class_1160.field_20703.method_23214(180));
						ms.method_22907(class_1160.field_20705.method_23214(180));
						ms.method_22904(0, -0.75, -0.5);
						class_310.method_1551().method_1480().method_23178(icon, class_809.class_811.field_4316,
								light, overlay, ms, buffers, 0);
					}
				}
			}
		}
		ms.method_22909();
	}

	private void renderModel(class_4587 ms, class_4597 buffers, int light, int overlay, class_1087 model) {
		renderModel(ms, buffers.getBuffer(class_4722.method_24076()), light, overlay, model);
	}

	private void renderModel(class_4587 ms, class_4588 buffer, int light, int overlay, class_1087 model) {
		blockRenderDispatcher.method_3350().method_3367(ms.method_23760(), buffer, null, model, 1, 1, 1, light, overlay);
	}

	private void renderItem(class_4587 ms, class_4597 buffers, int light, int overlay, class_1799 stack) {
		class_310.method_1551().method_1480().method_23178(stack, class_809.class_811.field_4316,
				light, overlay, ms, buffers, 0);
	}

	private void renderBlock(class_4587 ms, class_4597 buffers, int light, int overlay, class_2248 block) {
		blockRenderDispatcher.method_3353(block.method_9564(), ms, buffers, light, overlay);
	}
}
