/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.block_entity;

import org.jetbrains.annotations.Nullable;

import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.client.model.BotaniaModelLayers;
import vazkii.botania.client.model.TeruTeruBozuModel;
import vazkii.botania.common.block.block_entity.TeruTeruBozuBlockEntity;

import java.util.Random;
import net.minecraft.class_1160;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;

public class TeruTeruBozuBlockEntityRenderer implements class_827<TeruTeruBozuBlockEntity> {

	private static final class_2960 texture = new class_2960(ResourcesLib.MODEL_TERU_TERU_BOZU);
	private static final class_2960 textureHalloween = new class_2960(ResourcesLib.MODEL_TERU_TERU_BOZU_HALLOWEEN);
	private final TeruTeruBozuModel model;

	public TeruTeruBozuBlockEntityRenderer(class_5614.class_5615 ctx) {
		model = new TeruTeruBozuModel(ctx.method_32140(BotaniaModelLayers.TERU_TERU_BOZU));
	}

	@Override
	public void render(@Nullable TeruTeruBozuBlockEntity tileentity, float partialTicks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		ms.method_22903();
		ms.method_22907(class_1160.field_20703.method_23214(180));
		double time = ClientTickHandler.ticksInGame + partialTicks;
		boolean hasWorld = tileentity != null && tileentity.method_10997() != null;
		if (hasWorld) {
			time += new Random(tileentity.method_11016().hashCode()).nextInt(1000);
		}

		ms.method_22904(0.5F, -1.25F + (hasWorld ? (float) Math.sin(time * 0.01F) * 0.05F : 0F), -0.5F);
		if (hasWorld) {
			ms.method_22907(class_1160.field_20705.method_23214((float) (time * 0.3)));
			ms.method_22907(class_1160.field_20707.method_23214(4F * (float) Math.sin(time * 0.05F)));
			float s = 0.75F;
			ms.method_22905(s, s, s);
		}

		class_4588 buffer = buffers.getBuffer(model.method_23500(ClientProxy.dootDoot ? textureHalloween : texture));
		model.method_2828(ms, buffer, light, overlay, 1, 1, 1, 1);
		ms.method_22909();
	}

}
