/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.block_entity;

import net.minecraft.class_1159;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.block_entity.StarfieldCreatorBlockEntity;

public class StarfieldCreatorBlockEntityRenderer implements class_827<StarfieldCreatorBlockEntity> {
	public StarfieldCreatorBlockEntityRenderer(class_5614.class_5615 ctx) {}

	@Override
	public void render(StarfieldCreatorBlockEntity tile, float partialTicsk, class_4587 pose, class_4597 buffers, int light, int overlay) {
		// [VanillaCopy] Adapted from TheEndPortalRenderer, only renders UP face and sets the offset low in the blockspace
		class_1159 matrix4f = pose.method_23760().method_23761();
		float offset = 0.24F;
		class_4588 buffer = buffers.getBuffer(RenderHelper.STARFIELD);
		this.renderFace(buffer, matrix4f, 0.0F, 1.0F, offset, offset, 1.0F, 1.0F, 0.0F, 0.0F);
	}

	private void renderFace(class_4588 vertexConsumer, class_1159 matrix4f, float f, float g, float h, float i, float j, float k, float l, float m) {
		vertexConsumer.method_22918(matrix4f, f, h, j).method_1344();
		vertexConsumer.method_22918(matrix4f, g, h, k).method_1344();
		vertexConsumer.method_22918(matrix4f, g, i, l).method_1344();
		vertexConsumer.method_22918(matrix4f, f, i, m).method_1344();
	}
}
