/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.block_entity;

import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.equipment.bauble.ManaseerMonocleItem;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1159;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;

public class SpecialFlowerBlockEntityRenderer<T extends SpecialFlowerBlockEntity> implements class_827<T> {
	public SpecialFlowerBlockEntityRenderer(class_5614.class_5615 ctx) {}

	@Override
	public void render(SpecialFlowerBlockEntity tile, float partialTicks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		if (tile.isFloating()) {
			FloatingFlowerBlockEntityRenderer.renderFloatingIsland(tile, partialTicks, ms, buffers, overlay);
		}
		if (!(class_310.method_1551().field_1719 instanceof class_1309 view)) {
			return;
		}

		if (!ManaseerMonocleItem.hasMonocle(view)) {
			return;
		}
		class_2338 pos = null;
		class_239 ray = class_310.method_1551().field_1765;
		if (ray != null && ray.method_17783() == class_239.class_240.field_1332) {
			pos = ((class_3965) ray).method_17777();
		}
		boolean hasBindingAttempt = hasBindingAttempt(view, tile.method_11016());

		if (hasBindingAttempt || tile.method_11016().equals(pos)) {
			SpecialFlowerBlockEntity flower = tile;
			ms.method_22903();
			if (hasBindingAttempt) {
				ms.method_22904(0, 0.005, 0);
			}
			renderRadius(tile, ms, buffers, flower.getRadius());
			ms.method_22904(0, 0.002, 0);
			renderRadius(tile, ms, buffers, flower.getSecondaryRadius());
			ms.method_22909();

		}
	}

	public static void renderRadius(class_2586 tile, class_4587 ms, class_4597 buffers, @Nullable RadiusDescriptor descriptor) {
		if (descriptor != null) {
			ms.method_22903();
			ms.method_22904(-tile.method_11016().method_10263(), -tile.method_11016().method_10264(), -tile.method_11016().method_10260());
			if (descriptor instanceof RadiusDescriptor.Circle circle) {
				renderCircle(ms, buffers, circle.subtileCoords(), circle.radius());
			} else if (descriptor instanceof RadiusDescriptor.Rectangle rectangle) {
				renderRectangle(ms, buffers, rectangle.aabb(), true, null, (byte) 32);
			}
			ms.method_22909();
		}
	}

	public static boolean hasBindingAttempt(class_1309 view, class_2338 tilePos) {
		class_1799 stackHeld = PlayerHelper.getFirstHeldItemClass(view, WandOfTheForestItem.class);
		if (!stackHeld.method_7960() && WandOfTheForestItem.getBindMode(stackHeld)) {
			return WandOfTheForestItem.getBindingAttempt(stackHeld).filter(tilePos::equals).isPresent();
		}
		return false;
	}

	private static void renderCircle(class_4587 ms, class_4597 buffers, class_2338 center, double radius) {
		ms.method_22903();
		double x = center.method_10263() + 0.5;
		double y = center.method_10264();
		double z = center.method_10260() + 0.5;
		ms.method_22904(x, y, z);
		int color = class_3532.method_15369(ClientTickHandler.ticksInGame % 200 / 200F, 0.6F, 1F);
		int r = (color >> 16 & 0xFF);
		int g = (color >> 8 & 0xFF);
		int b = (color & 0xFF);

		int alpha = 32;
		float f = 1F / 16F;

		int totalAngles = 360;
		int drawAngles = 360;
		int step = totalAngles / drawAngles;

		radius -= f;
		class_4588 buffer = buffers.getBuffer(RenderHelper.CIRCLE);
		class_1159 mat = ms.method_23760().method_23761();

		Runnable centerFunc = () -> buffer.method_22918(mat, 0, f, 0).method_1336(r, g, b, alpha).method_1344();
		List<Runnable> vertexFuncs = new ArrayList<>();
		for (int i = 0; i < totalAngles + 1; i += step) {
			double rad = (totalAngles - i) * Math.PI / 180.0;
			float xp = (float) (Math.cos(rad) * radius);
			float zp = (float) (Math.sin(rad) * radius);
			vertexFuncs.add(() -> buffer.method_22918(mat, xp, f, zp).method_1336(r, g, b, alpha).method_1344());
		}
		RenderHelper.triangleFan(centerFunc, vertexFuncs);

		radius += f;
		float f1 = f + f / 4F;
		int alpha2 = 64;

		centerFunc = () -> buffer.method_22918(mat, 0, f1, 0).method_1336(r, g, b, alpha2).method_1344();
		vertexFuncs.clear();
		for (int i = 0; i < totalAngles + 1; i += step) {
			double rad = (totalAngles - i) * Math.PI / 180.0;
			float xp = (float) (Math.cos(rad) * radius);
			float zp = (float) (Math.sin(rad) * radius);
			vertexFuncs.add(() -> buffer.method_22918(mat, xp, f1, zp).method_1336(r, g, b, alpha2).method_1344());
		}
		RenderHelper.triangleFan(centerFunc, vertexFuncs);
		ms.method_22909();
	}

	public static void renderRectangle(class_4587 ms, class_4597 buffers, class_238 aabb, boolean inner, @Nullable Integer color, byte alpha) {
		ms.method_22903();
		ms.method_22904(aabb.field_1323, aabb.field_1322, aabb.field_1321);

		if (color == null) {
			color = class_3532.method_15369(ClientTickHandler.ticksInGame % 200 / 200F, 0.6F, 1F);
		}
		int r = (color >> 16 & 0xFF);
		int g = (color >> 8 & 0xFF);
		int b = (color & 0xFF);

		float f = 1F / 16F;
		float x = (float) (aabb.field_1320 - aabb.field_1323 - f);
		float z = (float) (aabb.field_1324 - aabb.field_1321 - f);

		class_4588 buffer = buffers.getBuffer(RenderHelper.RECTANGLE);
		class_1159 mat = ms.method_23760().method_23761();
		buffer.method_22918(mat, x, f, f).method_1336(r, g, b, alpha).method_1344();
		buffer.method_22918(mat, f, f, f).method_1336(r, g, b, alpha).method_1344();
		buffer.method_22918(mat, f, f, z).method_1336(r, g, b, alpha).method_1344();
		buffer.method_22918(mat, x, f, z).method_1336(r, g, b, alpha).method_1344();

		if (inner) {
			x += f;
			z += f;
			float f1 = f + f / 4F;
			alpha *= 2;
			buffer.method_22918(mat, x, f1, 0).method_1336(r, g, b, alpha).method_1344();
			buffer.method_22918(mat, 0, f1, 0).method_1336(r, g, b, alpha).method_1344();
			buffer.method_22918(mat, 0, f1, z).method_1336(r, g, b, alpha).method_1344();
			buffer.method_22918(mat, x, f1, z).method_1336(r, g, b, alpha).method_1344();
		}

		ms.method_22909();
	}
}
