/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.block_entity;

import org.jetbrains.annotations.Nullable;

import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.client.model.*;
import vazkii.botania.common.block.PylonBlock;
import vazkii.botania.common.block.block_entity.PylonBlockEntity;

import java.util.Random;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_809;
import net.minecraft.class_827;

public class PylonBlockEntityRenderer implements class_827<PylonBlockEntity> {

	public static final class_2960 MANA_TEXTURE = new class_2960(ResourcesLib.MODEL_PYLON_MANA);
	public static final class_2960 NATURA_TEXTURE = new class_2960(ResourcesLib.MODEL_PYLON_NATURA);
	public static final class_2960 GAIA_TEXTURE = new class_2960(ResourcesLib.MODEL_PYLON_GAIA);

	private final ManaPylonModel manaModel;
	private final NaturaPylonModel naturaModel;
	private final GaiaPylonModel gaiaModel;

	// Overrides for when we call this without an actual pylon
	private static PylonBlock.Variant forceVariant = PylonBlock.Variant.MANA;
	private static class_809.class_811 forceTransform = class_809.class_811.field_4315;

	public PylonBlockEntityRenderer(class_5614.class_5615 ctx) {
		manaModel = new ManaPylonModel(ctx.method_32140(BotaniaModelLayers.PYLON_MANA));
		naturaModel = new NaturaPylonModel(ctx.method_32140(BotaniaModelLayers.PYLON_NATURA));
		gaiaModel = new GaiaPylonModel(ctx.method_32140(BotaniaModelLayers.PYLON_GAIA));
	}

	@Override
	public void render(@Nullable PylonBlockEntity pylon, float pticks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		boolean renderingItem = pylon == null;
		boolean direct = renderingItem && (forceTransform == class_809.class_811.field_4317 || forceTransform.method_29998()); // loosely based off ItemRenderer logic
		PylonBlock.Variant type = renderingItem ? forceVariant : ((PylonBlock) pylon.method_11010().method_26204()).variant;
		PylonModel model;
		class_2960 texture;
		class_1921 shaderLayer;
		switch (type) {
			default -> {
				model = manaModel;
				texture = MANA_TEXTURE;
				shaderLayer = direct ? RenderHelper.MANA_PYLON_GLOW_DIRECT : RenderHelper.MANA_PYLON_GLOW;
			}
			case NATURA -> {
				model = naturaModel;
				texture = NATURA_TEXTURE;
				shaderLayer = direct ? RenderHelper.NATURA_PYLON_GLOW_DIRECT : RenderHelper.NATURA_PYLON_GLOW;
			}
			case GAIA -> {
				model = gaiaModel;
				texture = GAIA_TEXTURE;
				shaderLayer = direct ? RenderHelper.GAIA_PYLON_GLOW_DIRECT : RenderHelper.GAIA_PYLON_GLOW;
			}
		}

		ms.method_22903();

		float worldTime = ClientTickHandler.ticksInGame + pticks;

		worldTime += pylon == null ? 0 : new Random(pylon.method_11016().hashCode()).nextInt(360);

		ms.method_22904(0, pylon == null ? 1.35 : 1.5, 0);
		ms.method_22905(1.0F, -1.0F, -1.0F);

		ms.method_22903();
		ms.method_22904(0.5F, 0F, -0.5F);
		if (pylon != null) {
			ms.method_22907(class_1160.field_20705.method_23214(worldTime * 1.5F));
		}

		class_1921 layer = class_1921.method_23580(texture);

		class_4588 buffer = buffers.getBuffer(layer);
		model.renderRing(ms, buffer, light, overlay);
		if (pylon != null) {
			ms.method_22904(0D, Math.sin(worldTime / 20D) / 20 - 0.025, 0D);
		}
		ms.method_22909();

		ms.method_22903();
		if (pylon != null) {
			ms.method_22904(0D, Math.sin(worldTime / 20D) / 17.5, 0D);
		}

		ms.method_22904(0.5F, 0F, -0.5F);
		if (pylon != null) {
			ms.method_22907(class_1160.field_20705.method_23214(-worldTime));
		}

		buffer = buffers.getBuffer(shaderLayer);
		model.renderCrystal(ms, buffer, light, overlay);

		ms.method_22909();

		ms.method_22909();
	}

	public static class ItemRenderer extends TEISR {
		public ItemRenderer(class_2248 block) {
			super(block);
		}

		@Override
		public void render(class_1799 stack, class_809.class_811 type, class_4587 ms, class_4597 buffers, int light, int overlay) {
			if (class_2248.method_9503(stack.method_7909()) instanceof PylonBlock pylon) {
				PylonBlockEntityRenderer.forceVariant = pylon.variant;
				PylonBlockEntityRenderer.forceTransform = type;
				super.render(stack, type, ms, buffers, light, overlay);
			}
		}
	}
}
