/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.block_entity;

import net.minecraft.class_1160;
import net.minecraft.class_1542;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.block_entity.ManaEnchanterBlockEntity;
import vazkii.botania.mixin.ItemEntityAccessor;

public class ManaEnchanterBlockEntityRenderer implements class_827<ManaEnchanterBlockEntity> {

	private class_1542 item;

	public ManaEnchanterBlockEntityRenderer(class_5614.class_5615 ctx) {}

	@Override
	public void render(@NotNull ManaEnchanterBlockEntity enchanter, float partTicks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		float alphaMod = 0F;

		if (enchanter.stage == ManaEnchanterBlockEntity.State.GATHER_MANA) {
			alphaMod = Math.min(20, enchanter.stageTicks) / 20F;
		} else if (enchanter.stage == ManaEnchanterBlockEntity.State.RESET) {
			alphaMod = (20 - enchanter.stageTicks) / 20F;
		} else if (enchanter.stage == ManaEnchanterBlockEntity.State.DO_ENCHANT) {
			alphaMod = 1F;
		}

		ms.method_22903();
		if (!enchanter.itemToEnchant.method_7960()) {
			if (item == null) {
				item = new class_1542(enchanter.method_10997(), enchanter.method_11016().method_10263(), enchanter.method_11016().method_10264() + 1, enchanter.method_11016().method_10260(), enchanter.itemToEnchant);
			}

			((ItemEntityAccessor) item).setAge(ClientTickHandler.ticksInGame);
			item.method_6979(enchanter.itemToEnchant);

			ms.method_22904(0.5F, 1.25F, 0.5F);
			class_310.method_1551().method_1561().method_3954(item, 0, 0, 0, 0, partTicks, ms, buffers, light);
			ms.method_22904(-0.5F, -1.25F, -0.5F);
		}

		ms.method_22907(class_1160.field_20703.method_23214(90F));
		ms.method_22904(-2F, -2F, -0.001F);

		float alpha = (float) ((Math.sin((ClientTickHandler.ticksInGame + partTicks) / 8D) + 1D) / 5D + 0.4D) * alphaMod;

		if (alpha > 0) {
			if (enchanter.stage == ManaEnchanterBlockEntity.State.DO_ENCHANT || enchanter.stage == ManaEnchanterBlockEntity.State.RESET) {
				float ticks = enchanter.stageTicks + enchanter.stage3EndTicks + partTicks;
				float angle = ticks * 2;
				float yTranslation = Math.min(20, ticks) / 20F * 1.15F;
				float scale = ticks < 10 ? 1F : 1F - Math.min(20, ticks - 10) / 20F * 0.75F;

				ms.method_22904(2.5F, 2.5F, -yTranslation);
				ms.method_22905(scale, scale, 1F);
				ms.method_22907(class_1160.field_20707.method_23214(angle));
				ms.method_22904(-2.5F, -2.5F, 0F);
			}

			class_4588 buffer = buffers.getBuffer(RenderHelper.ENCHANTER);
			RenderHelper.renderIconFullBright(
					ms, buffer,
					0, 0, 5, 5,
					0, 0, 16, 16,
					MiscellaneousModels.INSTANCE.enchanterOverlay.method_24148(), 0xFFFFFF, alpha, light
			);
		}

		ms.method_22909();
	}

}
