/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.block_entity;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.state.enums.LuminizerVariant;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.LuminizerBlock;
import vazkii.botania.common.block.block_entity.LuminizerBlockEntity;
import vazkii.botania.common.item.equipment.bauble.ManaseerMonocleItem;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1058;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4730;
import net.minecraft.class_5614;
import net.minecraft.class_827;

public class LuminizerBlockEntityRenderer implements class_827<LuminizerBlockEntity> {

	private static final Map<LuminizerVariant, class_4730> sprites = class_156.method_654(new EnumMap<>(LuminizerVariant.class), m -> {
		m.put(LuminizerVariant.DEFAULT, MiscellaneousModels.INSTANCE.lightRelayWorldIcon);
		m.put(LuminizerVariant.DETECTOR, MiscellaneousModels.INSTANCE.lightRelayDetectorWorldIcon);
		m.put(LuminizerVariant.FORK, MiscellaneousModels.INSTANCE.lightRelayForkWorldIcon);
		m.put(LuminizerVariant.TOGGLE, MiscellaneousModels.INSTANCE.lightRelayToggleWorldIcon);
	});

	public LuminizerBlockEntityRenderer(class_5614.class_5615 ctx) {}

	@Override
	public void render(@NotNull LuminizerBlockEntity tile, float pticks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		class_2680 state = tile.method_11010();

		class_310 mc = class_310.method_1551();

		if (mc.method_1560() instanceof class_1309 view) {
			if (ManaseerMonocleItem.hasMonocle(view) && SpecialFlowerBlockEntityRenderer.hasBindingAttempt(view, tile.method_11016())) {
				SpecialFlowerBlockEntityRenderer.renderRadius(tile, ms, buffers, new RadiusDescriptor.Circle(tile.method_11016(), LuminizerBlockEntity.MAX_DIST));
			}
		}

		class_1058 iicon = sprites.get(((LuminizerBlock) state.method_26204()).variant).method_24148();

		ms.method_22903();
		ms.method_22904(0.5, 0.3, 0.5);

		double time = ClientTickHandler.ticksInGame + pticks;

		float scale = 0.75F;
		ms.method_22905(scale, scale, scale);

		ms.method_22907(mc.method_1561().method_24197());
		ms.method_22907(class_1160.field_20705.method_23214(180.0F));

		float off = 0.25F;
		ms.method_22904(0F, off, 0F);
		ms.method_22907(class_1160.field_20707.method_23214((float) time));
		ms.method_22904(0F, -off, 0F);

		class_4588 buffer = buffers.getBuffer(RenderHelper.LIGHT_RELAY);
		renderIcon(ms, buffer, iicon);

		ms.method_22909();
	}

	private void renderIcon(class_4587 ms, class_4588 buffer, class_1058 icon) {
		float size = icon.method_4577() - icon.method_4594();
		float pad = size / 8F;
		float f = icon.method_4594() + pad;
		float f1 = icon.method_4577() - pad;
		float f2 = icon.method_4593() + pad;
		float f3 = icon.method_4575() - pad;

		float f4 = 1.0F;
		float f5 = 0.5F;
		float f6 = 0.25F;

		class_1159 mat = ms.method_23760().method_23761();
		buffer.method_22918(mat, 0.0F - f5, 0.0F - f6, 0.0F).method_22915(1F, 1F, 1F, 1F).method_22913(f, f3).method_1344();
		buffer.method_22918(mat, f4 - f5, 0.0F - f6, 0.0F).method_22915(1F, 1F, 1F, 1F).method_22913(f1, f3).method_1344();
		buffer.method_22918(mat, f4 - f5, f4 - f6, 0.0F).method_22915(1F, 1F, 1F, 1F).method_22913(f1, f2).method_1344();
		buffer.method_22918(mat, 0.0F - f5, f4 - f6, 0.0F).method_22915(1F, 1F, 1F, 1F).method_22913(f, f2).method_1344();

	}

}
