/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.block_entity;

import org.jetbrains.annotations.Nullable;

import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.client.model.BotaniaModelLayers;
import vazkii.botania.client.model.HourglassModel;
import vazkii.botania.common.block.block_entity.HoveringHourglassBlockEntity;

import java.util.Random;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;

public class HoveringHourglassBlockEntityRenderer implements class_827<HoveringHourglassBlockEntity> {

	final class_2960 texture = new class_2960(ResourcesLib.MODEL_HOURGLASS);
	private final HourglassModel model;

	public HoveringHourglassBlockEntityRenderer(class_5614.class_5615 ctx) {
		model = new HourglassModel(ctx.method_32140(BotaniaModelLayers.HOURGLASS));
	}

	@Override
	public void render(@Nullable HoveringHourglassBlockEntity hourglass, float ticks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		ms.method_22903();
		boolean hasWorld = hourglass != null && hourglass.method_10997() != null;
		int wtime = !hasWorld ? 0 : ClientTickHandler.ticksInGame;
		if (wtime != 0) {
			wtime += new Random(hourglass.method_11016().hashCode()).nextInt(360);
		}

		float time = wtime == 0 ? 0 : wtime + ticks;
		float x = 0.5F + (float) Math.cos(time * 0.05F) * 0.025F;
		float y = 0.55F + (float) (Math.sin(time * 0.04F) + 1F) * 0.05F;
		float z = 0.5F + (float) Math.sin(time * 0.05F) * 0.025F;
		class_1799 stack = hasWorld ? hourglass.getItemHandler().method_5438(0) : class_1799.field_8037;

		float activeFraction = stack.method_7960() ? 0 : hourglass.lastFraction + (hourglass.timeFraction - hourglass.lastFraction) * ticks;
		float fract1 = stack.method_7960() ? 0 : activeFraction;
		float fract2 = stack.method_7960() ? 0 : 1F - activeFraction;
		ms.method_22904(x, y, z);

		float rot = hasWorld && hourglass.flip ? 180F : 1F;
		if (hasWorld && hourglass.flipTicks > 0) {
			rot += (hourglass.flipTicks - ticks) * (180F / 4F);
		}
		ms.method_22907(class_1160.field_20707.method_23214(rot));

		ms.method_22905(1F, -1F, -1F);
		int color = hasWorld ? hourglass.getColor() : 0;
		float r = (color >> 16) / 255.0F;
		float g = (color >> 8) / 255.0F;
		float b = (color & 0xFF) / 255.0F;
		class_4588 buffer = buffers.getBuffer(model.method_23500(texture));
		model.render(ms, buffer, light, overlay, r, g, b, 1, fract1, fract2, hasWorld && hourglass.flip);
		ms.method_22909();
	}

}
