/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.block_entity;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.block_entity.FloatingFlowerBlockEntity;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.ClientXplatAbstractions;

import java.util.Random;
import net.minecraft.class_1160;
import net.minecraft.class_2586;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;

public class FloatingFlowerBlockEntityRenderer implements class_827<FloatingFlowerBlockEntity> {

	public FloatingFlowerBlockEntityRenderer(class_5614.class_5615 ctx) {}

	@Override
	public void render(@NotNull FloatingFlowerBlockEntity tile, float t, class_4587 ms, class_4597 buffers, int light, int overlay) {
		renderFloatingIsland(tile, t, ms, buffers, overlay);
	}

	public static void renderFloatingIsland(class_2586 tile, float t, class_4587 ms, class_4597 buffers, int overlay) {
		if (BotaniaConfig.client().staticFloaters()) {
			return;
		}

		ms.method_22903();

		double worldTime = ClientTickHandler.ticksInGame + t;
		if (tile.method_10997() != null) {
			worldTime += new Random(tile.method_11016().hashCode()).nextInt(1000);
		}

		ms.method_22904(0.5F, 0, 0.5F);
		ms.method_22907(class_1160.field_20705.method_23214(-((float) worldTime * 0.5F)));
		ms.method_22904(-0.5, (float) Math.sin(worldTime * 0.05F) * 0.1F, 0.5);

		ms.method_22907(class_1160.field_20703.method_23214(4F * (float) Math.sin(worldTime * 0.04F)));
		ms.method_22907(class_1160.field_20705.method_23214(90.0F));

		ClientXplatAbstractions.INSTANCE.tessellateBlock(tile.method_10997(), tile.method_11010(),
				tile.method_11016(), ms, buffers, overlay);

		ms.method_22909();
	}

}
