/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.block_entity;

import net.minecraft.class_1087;
import net.minecraft.class_1160;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_5614;
import net.minecraft.class_776;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.block_entity.corporea.CorporeaCrystalCubeBlockEntity;
import vazkii.botania.mixin.ItemEntityAccessor;

public class CorporeaCrystalCubeBlockEntityRenderer implements class_827<CorporeaCrystalCubeBlockEntity> {
	// Ugly but there's no other way to get the model besides grabbing it from the event
	public static class_1087 cubeModel = null;
	private class_1542 entity = null;
	private final class_776 blockRenderDispatcher;

	public CorporeaCrystalCubeBlockEntityRenderer(class_5614.class_5615 ctx) {
		this.blockRenderDispatcher = ctx.method_32141();
	}

	@Override
	public void render(@Nullable CorporeaCrystalCubeBlockEntity cube, float f, class_4587 ms, class_4597 buffers, int light, int overlay) {
		class_1799 stack = class_1799.field_8037;
		if (cube != null) {
			if (entity == null) {
				entity = new class_1542(cube.method_10997(), cube.method_11016().method_10263(), cube.method_11016().method_10264(), cube.method_11016().method_10260(), new class_1799(class_2246.field_10340));
			}

			((ItemEntityAccessor) entity).setAge(ClientTickHandler.ticksInGame);
			stack = cube.getRequestTarget();
			entity.method_6979(stack);
		}

		class_310 mc = class_310.method_1551();
		ms.method_22903();
		ms.method_22904(0.5F, 1.5F, 0.5F);
		ms.method_22905(1F, -1F, -1F);
		/*
			Using Mth.sin(((float)entity.getAge() + f) / 10.0F + entity.bobOffs from ItemEntityRender#render to sync the bobbing.
			Divided by a negative number to make the item inside not be static (-1 almost make the cube and item the same speed).
			Making the divider smaller, slows down the cube bobbing (you can multiply instead to make it faster).
			This still keeps the item and the cube in sync, the cube just doesn't move as much as the item,
			but the item never goes outside the cube (based on the tests I made; some edge cases could exist).
		*/
		ms.method_22904(0F, (class_3532.method_15374(((float) entity.method_6985() + f) / 10.0F + entity.field_7203) * 0.1F + 0.1F) / -7F, 0F);

		if (!stack.method_7960()) {
			ms.method_22903();
			ms.method_22904(0F, 0.96F, 0F);
			ms.method_22905(0.64F, 0.64F, 0.64F);
			ms.method_22907(class_1160.field_20707.method_23214(180F));
			class_310.method_1551().method_1561().method_3953(entity).method_3936(entity, 0, f, ms, buffers, light);
			ms.method_22909();
		}

		if (cubeModel != null) {
			ms.method_22903();
			ms.method_22904(-0.5F, 0.25F, -0.5F);
			class_4588 buffer = buffers.getBuffer(class_4722.method_24076());
			blockRenderDispatcher.method_3350().method_3367(ms.method_23760(), buffer, null, cubeModel, 1, 1, 1, light, overlay);
			ms.method_22909();
		}

		if (!stack.method_7960()) {
			int count = cube.getItemCount();
			String countStr = "" + count;
			int color = 0xFFFFFF;
			if (count > 9999) {
				countStr = count / 1000 + "K";
				color = 0xFFFF00;
				if (count > 9999999) {
					countStr = count / 10000000 + "M";
					color = 0x00FF00;
				}
			}
			color |= 0xA0 << 24;
			int colorShade = (color & 16579836) >> 2 | color & -16777216;

			float s = 1F / 64F;
			ms.method_22905(s, s, s);
			int l = mc.field_1772.method_1727(countStr);

			ms.method_22904(0F, 55F, 0F);
			float tr = -16.5F;
			for (int i = 0; i < 4; i++) {
				ms.method_22907(class_1160.field_20705.method_23214(90F));
				ms.method_22904(0F, 0F, tr);
				mc.field_1772.method_27521(countStr, -l / 2, 0, color, false, ms.method_23760().method_23761(), buffers, false, 0, light);
				ms.method_22904(0F, 0F, 0.1F);
				mc.field_1772.method_27521(countStr, -l / 2 + 1, 1, colorShade, false, ms.method_23760().method_23761(), buffers, false, 0, light);
				ms.method_22904(0F, 0F, -tr - 0.1F);
			}
		}

		ms.method_22909();
	}
}
