/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.block_entity;

import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_809;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.item.AvatarWieldable;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.client.model.AvatarModel;
import vazkii.botania.client.model.BotaniaModelLayers;
import vazkii.botania.common.block.block_entity.AvatarBlockEntity;
import vazkii.botania.xplat.XplatAbstractions;

public class AvatarBlockEntityRenderer implements class_827<AvatarBlockEntity> {

	private static final float[] ROTATIONS = new float[] {
			180F, 0F, 90F, 270F
	};

	private static final class_2960 texture = new class_2960(ResourcesLib.MODEL_AVATAR);
	private final AvatarModel model;

	public AvatarBlockEntityRenderer(class_5614.class_5615 context) {
		model = new AvatarModel(context.method_32140(BotaniaModelLayers.AVATAR));
	}

	@Override
	public void render(@Nullable AvatarBlockEntity avatar, float pticks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		ms.method_22903();
		class_2350 facing = avatar != null && avatar.method_10997() != null ? avatar.method_11010().method_11654(class_2741.field_12481) : class_2350.field_11035;

		ms.method_22904(0.5F, 1.6F, 0.5F);
		ms.method_22905(1F, -1F, -1F);
		ms.method_22907(class_1160.field_20705.method_23214(ROTATIONS[Math.max(Math.min(ROTATIONS.length - 1, facing.method_10146() - 2), 0)]));
		class_4588 buffer = buffers.getBuffer(model.method_23500(texture));
		model.method_2828(ms, buffer, light, overlay, 1, 1, 1, 1);

		if (avatar != null) {
			class_1799 stack = avatar.getItemHandler().method_5438(0);
			if (!stack.method_7960()) {
				ms.method_22903();
				float s = 0.6F;
				ms.method_22905(s, s, s);
				ms.method_22904(-0.5F, 2F, -0.25F);
				ms.method_22907(class_1160.field_20703.method_23214(-70));
				class_310.method_1551().method_1480().method_23178(stack, class_809.class_811.field_4320,
						light, overlay, ms, buffers, 0);
				ms.method_22909();

				AvatarWieldable wieldable = XplatAbstractions.INSTANCE.findAvatarWieldable(stack);
				if (wieldable != null) {
					buffer = buffers.getBuffer(class_1921.method_23580(wieldable.getOverlayResource(avatar)));
					s = 1.01F;

					ms.method_22903();
					ms.method_22905(s, s, s);
					ms.method_22904(0F, -0.01F, 0F);
					float alpha = (float) Math.sin(ClientTickHandler.ticksInGame / 20D) / 2F + 0.5F;
					model.method_2828(ms, buffer, 0xF000F0, overlay, 1, 1, 1, alpha);
					ms.method_22909();
				}
			}
		}
		ms.method_22909();
	}

}
