/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.block_entity;

import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.block_entity.AnimatedTorchBlockEntity;

import java.util.Random;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_809;
import net.minecraft.class_827;

public class AnimatedTorchBlockEntityRenderer implements class_827<AnimatedTorchBlockEntity> {

	public AnimatedTorchBlockEntityRenderer(class_5614.class_5615 ctx) {}

	@Override
	public void render(AnimatedTorchBlockEntity te, float partialTicks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		class_310 mc = class_310.method_1551();
		ms.method_22903();

		boolean hasWorld = te != null && te.method_10997() != null;
		int wtime = !hasWorld ? 0 : ClientTickHandler.ticksInGame;
		if (wtime != 0) {
			wtime += new Random(te.method_11016().hashCode()).nextInt(360);
		}

		float time = wtime == 0 ? 0 : wtime + partialTicks;
		float xt = 0.5F + (float) Math.cos(time * 0.05F) * 0.025F;
		float yt = 0.1F + (float) (Math.sin(time * 0.04F) + 1F) * 0.05F;
		float zt = 0.5F + (float) Math.sin(time * 0.05F) * 0.025F;
		ms.method_22904(xt, yt, zt);

		ms.method_22905(2, 2, 2);
		ms.method_22907(class_1160.field_20703.method_23214(90));
		float rotation = (float) te.rotation;
		if (te.rotating) {
			rotation += te.anglePerTick * partialTicks;
		}

		ms.method_22907(class_1160.field_20707.method_23214(rotation));
		mc.method_1480().method_23178(new class_1799(class_2246.field_10523), class_809.class_811.field_4318,
				light, overlay, ms, buffers, 0);
		ms.method_22909();
	}

}
