/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.block_entity;

import net.minecraft.class_1058;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.api.state.enums.AlfheimPortalState;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.common.block.block_entity.AlfheimPortalBlockEntity;

public class AlfheimPortalBlockEntityRenderer implements class_827<AlfheimPortalBlockEntity> {

	public AlfheimPortalBlockEntityRenderer(class_5614.class_5615 ctx) {}

	@Override
	public void render(@NotNull AlfheimPortalBlockEntity portal, float f, class_4587 ms, class_4597 buffers, int light, int overlay) {
		AlfheimPortalState state = portal.method_11010().method_11654(BotaniaStateProperties.ALFPORTAL_STATE);
		if (state == AlfheimPortalState.OFF) {
			return;
		}

		float alpha = (float) Math.min(1F, (Math.sin((ClientTickHandler.ticksInGame + f) / 8D) + 1D) / 7D + 0.6D) * (Math.min(60, portal.ticksOpen) / 60F) * 0.5F;

		ms.method_22903();
		if (state == AlfheimPortalState.ON_X) {
			ms.method_22904(0.75, 1, 2);
			ms.method_22907(class_1160.field_20705.method_23214(90));
		} else {
			ms.method_22904(-1, 1, 0.75);
		}
		renderIcon(ms, buffers, MiscellaneousModels.INSTANCE.alfPortalTex.method_24148(), 0, 0, 3, 3, alpha, overlay);
		ms.method_22909();

		ms.method_22903();
		if (state == AlfheimPortalState.ON_X) {
			ms.method_22904(0.25, 1, -1);
			ms.method_22907(class_1160.field_20705.method_23214(90));
		} else {
			ms.method_22904(2, 1, 0.25);
		}
		ms.method_22907(class_1160.field_20705.method_23214(180));
		renderIcon(ms, buffers, MiscellaneousModels.INSTANCE.alfPortalTex.method_24148(), 0, 0, 3, 3, alpha, overlay);
		ms.method_22909();
	}

	public void renderIcon(class_4587 ms, class_4597 buffers, class_1058 icon, int x, int y, int width, int height, float alpha, int overlay) {
		class_4588 buffer = buffers.getBuffer(class_4722.method_29382());
		class_1159 model = ms.method_23760().method_23761();
		class_4581 normal = ms.method_23760().method_23762();
		buffer.method_22918(model, x, y + height, 0).method_22915(1, 1, 1, alpha).method_22913(icon.method_4594(), icon.method_4575()).method_22922(overlay).method_22916(0xF000F0).method_23763(normal, 1, 0, 0).method_1344();
		buffer.method_22918(model, x + width, y + height, 0).method_22915(1, 1, 1, alpha).method_22913(icon.method_4577(), icon.method_4575()).method_22922(overlay).method_22916(0xF000F0).method_23763(normal, 1, 0, 0).method_1344();
		buffer.method_22918(model, x + width, y, 0).method_22915(1, 1, 1, alpha).method_22913(icon.method_4577(), icon.method_4593()).method_22922(overlay).method_22916(0xF000F0).method_23763(normal, 1, 0, 0).method_1344();
		buffer.method_22918(model, x, y, 0).method_22915(1, 1, 1, alpha).method_22913(icon.method_4594(), icon.method_4593()).method_22922(overlay).method_22916(0xF000F0).method_23763(normal, 1, 0, 0).method_1344();
	}

}
