/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.patchouli.processor;

import net.minecraft.class_1860;
import net.minecraft.class_2960;
import vazkii.botania.client.patchouli.PatchouliUtils;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class PetalApothecaryProcessor implements IComponentProcessor {
	protected class_1860<?> recipe;

	@Override
	public void setup(IVariableProvider variables) {
		class_2960 id = new class_2960(variables.get("recipe").asString());
		this.recipe = PatchouliUtils.getRecipe(BotaniaRecipeTypes.PETAL_TYPE, id);
	}

	@Override
	public IVariable process(String key) {
		if (recipe == null) {
			return null;
		}
		return switch (key) {
			case "recipe" -> IVariable.wrap(recipe.method_8114().toString());
			case "output" -> IVariable.from(recipe.method_8110());
			case "heading" -> IVariable.from(recipe.method_8110().method_7964());
			default -> null;
		};
	}
}
