/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.model.armor;

import net.minecraft.class_3532;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5609;
import net.minecraft.class_5610;

public class ElementiumArmorModel {

	public static class_5609 createInsideMesh() {
		var deformation = new class_5605(0.01F);
		var mesh = new class_5609();
		var root = mesh.method_32111();
		root.method_32117("head", class_5606.method_32108(), class_5603.field_27701);
		root.method_32117("hat", class_5606.method_32108(), class_5603.field_27701);
		root.method_32117("left_arm", class_5606.method_32108(), class_5603.field_27701);
		root.method_32117("right_arm", class_5606.method_32108(), class_5603.field_27701);
		var body = root.method_32117("body", class_5606.method_32108()
				.method_32098(-1.0F, 0.0F, -1.0F, 2, 2, 2, deformation), class_5603.field_27701);
		body.method_32117("belt", class_5606.method_32108().method_32101(0, 53)
				.method_32098(-4.5F, 8.0F, -3.0F, 9, 5, 6, deformation), class_5603.field_27701);
		root.method_32117("left_leg", class_5606.method_32108().method_32101(0, 64)
				.method_32096()
				.method_32098(-2.39F, 0.0F, -2.49F, 5, 6, 5, deformation),
				class_5603.method_32090(1.9F, 12.0F, 0.0F));
		root.method_32117("right_leg", class_5606.method_32108().method_32101(0, 64)
				.method_32098(-2.61F, 0.0F, -2.51F, 5, 6, 5, deformation),
				class_5603.method_32090(-1.9F, 12.0F, 0.0F));
		return mesh;
	}

	public static class_5609 createOutsideMesh() {
		var deformation = new class_5605(0.01F);
		var mesh = new class_5609();
		var root = mesh.method_32111();
		var head = root.method_32117("head", class_5606.method_32108()
				.method_32098(-1.0F, -2.0F, 0.0F, 2, 2, 2, deformation), class_5603.field_27701);
		var helm = head.method_32117("helm", class_5606.method_32108()
				.method_32098(-4.5F, -9.0F, -4.5F, 9, 9, 9, deformation), class_5603.field_27701);
		helm.method_32117("helm_fairy", class_5606.method_32108().method_32101(36, 11)
				.method_32098(-2.5F, -10.0F, -5.5F, 5, 5, 5, deformation), class_5603.field_27701);
		helm.method_32117("helm_wing_1l", class_5606.method_32108().method_32101(36, 0)
				.method_32096()
				.method_32098(-1.0F, -5.0F, 0.0F, 1, 5, 6, deformation),
				class_5603.method_32091(4.5F, -6.0F, -0.5F, class_3532.field_29844 / 12, class_3532.field_29844 / 6, class_3532.field_29844 / 12));
		helm.method_32117("helm_wing_2l", class_5606.method_32108().method_32101(50, 0)
				.method_32098(-1.0F, 0.0F, 0.0F, 1, 3, 4, deformation),
				class_5603.method_32091(4.5F, -6.0F, -0.5F, -class_3532.field_29844 / 12, class_3532.field_29844 / 12, -class_3532.field_29844 / 12));
		helm.method_32117("helm_wing_1r", class_5606.method_32108().method_32101(36, 0)
				.method_32098(0.0F, -5.0F, 0.0F, 1, 5, 6, deformation),
				class_5603.method_32091(-4.5F, -6.0F, -0.5F, class_3532.field_29844 / 12, -class_3532.field_29844 / 6, -class_3532.field_29844 / 12));
		helm.method_32117("helm_wing_2r", class_5606.method_32108().method_32101(50, 0)
				.method_32096()
				.method_32098(0.0F, 0.0F, 0.0F, 1, 3, 4, deformation),
				class_5603.method_32091(-4.5F, -6.0F, -0.5F, -class_3532.field_29844 / 12, -class_3532.field_29844 / 12, class_3532.field_29844 / 12));

		var body = root.method_32117("body", class_5606.method_32108()
				.method_32098(-1.0F, 0.0F, -1.0F, 2, 2, 2, deformation), class_5603.field_27701);
		var bodyTop = body.method_32117("body_top", class_5606.method_32108().method_32101(0, 19)
				.method_32098(-4.5F, 0.0F, -3.0F, 9, 6, 6, deformation), class_5603.field_27701);
		bodyTop.method_32117("body_bottom", class_5606.method_32108().method_32101(0, 31)
				.method_32098(-3.5F, 5.0F, -2.5F, 7, 3, 5, deformation), class_5603.field_27701);

		var leftArm = root.method_32117("left_arm", class_5606.method_32108()
				.method_32096()
				.method_32098(0.0F, -1.0F, -1.0F, 2, 2, 2, deformation),
				class_5603.method_32090(4.0F, 2.0F, 0.0F));
		var armL = leftArm.method_32117("left_arm_main", class_5606.method_32108()
				.method_32096()
				.method_32098(0.5F, 4.5F, -2.49F, 3, 6, 5, deformation), class_5603.field_27701);
		var armLpauldron = armL.method_32117("left_arm_pauldron", class_5606.method_32108().method_32101(0, 40)
				.method_32096()
				.method_32098(-0.5F, -3.0F, -3.0F, 6, 7, 6, deformation), class_5603.field_27701);
		armLpauldron.method_32117("left_arm_wing_1", class_5606.method_32108().method_32101(40, 35)
				.method_32098(0.0F, -4.0F, 0.0F, 0, 4, 5, deformation),
				class_5603.method_32091(6.0F, -1.0F, 0.0F, class_3532.field_29844 / 12, class_3532.field_29844 / 6, class_3532.field_29844 / 12));
		armLpauldron.method_32117("left_arm_wing_2", class_5606.method_32108().method_32101(40, 40)
				.method_32098(0.0F, 0.0F, 0.0F, 0, 3, 4, deformation),
				class_5603.method_32091(6.0F, -1.0F, 0.0F, -class_3532.field_29844 / 12, class_3532.field_29844 / 12, -class_3532.field_29844 / 12));

		var rightArm = root.method_32117("right_arm", class_5606.method_32108()
				.method_32096()
				.method_32098(-2.0F, -1.0F, -1.0F, 2, 2, 2, deformation),
				class_5603.method_32090(-4.0F, 2.0F, 0.0F));
		var armR = rightArm.method_32117("right_arm_main", class_5606.method_32108().method_32101(24, 40)
				.method_32098(-3.5F, 4.5F, -2.51F, 3, 6, 5, deformation),
				class_5603.field_27701);
		var armRpauldron = armR.method_32117("right_arm_pauldron", class_5606.method_32108().method_32101(0, 40)
				.method_32098(-5.5F, -3.0F, -3.0F, 6, 7, 6, deformation), class_5603.field_27701);
		armRpauldron.method_32117("right_arm_wing_1", class_5606.method_32108().method_32101(40, 35)
				.method_32096()
				.method_32098(0.0F, -4.0F, 0.0F, 0, 4, 5, deformation),
				class_5603.method_32091(-6.5F, -1.0F, 0.0F, class_3532.field_29844 / 12, -class_3532.field_29844 / 6, -class_3532.field_29844 / 12));
		armRpauldron.method_32117("right_arm_wing_2", class_5606.method_32108().method_32101(40, 40)
				.method_32096()
				.method_32098(0.0F, 0.0F, 0.0F, 0, 3, 4, deformation),
				class_5603.method_32091(-6.5F, -1.0F, 0.0F, -class_3532.field_29844 / 12, -class_3532.field_29844 / 12, class_3532.field_29844 / 12));

		// boots
		var bootL = root.method_32117("left_leg", class_5606.method_32108().method_32101(0, 75)
				.method_32096()
				.method_32098(-2.39F, 8.5F, -2.49F, 5, 5, 5, deformation),
				class_5603.method_32090(1.9F, 12.0F, 0.0F));
		bootL.method_32117("left_boot_wing_1", class_5606.method_32108().method_32101(40, 40)
				.method_32098(0.0F, -3.0F, 0.0F, 0, 3, 4, deformation),
				class_5603.method_32091(2.5F, 8.5F, 0.0F, class_3532.field_29844 / 12, class_3532.field_29844 / 6, class_3532.field_29844 / 12));
		bootL.method_32117("left_boot_wing_2", class_5606.method_32108().method_32101(40, 44)
				.method_32098(0.0F, 0.0F, 0.0F, 0, 2, 3, deformation),
				class_5603.method_32091(2.5F, 8.5F, 0.0F, -class_3532.field_29844 / 12, class_3532.field_29844 / 12, -class_3532.field_29844 / 12));

		var bootR = root.method_32117("right_leg", class_5606.method_32108().method_32101(0, 75)
				.method_32098(-2.61F, 8.5F, -2.51F, 5, 5, 5, deformation),
				class_5603.method_32090(-1.9F, 12.0F, 0.0F));
		bootR.method_32117("right_boot_wing_1", class_5606.method_32108().method_32101(40, 40)
				.method_32096()
				.method_32098(0.0F, -3.0F, 0.0F, 0, 3, 4, deformation),
				class_5603.method_32091(-2.6F, 8.5F, 0.0F, class_3532.field_29844 / 12, -class_3532.field_29844 / 6, -class_3532.field_29844 / 12));
		bootR.method_32117("right_boot_wing_2", class_5606.method_32108().method_32101(40, 44)
				.method_32096()
				.method_32098(0.0F, 0.0F, 0.0F, 0, 2, 3, deformation),
				class_5603.method_32091(-2.5F, 8.5F, 0.0F, -class_3532.field_29844 / 12, -class_3532.field_29844 / 12, class_3532.field_29844 / 12));

		root.method_32117("hat", class_5606.method_32108(), class_5603.field_27701);
		return mesh;
	}
}
