/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.model;

import com.google.common.base.Preconditions;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_1160;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_793;
import net.minecraft.class_801;
import net.minecraft.class_806;
import net.minecraft.class_809;
import net.minecraft.client.resources.model.*;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.common.item.ManaBlasterItem;
import vazkii.botania.common.lib.LibMisc;
import vazkii.botania.mixin.client.ModelBakeryAccessor;

import java.util.*;
import java.util.function.Function;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class ManaBlasterModel implements class_1087 {
	private static final class_1091 DESU = new class_1091(LibMisc.MOD_ID + ":desu_gun", "inventory");
	private static final class_1091 DESU_CLIP = new class_1091(LibMisc.MOD_ID + ":desu_gun_clip", "inventory");

	private final class_1087 originalModel;
	private final class_1087 originalModelClip;
	private final Map<Pair<class_1792, Boolean>, class_1087> cache = new HashMap<>();

	public ManaBlasterModel(class_1088 bakery, class_1087 originalModel, class_1087 originalModelClip) {
		this.originalModel = Preconditions.checkNotNull(originalModel);
		this.originalModelClip = Preconditions.checkNotNull(originalModelClip);

		for (var item : class_2378.field_11142) {
			var lens = item.method_7854();
			if (ManaBlasterItem.isValidLens(lens)) {
				var baked = new CompositeBakedModel(bakery, lens, originalModel);
				var bakedClip = new CompositeBakedModel(bakery, lens, originalModelClip);
				cache.put(Pair.of(item, false), baked);
				cache.put(Pair.of(item, true), bakedClip);
			}
		}
	}

	private final class_806 itemHandler = new class_806() {
		@NotNull
		@Override
		public class_1087 method_3495(class_1087 model, class_1799 stack, @Nullable class_638 worldIn, @Nullable class_1309 entityIn, int seed) {
			boolean clip = ManaBlasterItem.hasClip(stack);

			if (ManaBlasterItem.isSugoiKawaiiDesuNe(stack)) {
				return class_310.method_1551().method_1554().method_4742(clip ? DESU_CLIP : DESU);
			}

			class_1799 lens = ManaBlasterItem.getLens(stack);
			if (!lens.method_7960()) {
				return ManaBlasterModel.this.cache.getOrDefault(Pair.of(lens.method_7909(), clip),
						class_310.method_1551().method_1554().method_4744());
			} else {
				return clip ? originalModelClip : originalModel;
			}
		}
	};

	@NotNull
	@Override
	public class_806 method_4710() {
		return itemHandler;
	}

	@NotNull
	@Override
	public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 side, @NotNull class_5819 rand) {
		return originalModel.method_4707(state, side, rand);
	}

	@Override
	public boolean method_4708() {
		return originalModel.method_4708();
	}

	@Override
	public boolean method_4712() {
		return originalModel.method_4712();
	}

	@Override
	public boolean method_4713() {
		return originalModel.method_4713();
	}

	@NotNull
	@Override
	public class_1058 method_4711() {
		return originalModel.method_4711();
	}

	@NotNull
	@Override
	public class_809 method_4709() {
		return originalModel.method_4709();
	}

	@Override
	public boolean method_24304() {
		return originalModel.method_24304();
	}

	private static class CompositeBakedModel extends DelegatedModel {
		private final List<class_777> genQuads = new ArrayList<>();
		private final Map<class_2350, List<class_777>> faceQuads = new EnumMap<>(class_2350.class);

		CompositeBakedModel(class_1088 bakery, class_1799 lens, class_1087 gun) {
			super(gun);

			class_2960 lensId = class_2378.field_11142.method_10221(lens.method_7909());
			class_1100 lensUnbaked = bakery.method_4726(new class_1091(lensId, "inventory"));
			class_3665 transform = new class_3665() {
				@Override
				public class_4590 method_3509() {
					return new class_4590(new class_1160(-0.4F, 0.2F, 0.0F), class_1160.field_20705.method_23626((float) Math.PI / 2), new class_1160(0.625F, 0.625F, 0.625F), null);
				}
			};
			class_2960 name = prefix("gun_with_" + lensId.toString().replace(':', '_'));

			Function<class_4730, class_1058> textureGetter = ((ModelBakeryAccessor) bakery).getSpriteAtlasManager()::method_24097;
			class_1087 lensBaked;
			if (lensUnbaked instanceof class_793 bm && bm.method_3431() == net.minecraft.class_1088.field_5400) {
				lensBaked = new class_801()
						.method_3479(textureGetter, bm)
						.method_3446(bakery, bm, textureGetter, transform, name, false);
			} else {
				lensBaked = lensUnbaked.method_4753(bakery, textureGetter, transform, name);
			}

			for (class_2350 e : class_2350.values()) {
				faceQuads.put(e, new ArrayList<>());
			}

			var rand = class_5819.method_43047();
			rand.method_43052(0);
			genQuads.addAll(lensBaked.method_4707(null, null, rand));

			for (class_2350 e : class_2350.values()) {
				rand.method_43052(0);
				faceQuads.get(e).addAll(lensBaked.method_4707(null, e, rand));
			}

			// Add gun quads
			rand.method_43052(0);
			genQuads.addAll(gun.method_4707(null, null, rand));
			for (class_2350 e : class_2350.values()) {
				rand.method_43052(0);
				faceQuads.get(e).addAll(gun.method_4707(null, e, rand));
			}
		}

		@NotNull
		@Override
		public List<class_777> method_4707(class_2680 state, class_2350 face, @NotNull class_5819 rand) {
			return face == null ? genQuads : faceQuads.get(face);
		}
	}

}
