/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.integration.jei.crafting;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.crafting.recipe.CompositeLensRecipe;
import vazkii.botania.common.item.lens.LensItem;
import vazkii.botania.common.lib.BotaniaTags;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.StreamSupport;

public class CompositeLensRecipeWrapper implements ICraftingCategoryExtension {
	private final List<class_1792> allLenses;

	public CompositeLensRecipeWrapper(CompositeLensRecipe recipe) {
		allLenses = StreamSupport.stream(class_2378.field_11142.method_40286(BotaniaTags.Items.LENS).spliterator(), false)
				.map(class_1799::new)
				.filter(s -> !((LensItem) s.method_7909()).isControlLens(s))
				.filter(s -> ((LensItem) s.method_7909()).isCombinable(s))
				.map(class_1799::method_7909)
				.toList();
	}

	@Override
	public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull ICraftingGridHelper helper, @NotNull IFocusGroup focusGroup) {
		var possibleFirstLenses = focusGroup.getFocuses(VanillaTypes.ITEM_STACK, RecipeIngredientRole.INPUT)
				.filter(f -> allLenses.contains(f.getTypedValue().getIngredient().method_7909()))
				.map(f -> f.getTypedValue().getIngredient().method_7909())
				.toList();
		if (possibleFirstLenses.isEmpty()) {
			possibleFirstLenses = allLenses;
		}

		List<class_1799> firstInput = new ArrayList<>();
		List<class_1799> secondInput = new ArrayList<>();
		List<class_1799> outputs = new ArrayList<>();

		for (var firstLens : possibleFirstLenses) {
			var firstLensStack = new class_1799(firstLens);
			for (var secondLens : allLenses) {
				if (secondLens == firstLens) {
					continue;
				}

				class_1799 secondLensStack = new class_1799(secondLens);
				if (((LensItem) firstLens).canCombineLenses(firstLensStack, secondLensStack)) {
					firstInput.add(firstLensStack);
					secondInput.add(secondLensStack);
					outputs.add(((LensItem) firstLens).setCompositeLens(firstLensStack.method_7972(), secondLensStack));
				}
			}
		}

		helper.createAndSetInputs(builder, VanillaTypes.ITEM_STACK,
				List.of(firstInput, List.of(new class_1799(class_1802.field_8777)), secondInput), 0, 0);
		helper.createAndSetOutputs(builder, VanillaTypes.ITEM_STACK, outputs);
	}
}
