/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.integration.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.recipe.PetalApothecaryRecipe;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.lib.LibMisc;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class PetalApothecaryRecipeCategory implements IRecipeCategory<PetalApothecaryRecipe> {

	public static final RecipeType<PetalApothecaryRecipe> TYPE = RecipeType.create(LibMisc.MOD_ID, "petals", PetalApothecaryRecipe.class);
	private final IDrawableStatic background;
	private final class_2561 localizedName;
	private final IDrawableStatic overlay;
	private final IDrawable icon;

	public PetalApothecaryRecipeCategory(IGuiHelper guiHelper) {
		background = guiHelper.createBlankDrawable(114, 97);
		localizedName = class_2561.method_43471("botania.nei.petalApothecary");
		overlay = guiHelper.createDrawable(prefix("textures/gui/petal_overlay.png"),
				17, 11, 114, 82);
		icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM_STACK, new class_1799(BotaniaBlocks.defaultAltar));
	}

	@NotNull
	@Override
	public RecipeType<PetalApothecaryRecipe> getRecipeType() {
		return TYPE;
	}

	@NotNull
	@Override
	public class_2561 getTitle() {
		return localizedName;
	}

	@NotNull
	@Override
	public IDrawable getBackground() {
		return background;
	}

	@NotNull
	@Override
	public IDrawable getIcon() {
		return icon;
	}

	@Override
	public void draw(@NotNull PetalApothecaryRecipe recipe, @NotNull IRecipeSlotsView slotsView, @NotNull class_4587 ms, double mouseX, double mouseY) {
		RenderSystem.enableBlend();
		overlay.draw(ms, 0, 4);
		RenderSystem.disableBlend();
	}

	@Override
	public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull PetalApothecaryRecipe recipe, @NotNull IFocusGroup focusGroup) {
		builder.addSlot(RecipeIngredientRole.CATALYST, 48, 45)
				.addItemStack(new class_1799(BotaniaBlocks.defaultAltar));

		double angleBetweenEach = 360.0 / recipe.method_8117().size();
		class_241 point = new class_241(48, 13), center = new class_241(48, 45);

		for (var ingr : recipe.method_8117()) {
			builder.addSlot(RecipeIngredientRole.INPUT, (int) point.field_1343, (int) point.field_1342)
					.addIngredients(ingr);
			point = rotatePointAbout(point, center, angleBetweenEach);
		}

		builder.addSlot(RecipeIngredientRole.OUTPUT, 86, 10)
				.addItemStack(recipe.method_8110());
	}

	public static class_241 rotatePointAbout(class_241 in, class_241 about, double degrees) {
		double rad = degrees * Math.PI / 180.0;
		double newX = Math.cos(rad) * (in.field_1343 - about.field_1343) - Math.sin(rad) * (in.field_1342 - about.field_1342) + about.field_1343;
		double newY = Math.sin(rad) * (in.field_1343 - about.field_1343) + Math.cos(rad) * (in.field_1342 - about.field_1342) + about.field_1342;
		return new class_241((float) newX, (float) newY);
	}
}
