/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.integration.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1058;
import net.minecraft.class_1159;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.recipe.ElvenTradeRecipe;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.lib.LibMisc;
import vazkii.botania.common.lib.ResourceLocationHelper;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class ElvenTradeRecipeCategory implements IRecipeCategory<ElvenTradeRecipe> {

	public static final RecipeType<ElvenTradeRecipe> TYPE = RecipeType.create(LibMisc.MOD_ID, "elven_trade", ElvenTradeRecipe.class);
	private final class_2561 localizedName;
	private final IDrawable background;
	private final IDrawable overlay;
	private final IDrawable icon;

	public ElvenTradeRecipeCategory(IGuiHelper guiHelper) {
		localizedName = class_2561.method_43471("botania.nei.elvenTrade");
		background = guiHelper.createBlankDrawable(145, 95);
		overlay = guiHelper.createDrawable(prefix("textures/gui/elven_trade_overlay.png"), 0, 15, 140, 90);
		icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM_STACK, new class_1799(BotaniaBlocks.alfPortal));
	}

	@NotNull
	@Override
	public RecipeType<ElvenTradeRecipe> getRecipeType() {
		return TYPE;
	}

	@NotNull
	@Override
	public class_2561 getTitle() {
		return localizedName;
	}

	@NotNull
	@Override
	public IDrawable getBackground() {
		return background;
	}

	@NotNull
	@Override
	public IDrawable getIcon() {
		return icon;
	}

	@Override
	public void draw(@NotNull ElvenTradeRecipe recipe, @NotNull IRecipeSlotsView slotsView, @NotNull class_4587 matrices, double mouseX, double mouseY) {
		RenderSystem.enableBlend();
		overlay.draw(matrices, 0, 4);
		RenderSystem.disableBlend();

		RenderSystem.setShaderTexture(0, class_1723.field_21668);
		class_1058 sprite = class_310.method_1551().method_1549(class_1723.field_21668).apply(ResourceLocationHelper.prefix("block/alfheim_portal_swirl"));
		class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
		class_4588 v = immediate.getBuffer(class_1921.method_23577());
		int startX = 22;
		int startY = 25;
		int stopX = 70;
		int stopY = 73;
		class_1159 mat = matrices.method_23760().method_23761();
		class_4581 n = matrices.method_23760().method_23762();
		v.method_22918(mat, startX, startY, 0).method_22915(1f, 1f, 1f, 1f).method_22913(sprite.method_4594(), sprite.method_4593()).method_22916(0xF000F0).method_23763(n, 1, 0, 0).method_1344();
		v.method_22918(mat, startX, stopY, 0).method_22915(1f, 1f, 1f, 1f).method_22913(sprite.method_4594(), sprite.method_4575()).method_22916(0xF000F0).method_23763(n, 1, 0, 0).method_1344();
		v.method_22918(mat, stopX, stopY, 0).method_22915(1f, 1f, 1f, 1f).method_22913(sprite.method_4577(), sprite.method_4575()).method_22916(0xF000F0).method_23763(n, 1, 0, 0).method_1344();
		v.method_22918(mat, stopX, startY, 0).method_22915(1f, 1f, 1f, 1f).method_22913(sprite.method_4577(), sprite.method_4593()).method_22916(0xF000F0).method_23763(n, 1, 0, 0).method_1344();
		immediate.method_22993();

	}

	@Override
	public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull ElvenTradeRecipe recipe, @NotNull IFocusGroup focusGroup) {
		int posX = 42;
		for (var ingr : recipe.method_8117()) {
			builder.addSlot(RecipeIngredientRole.INPUT, posX, 0)
					.addIngredients(ingr);
			posX += 18;
		}

		int outIdx = 0;
		for (var stack : recipe.getOutputs()) {
			builder.addSlot(RecipeIngredientRole.OUTPUT, 93 + outIdx % 2 * 20, 41 + outIdx / 2 * 20)
					.addItemStack(stack);
			outIdx++;
		}
	}
}
