/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.gui.bag;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.common.block.BotaniaBlocks;

public class FlowerPouchGui extends class_465<FlowerPouchContainer> {

	private static final class_2960 texture = new class_2960(ResourcesLib.GUI_FLOWER_BAG);

	public FlowerPouchGui(FlowerPouchContainer container, class_1661 playerInv, class_2561 title) {
		super(container, playerInv, title);
		field_2779 += 36;

		// recompute, same as super
		field_25270 = field_2779 - 94;
	}

	@Override
	public void method_25394(class_4587 ms, int mouseX, int mouseY, float partialTicks) {
		this.method_25420(ms);
		super.method_25394(ms, mouseX, mouseY, partialTicks);
		this.method_2380(ms, mouseX, mouseY);
	}

	@Override
	protected void method_2389(class_4587 ms, float partialTicks, int mouseX, int mouseY) {
		class_310 mc = class_310.method_1551();
		RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
		RenderSystem.setShaderTexture(0, texture);
		int k = (field_22789 - field_2792) / 2;
		int l = (field_22790 - field_2779) / 2;
		method_25302(ms, k, l, 0, 0, field_2792, field_2779);

		for (class_1735 slot : field_2797.field_7761) {
			if (slot.field_7871 == field_2797.flowerBagInv && !slot.method_7681()) {
				class_1799 stack;
				if (slot.field_7874 < 16) {
					var color = class_1767.method_7791(slot.field_7874);
					stack = new class_1799(BotaniaBlocks.getFlower(color));
				} else {
					var color = class_1767.method_7791(slot.field_7874 - 16);
					stack = new class_1799(BotaniaBlocks.getDoubleFlower(color));
				}

				int x = this.field_2776 + slot.field_7873;
				int y = this.field_2800 + slot.field_7872;
				mc.method_1480().method_4010(stack, x, y);
				ms.method_22903();
				ms.method_22904(0, 0, mc.method_1480().field_4730 + 200); // similar to ItemRenderer.renderGuiItemDecorations
				mc.field_1772.method_1720(ms, "0", x + 11, y + 9, 0xFF6666);
				ms.method_22909();
			}
		}
	}

}
