/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.gui.bag;

import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.gui.SlotLocked;
import vazkii.botania.common.block.BotaniaDoubleFlowerBlock;
import vazkii.botania.common.block.BotaniaFlowerBlock;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.FlowerPouchItem;

public class FlowerPouchContainer extends class_1703 {
	public static FlowerPouchContainer fromNetwork(int windowId, class_1661 inv, class_2540 buf) {
		class_1268 hand = buf.readBoolean() ? class_1268.field_5808 : class_1268.field_5810;
		return new FlowerPouchContainer(windowId, inv, inv.field_7546.method_5998(hand));
	}

	private final class_1799 bag;
	public final class_1263 flowerBagInv;

	public FlowerPouchContainer(int windowId, class_1661 playerInv, class_1799 bag) {
		super(BotaniaItems.FLOWER_BAG_CONTAINER, windowId);

		this.bag = bag;
		if (!playerInv.field_7546.field_6002.field_9236) {
			flowerBagInv = FlowerPouchItem.getInventory(bag);
		} else {
			flowerBagInv = new class_1277(FlowerPouchItem.SIZE);
		}

		for (int row = 0; row < 4; ++row) {
			for (int col = 0; col < 8; ++col) {
				int slot = col + row * 8;
				method_7621(new class_1735(flowerBagInv, slot, 17 + col * 18, 26 + row * 18) {
					@Override
					public boolean method_7680(@NotNull class_1799 stack) {
						return FlowerPouchItem.isValid(this.method_34266(), stack);
					}
				});
			}
		}

		for (int row = 0; row < 3; ++row) {
			for (int col = 0; col < 9; ++col) {
				method_7621(new class_1735(playerInv, col + row * 9 + 9, 8 + col * 18, 120 + row * 18));
			}
		}

		for (int i = 0; i < 9; ++i) {
			if (playerInv.method_5438(i) == bag) {
				method_7621(new SlotLocked(playerInv, i, 8 + i * 18, 178));
			} else {
				method_7621(new class_1735(playerInv, i, 8 + i * 18, 178));
			}
		}

	}

	@Override
	public boolean method_7597(@NotNull class_1657 player) {
		class_1799 main = player.method_6047();
		class_1799 off = player.method_6079();
		return !main.method_7960() && main == bag || !off.method_7960() && off == bag;
	}

	@NotNull
	@Override
	public class_1799 method_7601(class_1657 player, int slotIndex) {
		class_1799 itemstack = class_1799.field_8037;
		class_1735 slot = field_7761.get(slotIndex);

		if (slot.method_7681()) {
			class_1799 itemstack1 = slot.method_7677();
			itemstack = itemstack1.method_7972();

			if (slotIndex < 32) {
				if (!method_7616(itemstack1, 32, 68, true)) {
					return class_1799.field_8037;
				}
			} else {
				class_2248 b = class_2248.method_9503(itemstack.method_7909());
				int slotId = -1;
				if (b instanceof BotaniaDoubleFlowerBlock flower) {
					slotId = 16 + flower.color.method_7789();
				} else if (b instanceof BotaniaFlowerBlock flower) {
					slotId = flower.color.method_7789();
				}
				if (slotId >= 0 && slotId < 32) {
					class_1735 destination = field_7761.get(slotId);
					if (destination.method_7680(itemstack) && !method_7616(itemstack1, slotId, slotId + 1, true)) {
						return class_1799.field_8037;
					}
				}
			}

			if (itemstack1.method_7960()) {
				slot.method_7673(class_1799.field_8037);
			} else {
				slot.method_7668();
			}

			if (itemstack1.method_7947() == itemstack.method_7947()) {
				return class_1799.field_8037;
			}

			slot.method_7667(player, itemstack1);
		}

		return itemstack;
	}

}
