/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.gui;

import net.minecraft.class_1074;
import net.minecraft.class_1159;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;

public class ManaBarTooltipComponent implements class_5684 {
	private final float percentageFull;
	private final int pickLevel;

	private int mouseX, mouseY;
	// The total width of the tooltip box we're inside of, not to be confused
	// with the self-reported width of the component (getWidth).
	private int totalWidth;

	public ManaBarTooltipComponent(ManaBarTooltip component) {
		this.percentageFull = component.getPercentageFull();
		this.pickLevel = component.getPickLevel();
	}

	@Nullable
	public static class_5684 tryConvert(class_5632 component) {
		if (component instanceof ManaBarTooltip t) {
			return new ManaBarTooltipComponent(t);
		}
		return null;
	}

	@Override
	public int method_32661() {
		return 0;
	}

	@Override
	public int method_32664(class_327 font) {
		return 0;
	}

	public void setContext(int mouseX, int mouseY, int totalWidth) {
		this.mouseX = mouseX;
		this.mouseY = mouseY;
		this.totalWidth = totalWidth;
	}

	@Override
	public void method_32665(class_327 font, int x, int y, class_1159 matrix, class_4597.class_4598 buffers) {
		int level = pickLevel;
		if (level < 0) {
			return;
		}

		boolean ss = level >= TerraShattererItem.LEVELS.length - 1;
		String rank = class_1074.method_4662("botania.rank" + pickLevel).replaceAll("&", "\u00a7");

		font.method_27521(rank, mouseX, mouseY - 16, 0xFFFFFF, true, matrix, buffers, false, 0, 0xF000F0);
		if (!ss) {
			rank = class_1074.method_4662("botania.rank" + (level + 1)).replaceAll("&", "\u00a7");
			font.method_27521(rank, mouseX + totalWidth - font.method_1727(rank), mouseY - 16, 0xFFFFFF, true, matrix, buffers, false, 0, 0xF000F0);
		}
	}

	@Override
	public void method_32666(class_327 font, int x, int y, class_4587 ps, class_918 renderer, int z) {
		int height = 3;
		int offsetFromBox = 4;

		ps.method_22903();
		ps.method_22904(0, 0, z);

		if (pickLevel >= 0) {
			boolean ss = pickLevel >= TerraShattererItem.LEVELS.length - 1;

			int rainbowWidth = Math.min(totalWidth - (ss ? 0 : 1), (int) (totalWidth * percentageFull));
			float huePer = totalWidth == 0 ? 0F : 1F / totalWidth;
			float hueOff = (ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) * 0.01F;

			class_332.method_25294(ps, mouseX - 1, mouseY - height - offsetFromBox - 1, mouseX + totalWidth + 1, mouseY - offsetFromBox, 0xFF000000);
			for (int i = 0; i < rainbowWidth; i++) {
				class_332.method_25294(ps, mouseX + i, mouseY - height - offsetFromBox, mouseX + i + 1, mouseY - offsetFromBox, 0xFF000000 | class_3532.method_15369((hueOff + huePer * i) % 1F, 1F, 1F));
			}
			class_332.method_25294(ps, mouseX + rainbowWidth, mouseY - height - offsetFromBox, mouseX + totalWidth, mouseY - offsetFromBox, 0xFF555555);
		} else {
			int manaBarWidth = (int) Math.ceil(totalWidth * percentageFull);

			class_332.method_25294(ps, mouseX - 1, mouseY - height - offsetFromBox - 1, mouseX + totalWidth + 1, mouseY - offsetFromBox, 0xFF000000);
			class_332.method_25294(ps, mouseX, mouseY - height - offsetFromBox, mouseX + manaBarWidth, mouseY - offsetFromBox, 0xFF000000 | class_3532.method_15369(0.528F, ((float) Math.sin((ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) * 0.2) + 1F) * 0.3F + 0.4F, 1F));
			class_332.method_25294(ps, mouseX + manaBarWidth, mouseY - height - offsetFromBox, mouseX + totalWidth, mouseY - offsetFromBox, 0xFF555555);
		}
		ps.method_22909();

		// Reset these after we're done each frame so it's obvious if things ever glitch out.
		mouseX = mouseY = 0;
		totalWidth = 50;
	}
}
