/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.gui;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.systems.RenderSystem;
import org.lwjgl.opengl.GL11;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.recipe.ManaInfusionRecipe;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.PetalApothecaryBlockEntity;
import vazkii.botania.common.block.block_entity.RunicAltarBlockEntity;
import vazkii.botania.common.block.block_entity.corporea.CorporeaCrystalCubeBlockEntity;
import vazkii.botania.common.block.block_entity.corporea.CorporeaIndexBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.AssemblyHaloItem;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.WorldshaperssSextantItem;
import vazkii.botania.common.item.equipment.bauble.FlugelTiaraItem;
import vazkii.botania.common.item.equipment.bauble.ManaseerMonocleItem;
import vazkii.botania.common.item.equipment.bauble.RingOfDexterousMotionItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.ClientXplatAbstractions;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3965;
import net.minecraft.class_408;
import net.minecraft.class_4587;

public final class HUDHandler {

	private HUDHandler() {}

	public static final class_2960 manaBar = new class_2960(ResourcesLib.GUI_MANA_HUD);

	public static void onDrawScreenPost(class_4587 ms, float partialTicks) {
		class_310 mc = class_310.method_1551();
		if (mc.field_1690.field_1842) {
			return;
		}
		class_3695 profiler = mc.method_16011();
		class_1799 main = mc.field_1724.method_6047();
		class_1799 offhand = mc.field_1724.method_6079();

		profiler.method_15396("botania-hud");

		if (class_310.method_1551().field_1761.method_2908()) {
			class_1799 tiara = EquipmentHandler.findOrEmpty(BotaniaItems.flightTiara, mc.field_1724);
			if (!tiara.method_7960()) {
				profiler.method_15396("flugelTiara");
				FlugelTiaraItem.ClientLogic.renderHUD(ms, mc.field_1724, tiara);
				profiler.method_15407();
			}

			class_1799 dodgeRing = EquipmentHandler.findOrEmpty(BotaniaItems.dodgeRing, mc.field_1724);
			if (!dodgeRing.method_7960()) {
				profiler.method_15396("dodgeRing");
				RingOfDexterousMotionItem.ClientLogic.renderHUD(ms, mc.field_1724, dodgeRing, partialTicks);
				profiler.method_15407();
			}
		}

		class_239 pos = mc.field_1765;

		if (pos instanceof class_3965 result) {
			class_2338 bpos = result.method_17777();

			class_2680 state = mc.field_1687.method_8320(bpos);
			class_2586 tile = mc.field_1687.method_8321(bpos);

			if (PlayerHelper.hasAnyHeldItem(mc.field_1724)) {
				if (PlayerHelper.hasHeldItemClass(mc.field_1724, WandOfTheForestItem.class)) {
					var hud = ClientXplatAbstractions.INSTANCE.findWandHud(mc.field_1687, bpos, state, tile);
					if (hud != null) {
						profiler.method_15396("wandItem");
						hud.renderHUD(ms, mc);
						profiler.method_15407();
					}
				}
				if (tile instanceof ManaPoolBlockEntity pool && !mc.field_1724.method_6047().method_7960()) {
					renderPoolRecipeHUD(ms, pool, mc.field_1724.method_6047());
				}
			}
			if (!PlayerHelper.hasHeldItem(mc.field_1724, BotaniaItems.lexicon)) {
				if (tile instanceof PetalApothecaryBlockEntity altar) {
					PetalApothecaryBlockEntity.Hud.render(altar, ms, mc);
				} else if (tile instanceof RunicAltarBlockEntity runeAltar) {
					RunicAltarBlockEntity.Hud.render(runeAltar, ms, mc);
				} else if (tile instanceof CorporeaCrystalCubeBlockEntity cube) {
					CorporeaCrystalCubeBlockEntity.Hud.render(ms, cube);
				}
			}
		}

		if (!CorporeaIndexBlockEntity.getNearbyValidIndexes(mc.field_1724).isEmpty() && mc.field_1755 instanceof class_408) {
			profiler.method_15396("nearIndex");
			renderNearIndexDisplay(ms);
			profiler.method_15407();
		}

		if (!main.method_7960() && main.method_7909() instanceof AssemblyHaloItem) {
			profiler.method_15396("craftingHalo_main");
			AssemblyHaloItem.Rendering.renderHUD(ms, mc.field_1724, main);
			profiler.method_15407();
		} else if (!offhand.method_7960() && offhand.method_7909() instanceof AssemblyHaloItem) {
			profiler.method_15396("craftingHalo_off");
			AssemblyHaloItem.Rendering.renderHUD(ms, mc.field_1724, offhand);
			profiler.method_15407();
		}

		if (!main.method_7960() && main.method_7909() instanceof WorldshaperssSextantItem) {
			profiler.method_15396("sextant");
			WorldshaperssSextantItem.Hud.render(ms, mc.field_1724, main);
			profiler.method_15407();
		}

		/*if(equippedStack != null && equippedStack.is(BotaniaItems.flugelEye)) {
			profiler.startSection("flugelEye");
			EyeOfTheFlugelItem.renderHUD(event.getResolution(), mc.player, equippedStack);
			profiler.endSection();
		}*/

		if (ManaseerMonocleItem.hasMonocle(mc.field_1724)) {
			profiler.method_15396("monocle");
			ManaseerMonocleItem.Hud.render(ms, mc.field_1724);
			profiler.method_15407();
		}

		profiler.method_15396("manaBar");

		class_1657 player = mc.field_1724;
		if (!player.method_7325()) {
			int totalMana = 0;
			int totalMaxMana = 0;
			boolean anyRequest = false;

			class_1263 mainInv = player.method_31548();
			class_1263 accInv = BotaniaAPI.instance().getAccessoriesInventory(player);

			int invSize = mainInv.method_5439();
			int size = invSize + accInv.method_5439();

			for (int i = 0; i < size; i++) {
				boolean useAccessories = i >= invSize;
				class_1263 inv = useAccessories ? accInv : mainInv;
				class_1799 stack = inv.method_5438(i - (useAccessories ? invSize : 0));

				if (!stack.method_7960()) {
					anyRequest = anyRequest || stack.method_31573(BotaniaTags.Items.MANA_USING_ITEMS);
				}
			}

			List<class_1799> items = ManaItemHandler.instance().getManaItems(player);
			List<class_1799> acc = ManaItemHandler.instance().getManaAccesories(player);
			for (class_1799 stack : Iterables.concat(items, acc)) {
				var manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
				if (!manaItem.isNoExport()) {
					totalMana += manaItem.getMana();
					totalMaxMana += manaItem.getMaxMana();
				}
			}

			if (anyRequest) {
				renderManaInvBar(ms, totalMana, totalMaxMana);
			}
		}

		profiler.method_15405("itemsRemaining");
		ItemsRemainingRenderHandler.render(ms, partialTicks);
		profiler.method_15407();
		profiler.method_15407();

		RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
	}

	private static void renderManaInvBar(class_4587 ms, int totalMana, int totalMaxMana) {
		class_310 mc = class_310.method_1551();
		int width = 182;
		int x = mc.method_22683().method_4486() / 2 - width / 2;
		int y = mc.method_22683().method_4502() - BotaniaConfig.client().manaBarHeight();

		if (totalMaxMana == 0) {
			width = 0;
		} else {
			width *= (double) totalMana / (double) totalMaxMana;
		}

		if (width == 0) {
			if (totalMana > 0) {
				width = 1;
			} else {
				return;
			}
		}

		int color = class_3532.method_15369(0.55F, (float) Math.min(1F, Math.sin(class_156.method_658() / 200D) * 0.5 + 1F), 1F);
		int r = (color >> 16 & 0xFF);
		int g = (color >> 8 & 0xFF);
		int b = color & 0xFF;
		RenderSystem.setShaderColor(r / 255F, g / 255F, b / 255F, 1 - (r / 255F));
		RenderSystem.setShaderTexture(0, manaBar);

		RenderSystem.enableBlend();
		RenderSystem.blendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		RenderHelper.drawTexturedModalRect(ms, x, y, 0, 251, width, 5);
		RenderSystem.disableBlend();
		RenderSystem.setShaderColor(1, 1, 1, 1);
	}

	private static void renderPoolRecipeHUD(class_4587 ms, ManaPoolBlockEntity tile, class_1799 stack) {
		class_310 mc = class_310.method_1551();
		class_3695 profiler = mc.method_16011();

		profiler.method_15396("poolRecipe");
		ManaInfusionRecipe recipe = tile.getMatchingRecipe(stack, tile.method_10997().method_8320(tile.method_11016().method_10074()));
		if (recipe != null) {
			int x = mc.method_22683().method_4486() / 2 - 11;
			int y = mc.method_22683().method_4502() / 2 + 10;

			int u = tile.getCurrentMana() >= recipe.getManaToConsume() ? 0 : 22;
			int v = mc.field_1724.method_5477().getString().equals("haighyorkie") && mc.field_1724.method_5715() ? 23 : 8;

			RenderSystem.enableBlend();
			RenderSystem.blendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);

			RenderSystem.setShaderTexture(0, manaBar);
			RenderHelper.drawTexturedModalRect(ms, x, y, u, v, 22, 15);
			RenderSystem.setShaderColor(1F, 1F, 1F, 1F);

			mc.method_1480().method_4023(stack, x - 20, y);
			mc.method_1480().method_4023(recipe.method_8110(), x + 26, y);
			mc.method_1480().method_4025(mc.field_1772, recipe.method_8110(), x + 26, y);

			RenderSystem.disableBlend();
		}
		profiler.method_15407();
	}

	private static void renderNearIndexDisplay(class_4587 ms) {
		class_310 mc = class_310.method_1551();
		String txt0 = class_1074.method_4662("botaniamisc.nearIndex0");
		String txt1 = class_124.field_1080 + class_1074.method_4662("botaniamisc.nearIndex1");
		String txt2 = class_124.field_1080 + class_1074.method_4662("botaniamisc.nearIndex2");

		int l = Math.max(mc.field_1772.method_1727(txt0), Math.max(mc.field_1772.method_1727(txt1), mc.field_1772.method_1727(txt2))) + 20;
		int x = mc.method_22683().method_4486() - l - 20;
		int y = mc.method_22683().method_4502() - 60;

		class_332.method_25294(ms, x - 6, y - 6, x + l + 6, y + 37, 0x44000000);
		class_332.method_25294(ms, x - 4, y - 4, x + l + 4, y + 35, 0x44000000);
		mc.method_1480().method_4023(new class_1799(BotaniaBlocks.corporeaIndex), x, y + 10);

		mc.field_1772.method_1720(ms, txt0, x + 20, y, 0xFFFFFF);
		mc.field_1772.method_1720(ms, txt1, x + 20, y + 14, 0xFFFFFF);
		mc.field_1772.method_1720(ms, txt2, x + 20, y + 24, 0xFFFFFF);
	}

	public static void drawSimpleManaHUD(class_4587 ms, int color, int mana, int maxMana, String name) {
		RenderSystem.enableBlend();
		RenderSystem.blendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		class_310 mc = class_310.method_1551();
		int x = mc.method_22683().method_4486() / 2 - mc.field_1772.method_1727(name) / 2;
		int y = mc.method_22683().method_4502() / 2 + 10;

		mc.field_1772.method_1720(ms, name, x, y, color);

		x = mc.method_22683().method_4486() / 2 - 51;
		y += 10;

		renderManaBar(ms, x, y, color, 1F, mana, maxMana);

		RenderSystem.disableBlend();
	}

	public static void drawComplexManaHUD(int color, class_4587 ms, int mana, int maxMana, String name, class_1799 bindDisplay, boolean properlyBound) {
		drawSimpleManaHUD(ms, color, mana, maxMana, name);

		class_310 mc = class_310.method_1551();

		int x = mc.method_22683().method_4486() / 2 + 55;
		int y = mc.method_22683().method_4502() / 2 + 12;

		mc.method_1480().method_4023(bindDisplay, x, y);

		RenderSystem.disableDepthTest();
		ms.method_22903();
		// renderAndDecorateItem draws at blitOffset + 50, + 200 (further down the call stack).
		// We want the checkmark on top of that. yeah these numbers are pretty arbitrary and dumb
		ms.method_22904(0, 0, mc.method_1480().field_4730 + 50 + 200 + 1);
		if (properlyBound) {
			mc.field_1772.method_1720(ms, "\u2714", x + 10, y + 9, 0x004C00);
			mc.field_1772.method_1720(ms, "\u2714", x + 10, y + 8, 0x0BD20D);
		} else {
			mc.field_1772.method_1720(ms, "\u2718", x + 10, y + 9, 0x4C0000);
			mc.field_1772.method_1720(ms, "\u2718", x + 10, y + 8, 0xD2080D);
		}
		ms.method_22909();
		RenderSystem.enableDepthTest();
	}

	public static void renderManaBar(class_4587 ms, int x, int y, int color, float alpha, int mana, int maxMana) {
		class_310 mc = class_310.method_1551();

		RenderSystem.setShaderColor(1F, 1F, 1F, alpha);
		RenderSystem.setShaderTexture(0, manaBar);
		RenderHelper.drawTexturedModalRect(ms, x, y, 0, 0, 102, 5);

		int manaPercentage = Math.max(0, (int) ((double) mana / (double) maxMana * 100));

		if (manaPercentage == 0 && mana > 0) {
			manaPercentage = 1;
		}

		RenderHelper.drawTexturedModalRect(ms, x + 1, y + 1, 0, 5, 100, 3);

		float red = (color >> 16 & 0xFF) / 255F;
		float green = (color >> 8 & 0xFF) / 255F;
		float blue = (color & 0xFF) / 255F;
		RenderSystem.setShaderColor(red, green, blue, alpha);
		RenderHelper.drawTexturedModalRect(ms, x + 1, y + 1, 0, 5, Math.min(100, manaPercentage), 3);
		RenderSystem.setShaderColor(1, 1, 1, 1);
	}
}
