/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.fx;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1044;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3999;
import net.minecraft.class_4003;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

import vazkii.botania.xplat.ClientXplatAbstractions;

public class FXWisp extends class_4003 {
	private final boolean depthTest;
	private final float moteParticleScale;
	private final int moteHalfLife;

	public FXWisp(class_638 world, double d, double d1, double d2, double xSpeed, double ySpeed, double zSpeed,
			float size, float red, float green, float blue, boolean depthTest, float maxAgeMul, boolean noClip) {
		super(world, d, d1, d2, 0, 0, 0);
		// super applies wiggle to motion so set it here instead
		field_3852 = xSpeed;
		field_3869 = ySpeed;
		field_3850 = zSpeed;
		field_3861 = red;
		field_3842 = green;
		field_3859 = blue;
		field_3841 = 0.375F;
		field_3844 = 0;
		field_17867 = (this.field_3840.method_43057() * 0.5F + 0.5F) * 2.0F * size;
		moteParticleScale = field_17867;
		field_3847 = (int) (28D / (Math.random() * 0.3D + 0.7D) * maxAgeMul);
		this.depthTest = depthTest;

		moteHalfLife = field_3847 / 2;
		method_3080(0.01F, 0.01F);

		field_3858 = field_3874;
		field_3838 = field_3854;
		field_3856 = field_3871;
		this.field_3862 = !noClip;
	}

	@Override
	public float method_18132(float p_217561_1_) {
		float agescale = (float) field_3866 / (float) moteHalfLife;
		if (agescale > 1F) {
			agescale = 2 - agescale;
		}

		field_17867 = moteParticleScale * agescale * 0.5F;
		return field_17867;
	}

	@Override
	protected int method_3068(float partialTicks) {
		return 0xF000F0;
	}

	@NotNull
	@Override
	public class_3999 method_18122() {
		return depthTest ? NORMAL_RENDER : DIW_RENDER;
	}

	// [VanillaCopy] of super, without drag when onGround is true
	@Override
	public void method_3070() {
		this.field_3858 = this.field_3874;
		this.field_3838 = this.field_3854;
		this.field_3856 = this.field_3871;

		if (this.field_3866++ >= this.field_3847) {
			this.method_3085();
		}

		this.field_3869 -= 0.04D * (double) this.field_3844;
		this.method_3069(this.field_3852, this.field_3869, this.field_3850);
		this.field_3852 *= 0.9800000190734863D;
		this.field_3869 *= 0.9800000190734863D;
		this.field_3850 *= 0.9800000190734863D;
	}

	public void setGravity(float value) {
		field_3844 = value;
	}

	private static void beginRenderCommon(class_287 bufferBuilder, class_1060 textureManager) {
		class_310.method_1551().field_1773.method_22974().method_3316();
		RenderSystem.depthMask(false);
		RenderSystem.enableBlend();
		RenderSystem.blendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE);

		RenderSystem.setShaderTexture(0, class_1059.field_17898);
		class_1044 tex = textureManager.method_4619(class_1059.field_17898);
		ClientXplatAbstractions.INSTANCE.setFilterSave(tex, true, false);
		bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1584);
	}

	private static void endRenderCommon() {
		class_1044 tex = class_310.method_1551().method_1531().method_4619(class_1059.field_17898);
		ClientXplatAbstractions.INSTANCE.restoreLastFilter(tex);
		RenderSystem.disableBlend();
		RenderSystem.depthMask(true);
	}

	public static final class_3999 NORMAL_RENDER = new class_3999() {
		@Override
		public void method_18130(class_287 bufferBuilder, class_1060 textureManager) {
			beginRenderCommon(bufferBuilder, textureManager);
			RenderSystem.enableDepthTest();
		}

		@Override
		public void method_18131(class_289 tessellator) {
			tessellator.method_1350();
			endRenderCommon();
		}

		@Override
		public String toString() {
			return "botania:wisp";
		}
	};

	public static final class_3999 DIW_RENDER = new class_3999() {
		@Override
		public void method_18130(class_287 bufferBuilder, class_1060 textureManager) {
			beginRenderCommon(bufferBuilder, textureManager);
			RenderSystem.disableDepthTest();
		}

		@Override
		public void method_18131(class_289 tessellator) {
			tessellator.method_1350();
			RenderSystem.enableDepthTest();
			endRenderCommon();
		}

		@Override
		public String toString() {
			return "botania:depth_ignoring_wisp";
		}
	};
}
