/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.core.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1921.class_4688.class_4689;
import net.minecraft.class_2350;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_4696;
import net.minecraft.class_4722;
import net.minecraft.class_5819;
import net.minecraft.class_757;
import net.minecraft.class_777;
import net.minecraft.class_809;
import net.minecraft.class_840;
import net.minecraft.class_918;
import net.minecraft.client.renderer.*;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.client.render.block_entity.PylonBlockEntityRenderer;
import vazkii.botania.common.item.equipment.bauble.FlugelTiaraItem;
import vazkii.botania.mixin.client.ItemRendererAccessor;
import vazkii.botania.mixin.client.RenderTypeAccessor;

import java.util.Arrays;
import java.util.List;
import java.util.OptionalDouble;
import java.util.Random;
import java.util.function.Function;

public final class RenderHelper extends class_1921 {
	private static final class_1921 STAR;
	public static final class_1921 RECTANGLE;
	public static final class_1921 CIRCLE;
	public static final class_1921 RED_STRING;
	public static final class_1921 LINE_1_NO_DEPTH;
	public static final class_1921 LINE_4_NO_DEPTH;
	public static final class_1921 LINE_5_NO_DEPTH;
	public static final class_1921 LINE_8_NO_DEPTH;
	public static final class_1921 SPARK;
	public static final class_1921 LIGHT_RELAY;
	public static final class_1921 ICON_OVERLAY;
	public static final class_1921 BABYLON_ICON;
	public static final class_1921 MANA_POOL_WATER;
	public static final class_1921 TERRA_PLATE;
	public static final class_1921 ENCHANTER;
	public static final class_1921 HALO;
	public static final class_1921 MANA_PYLON_GLOW = getPylonGlow("mana_pylon_glow", PylonBlockEntityRenderer.MANA_TEXTURE);
	public static final class_1921 NATURA_PYLON_GLOW = getPylonGlow("natura_pylon_glow", PylonBlockEntityRenderer.NATURA_TEXTURE);
	public static final class_1921 GAIA_PYLON_GLOW = getPylonGlow("gaia_pylon_glow", PylonBlockEntityRenderer.GAIA_TEXTURE);
	public static final class_1921 MANA_PYLON_GLOW_DIRECT = getPylonGlowDirect("mana_pylon_glow_direct", PylonBlockEntityRenderer.MANA_TEXTURE);
	public static final class_1921 NATURA_PYLON_GLOW_DIRECT = getPylonGlowDirect("natura_pylon_glow_direct", PylonBlockEntityRenderer.NATURA_TEXTURE);
	public static final class_1921 GAIA_PYLON_GLOW_DIRECT = getPylonGlowDirect("gaia_pylon_glow_direct", PylonBlockEntityRenderer.GAIA_TEXTURE);

	public static final class_1921 ASTROLABE_PREVIEW = new AstrolabeLayer();
	public static final class_1921 STARFIELD;
	public static final class_1921 LIGHTNING;

	private static class_1921 makeLayer(String name, class_293 format, class_293.class_5596 mode,
			int bufSize, boolean hasCrumbling, boolean sortOnUpload, class_4688 glState) {
		return RenderTypeAccessor.create(name, format, mode, bufSize, hasCrumbling, sortOnUpload, glState);
	}

	private static class_1921 makeLayer(String name, class_293 format, class_293.class_5596 mode,
			int bufSize, class_4688 glState) {
		return makeLayer(name, format, mode, bufSize, false, false, glState);
	}

	static {
		class_1921.class_4688 glState = class_1921.class_4688.method_23598()
				.method_34578(field_29442)
				.method_23616(field_21350)
				.method_23615(class_4668.field_21367)
				.method_23617(false);
		STAR = makeLayer(ResourcesLib.PREFIX_MOD + "star", class_290.field_1576, class_293.class_5596.field_27379, 256, false, false, glState);

		glState = class_1921.class_4688.method_23598()
				.method_34578(field_29442)
				.method_23615(field_21370)
				.method_23610(field_25643)
				.method_23603(field_21345)
				.method_23617(false);
		RECTANGLE = makeLayer(ResourcesLib.PREFIX_MOD + "rectangle_highlight", class_290.field_1576, class_293.class_5596.field_27382, 256, false, true, glState);
		CIRCLE = makeLayer(ResourcesLib.PREFIX_MOD + "circle_highlight", class_290.field_1576, class_293.class_5596.field_27379, 256, false, false, glState);

		RED_STRING = makeLayer(ResourcesLib.PREFIX_MOD + "red_string", class_290.field_29337, class_293.class_5596.field_27377, 128, lineState(1, false, false));
		LINE_1_NO_DEPTH = makeLayer(ResourcesLib.PREFIX_MOD + "line_1_no_depth", class_290.field_29337, class_293.class_5596.field_27377, 128, lineState(1, true, true));
		LINE_4_NO_DEPTH = makeLayer(ResourcesLib.PREFIX_MOD + "line_4_no_depth", class_290.field_29337, class_293.class_5596.field_27377, 128, lineState(4, true, true));
		LINE_5_NO_DEPTH = makeLayer(ResourcesLib.PREFIX_MOD + "line_5_no_depth", class_290.field_29337, class_293.class_5596.field_27377, 64, lineState(5, true, true));
		LINE_8_NO_DEPTH = makeLayer(ResourcesLib.PREFIX_MOD + "line_8_no_depth", class_290.field_29337, class_293.class_5596.field_27377, 64, lineState(8, true, true));

		glState = class_1921.class_4688.method_23598()
				.method_34578(field_29441)
				.method_34577(class_4668.field_21376)
				.method_23615(field_21370)
				.method_23610(field_25643)
				.method_23608(field_21383).method_23617(true);
		SPARK = makeLayer(ResourcesLib.PREFIX_MOD + "spark", class_290.field_20888, class_293.class_5596.field_27382, 256, glState);
		glState = class_1921.class_4688.method_23598()
				.method_34578(new class_5942(CoreShaders::halo))
				.method_34577(class_4668.field_21376)
				.method_23615(field_21370)
				.method_23610(field_25643)
				.method_23617(true);
		LIGHT_RELAY = makeLayer(ResourcesLib.PREFIX_MOD + "light_relay", class_290.field_20887, class_293.class_5596.field_27382, 64, glState);

		glState = class_1921.class_4688.method_23598().method_34577(field_21376)
				.method_34578(field_29441)
				.method_23615(field_21370)
				.method_23610(field_25643)
				.method_23608(field_21383).method_23617(true);
		ICON_OVERLAY = makeLayer(ResourcesLib.PREFIX_MOD + "icon_overlay", class_290.field_20888, class_293.class_5596.field_27382, 128, glState);
		glState = class_1921.class_4688.method_23598().method_34577(field_21376)
				.method_34578(new class_5942(CoreShaders::manaPool))
				.method_23615(field_21370)
				.method_23610(field_25643)
				.method_23608(field_21383).method_23617(false);
		MANA_POOL_WATER = makeLayer(ResourcesLib.PREFIX_MOD + "mana_pool_water", class_290.field_20888, class_293.class_5596.field_27382, 128, glState);
		glState = class_1921.class_4688.method_23598().method_34577(field_21376)
				.method_34578(new class_5942(CoreShaders::terraPlate))
				.method_23615(field_21370)
				.method_23610(field_25643)
				.method_23608(field_21383).method_23617(false);
		TERRA_PLATE = makeLayer(ResourcesLib.PREFIX_MOD + "terra_plate_rune", class_290.field_20888, class_293.class_5596.field_27382, 128, glState);
		glState = class_1921.class_4688.method_23598().method_34577(field_21376)
				.method_34578(new class_5942(CoreShaders::enchanter))
				.method_23615(field_21370)
				.method_23610(field_25643)
				.method_23608(field_21383).method_23617(false);
		ENCHANTER = makeLayer(ResourcesLib.PREFIX_MOD + "enchanter_rune", class_290.field_20888, class_293.class_5596.field_27382, 128, glState);

		class_4668.class_4683 babylonTexture = new class_4668.class_4683(new class_2960(ResourcesLib.MISC_BABYLON), false, true);
		glState = class_1921.class_4688.method_23598().method_34577(babylonTexture)
				.method_34578(new class_5942(CoreShaders::halo))
				.method_23615(field_21370)
				.method_23610(field_25643)
				.method_23603(field_21345)
				.method_23617(true);
		BABYLON_ICON = makeLayer(ResourcesLib.PREFIX_MOD + "babylon", class_290.field_20887, class_293.class_5596.field_27382, 64, glState);

		class_4668.class_4683 haloTexture = new class_4668.class_4683(FlugelTiaraItem.textureHalo, false, true);
		glState = class_1921.class_4688.method_23598().method_34577(haloTexture)
				.method_34578(new class_5942(CoreShaders::halo))
				.method_23615(field_21370)
				.method_23603(field_21345)
				.method_23617(true);
		HALO = makeLayer(ResourcesLib.PREFIX_MOD + "halo", class_290.field_20887, class_293.class_5596.field_27382, 64, glState);

		// [VanillaCopy] End portal, with own shader
		glState = class_1921.class_4688.method_23598()
				.method_34578(new class_5942(CoreShaders::starfield))
				.method_34577(class_4668.class_5940.method_34560()
						.method_34563(class_840.field_4406, false, false)
						.method_34563(class_840.field_4407, false, false).method_34562())
				.method_23617(false);
		STARFIELD = makeLayer(ResourcesLib.PREFIX_MOD + "starfield", class_290.field_1592, class_293.class_5596.field_27382, 256, false, false, glState);
		glState = class_1921.class_4688.method_23598()
				.method_34578(field_29442)
				.method_23615(field_21367)
				.method_23617(false);
		LIGHTNING = makeLayer(ResourcesLib.PREFIX_MOD + "lightning", class_290.field_1576, class_293.class_5596.field_27382, 256, false, true, glState);
	}

	private RenderHelper(String string, class_293 vertexFormat, class_293.class_5596 mode, int i, boolean bl, boolean bl2, Runnable runnable, Runnable runnable2) {
		super(string, vertexFormat, mode, i, bl, bl2, runnable, runnable2);
		throw new UnsupportedOperationException("Should not be instantiated");
	}

	private static class_1921 getPylonGlowDirect(String name, class_2960 texture) {
		return getPylonGlow(name, texture, true);
	}

	private static class_1921 getPylonGlow(String name, class_2960 texture) {
		return getPylonGlow(name, texture, false);
	}

	private static class_1921 getPylonGlow(String name, class_2960 texture, boolean direct) {
		class_1921.class_4688.class_4689 glState = class_1921.class_4688.method_23598()
				.method_34578(new class_5942(CoreShaders::pylon))
				.method_34577(new class_4668.class_4683(texture, false, false))
				.method_23615(field_21370)
				.method_23603(field_21345)
				.method_23608(field_21383)
				.method_23611(field_21385);
		if (!direct) {
			glState = glState.method_23610(class_4668.field_25643);
		}
		return makeLayer(ResourcesLib.PREFIX_MOD + name, class_290.field_1580, class_293.class_5596.field_27382, 128, glState.method_23617(false));
	}

	private static class_4688 lineState(double width, boolean direct, boolean noDepth) {
		// [VanillaCopy] vanilla LINES layer with line width defined (and optionally depth disabled)
		var builder = class_1921.class_4688.method_23598()
				.method_34578(field_29433)
				.method_23609(new class_4668.class_4677(OptionalDouble.of(width)))
				.method_23607(field_22241)
				.method_23615(field_21370)
				.method_23616(noDepth ? field_21350 : field_21349)
				.method_23603(field_21345);
		if (!direct) {
			builder = builder.method_23610(field_25643);
		}
		if (noDepth) {
			builder = builder.method_23604(field_21346);
		}
		return builder.method_23617(false);
	}

	public static class_1921 getHaloLayer(class_2960 texture) {
		class_1921.class_4688 glState = class_1921.class_4688.method_23598()
				.method_34578(class_4668.field_29439)
				.method_34577(new class_4668.class_4683(texture, true, false))
				.method_23603(new class_4668.class_4671(false))
				.method_23615(field_21370).method_23617(false);
		return makeLayer(ResourcesLib.PREFIX_MOD + "crafting_halo", class_290.field_20887, class_293.class_5596.field_27382, 64, false, true, glState);
	}

	private static final Function<class_2960, class_1921> DOPPLEGANGER = class_156.method_34866(texture -> {
		// [VanillaCopy] entity_translucent, with own shader
		class_4688 glState = class_1921.class_4688.method_23598()
				.method_34578(new class_5942(CoreShaders::doppleganger))
				.method_34577(new class_4668.class_4683(texture, false, false))
				.method_23615(field_21370)
				.method_23603(field_21345)
				.method_23608(field_21383)
				.method_23611(field_21385)
				.method_23617(true);
		return makeLayer(ResourcesLib.PREFIX_MOD + "doppleganger", class_290.field_1580, class_293.class_5596.field_27382, 256, true, true, glState);
	});

	public static class_1921 getDopplegangerLayer(class_2960 texture) {
		return DOPPLEGANGER.apply(texture);
	}

	public static void drawTexturedModalRect(class_4587 ms, int x, int y, int u, int v, int width, int height) {
		class_332.method_25290(ms, x, y, u, v, width, height, 256, 256);
	}

	public static void renderStar(class_4587 ms, class_4597 buffers, int color, float xScale, float yScale, float zScale, long seed) {
		class_4588 buffer = buffers.getBuffer(STAR);

		float ticks = ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks;
		float semiPeriodTicks = 200;
		float f1 = class_3532.method_15379(class_3532.method_15374((float) Math.PI / semiPeriodTicks * ticks))
				* 0.9F + 0.1F; // shift to [0.1, 1.0]

		float f2 = f1 > 0.F ? (f1 - 0.7F) / 0.2F : 0;
		Random random = new Random(seed);

		ms.method_22903();
		ms.method_22905(xScale, yScale, zScale);

		for (int i = 0; i < (f1 + f1 * f1) / 2F * 90F + 30F; i++) {
			ms.method_22907(class_1160.field_20703.method_23214(random.nextFloat() * 360F));
			ms.method_22907(class_1160.field_20705.method_23214(random.nextFloat() * 360F));
			ms.method_22907(class_1160.field_20707.method_23214(random.nextFloat() * 360F));
			ms.method_22907(class_1160.field_20703.method_23214(random.nextFloat() * 360F));
			ms.method_22907(class_1160.field_20705.method_23214(random.nextFloat() * 360F));
			ms.method_22907(class_1160.field_20707.method_23214(random.nextFloat() * 360F + f1 * 90F));
			float f3 = random.nextFloat() * 20F + 5F + f2 * 10F;
			float f4 = random.nextFloat() * 2F + 1F + f2 * 2F;
			float r = ((color & 0xFF0000) >> 16) / 255F;
			float g = ((color & 0xFF00) >> 8) / 255F;
			float b = (color & 0xFF) / 255F;
			class_1159 mat = ms.method_23760().method_23761();
			Runnable center = () -> buffer.method_22918(mat, 0, 0, 0).method_22915(r, g, b, f1).method_1344();
			Runnable[] vertices = {
					() -> buffer.method_22918(mat, -0.866F * f4, f3, -0.5F * f4).method_1336(0, 0, 0, 0).method_1344(),
					() -> buffer.method_22918(mat, 0.866F * f4, f3, -0.5F * f4).method_1336(0, 0, 0, 0).method_1344(),
					() -> buffer.method_22918(mat, 0, f3, 1F * f4).method_1336(0, 0, 0, 0).method_1344(),
					() -> buffer.method_22918(mat, -0.866F * f4, f3, -0.5F * f4).method_1336(0, 0, 0, 0).method_1344()
			};
			triangleFan(center, vertices);
		}

		ms.method_22909();
	}

	public static void triangleFan(Runnable center, Runnable... vertices) {
		triangleFan(center, Arrays.asList(vertices));
	}

	/**
	 * With a buffer in GL_TRIANGLES mode, emulates GL_TRIANGLE_FAN on the CPU.
	 * This is because batching of GL_TRIANGLE_FAN makes no sense (the vertices would bleed into one massive fan)
	 */
	public static void triangleFan(Runnable center, List<Runnable> vertices) {
		for (int i = 0; i < vertices.size() - 1; i++) {
			center.run();
			vertices.get(i).run();
			vertices.get(i + 1).run();
		}
	}

	public static void renderProgressPie(class_4587 ms, int x, int y, float progress, class_1799 stack) {
		class_310 mc = class_310.method_1551();
		mc.method_1480().method_4023(stack, x, y);

		RenderSystem.clear(GL11.GL_DEPTH_BUFFER_BIT, true);
		GL11.glEnable(GL11.GL_STENCIL_TEST);
		RenderSystem.colorMask(false, false, false, false);
		RenderSystem.depthMask(false);
		RenderSystem.stencilFunc(GL11.GL_NEVER, 1, 0xFF);
		RenderSystem.stencilOp(GL11.GL_REPLACE, GL11.GL_KEEP, GL11.GL_KEEP);
		RenderSystem.stencilMask(0xFF);
		mc.method_1480().method_4023(stack, x, y);

		int r = 10;
		int centerX = x + 8;
		int centerY = y + 8;
		int degs = (int) (360 * progress);
		float a = 0.5F + 0.2F * ((float) Math.cos((double) (ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) / 10) * 0.5F + 0.5F);

		RenderSystem.disableTexture();
		RenderSystem.enableBlend();
		RenderSystem.blendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		RenderSystem.colorMask(true, true, true, true);
		RenderSystem.depthMask(true);
		RenderSystem.stencilMask(0x00);
		RenderSystem.stencilFunc(GL11.GL_EQUAL, 1, 0xFF);

		class_1159 mat = ms.method_23760().method_23761();
		class_287 buf = class_289.method_1348().method_1349();
		RenderSystem.setShader(class_757::method_34540);
		buf.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
		buf.method_22918(mat, centerX, centerY, 0).method_22915(0, 0.5F, 0.5F, a).method_1344();

		for (int i = degs; i > 0; i--) {
			float rad = (i - 90) / 180F * (float) Math.PI;
			buf.method_22918(mat, centerX + class_3532.method_15362(rad) * r, centerY + class_3532.method_15374(rad) * r, 0).method_22915(0F, 1F, 0.5F, a).method_1344();
		}

		buf.method_22918(mat, centerX, centerY, 0).method_22915(0F, 1F, 0.5F, a).method_1344();
		class_289.method_1348().method_1350();

		RenderSystem.disableBlend();
		RenderSystem.enableTexture();
		GL11.glDisable(GL11.GL_STENCIL_TEST);
	}

	/**
	 * @param color Must include alpha
	 */
	// [VanillaCopy] ItemRenderer.renderItem with simplifications + color support + custom model
	public static void renderItemCustomColor(class_1309 entity, class_1799 stack, int color, class_4587 ms, class_4597 buffers, int light, int overlay, @Nullable class_1087 model) {
		ms.method_22903();
		if (model == null) {
			model = class_310.method_1551().method_1480().method_4019(stack, entity.field_6002, entity, entity.method_5628());
		}
		model.method_4709().method_3503(class_809.class_811.field_4315).method_23075(false, ms);
		ms.method_22904(-0.5D, -0.5D, -0.5D);

		if (!model.method_4713() && !stack.method_31574(class_1802.field_8547)) {
			class_1921 rendertype = class_4696.method_23678(stack, true);
			class_4588 ivertexbuilder = class_918.method_29711(buffers, rendertype, true, stack.method_7958());
			renderBakedItemModel(model, stack, color, light, overlay, ms, ivertexbuilder);
		} else {
			throw new IllegalArgumentException("Custom renderer items not supported");
		}

		ms.method_22909();
	}

	public static void renderItemCustomColor(class_1309 entity, class_1799 stack, int color, class_4587 ms, class_4597 buffers, int light, int overlay) {
		renderItemCustomColor(entity, stack, color, ms, buffers, light, overlay, null);
	}

	// [VanillaCopy] ItemRenderer with custom color
	private static void renderBakedItemModel(class_1087 model, class_1799 stack, int color, int light, int overlay, class_4587 ms, class_4588 buffer) {
		var random = class_5819.method_43047();
		long i = 42L;

		for (class_2350 direction : class_2350.values()) {
			random.method_43052(42L);
			renderBakedItemQuads(ms, buffer, color, model.method_4707(null, direction, random), stack, light, overlay);
		}

		random.method_43052(42L);
		renderBakedItemQuads(ms, buffer, color, model.method_4707(null, null, random), stack, light, overlay);
	}

	// Wraps ItemRenderer#renderQuadList for custom color support
	private static void renderBakedItemQuads(class_4587 ms, class_4588 buffer, int color, List<class_777> quads, class_1799 stack, int light, int overlay) {
		float a = ((color >> 24) & 0xFF) / 255.0F;
		float r = (float) (color >> 16 & 0xFF) / 255.0F;
		float g = (float) (color >> 8 & 0xFF) / 255.0F;
		float b = (float) (color & 0xFF) / 255.0F;

		buffer = new DelegatedVertexConsumer(buffer) {
			@Override
			public class_4588 method_22915(float red, float green, float blue, float alpha) {
				return super.method_22915(r, g, b, a);
			}
		};
		((ItemRendererAccessor) class_310.method_1551().method_1480())
				.callRenderQuadList(ms, buffer, quads, stack, light, overlay);
	}

	/**
	 * Draw an icon into the buffer, using the {@link RenderHelper#ICON_OVERLAY} vertex format
	 *
	 * @param startX   Start x position in blocks
	 * @param startY   Start position in blocks
	 * @param endX     End x position in blocks
	 * @param endY     End y position in blocks
	 *
	 * @param uvStartX UV start x position in "pixels" (1/16th sprite size)
	 * @param uvStartY UV start position in "pixels" (1/16th sprite size)
	 * @param uvEndX   UV end x position in "pixels" (1/16th sprite size)
	 * @param uvEndY   UV end y position in "pixels" (1/16th sprite size)
	 */
	public static void renderIconFullBright(
			class_4587 ms, class_4588 buffer,
			float startX, float startY, float endX, float endY,
			int uvStartX, int uvStartY, int uvEndX, int uvEndY,
			class_1058 icon, int color, float alpha, int light) {
		class_1159 mat = ms.method_23760().method_23761();
		float red = ((color >> 16) & 0xFF) / 255F;
		float green = ((color >> 8) & 0xFF) / 255F;
		float blue = (color & 0xFF) / 255F;

		buffer.method_22918(mat, startX, endY, 0).method_22915(red, green, blue, alpha).method_22913(icon.method_4580(uvStartX), icon.method_4570(uvEndY)).method_22916(light).method_1344();
		buffer.method_22918(mat, endX, endY, 0).method_22915(red, green, blue, alpha).method_22913(icon.method_4580(uvEndX), icon.method_4570(uvEndY)).method_22916(light).method_1344();
		buffer.method_22918(mat, endX, startY, 0).method_22915(red, green, blue, alpha).method_22913(icon.method_4580(uvEndX), icon.method_4570(uvStartY)).method_22916(light).method_1344();
		buffer.method_22918(mat, startX, startY, 0).method_22915(red, green, blue, alpha).method_22913(icon.method_4580(uvStartX), icon.method_4570(uvStartY)).method_22916(light).method_1344();
	}

	/**
	 * Draw an icon into the buffer, using the {@link RenderHelper#ICON_OVERLAY} vertex format
	 *
	 * @param uvStartX UV start x position in "pixels" (1/16th sprite size)
	 * @param uvStartY UV start position in "pixels" (1/16th sprite size)
	 * @param uvEndX   UV end x position in "pixels" (1/16th sprite size)
	 * @param uvEndY   UV end y position in "pixels" (1/16th sprite size)
	 */
	public static void renderIconCropped(
			class_4587 ms, class_4588 buffer,
			int uvStartX, int uvStartY, int uvEndX, int uvEndY,
			class_1058 icon, int color, float alpha, int light) {
		renderIconFullBright(
				ms, buffer,
				uvStartX / 16F, uvStartY / 16F, uvEndX / 16F, uvEndY / 16F,
				uvStartX, uvStartY, uvEndX, uvEndY,
				icon, color, alpha, light
		);
	}

	/**
	 * Draw an icon into the buffer, using the {@link RenderHelper#ICON_OVERLAY} vertex format
	 * Renders the icon at a 1 block size with a full 16x16 UV
	 */
	public static void renderIconFullBright(
			class_4587 ms, class_4588 buffer,
			class_1058 icon, int color, float alpha, int light) {
		renderIconCropped(
				ms, buffer,
				0, 0, 16, 16,
				icon, color, alpha, light
		);
	}

	/**
	 * Draw an icon into the buffer, using the {@link RenderHelper#ICON_OVERLAY} vertex format
	 * Renders the icon in fullbright, at a 1 block size with a full 16x16 UV
	 */
	public static void renderIconFullBright(
			class_4587 ms, class_4588 buffer,
			class_1058 icon, int color, float alpha) {
		int fullbright = 0xF000F0;
		renderIconFullBright(ms, buffer, icon, color, alpha, fullbright);
	}

	/**
	 * Draw an icon into the buffer, using the {@link RenderHelper#ICON_OVERLAY} vertex format
	 * Renders the icon in fullbright, with no color modification, at a 1 block size with a full 16x16 UV
	 */
	public static void renderIconFullBright(
			class_4587 ms, class_4588 buffer,
			class_1058 icon, float alpha) {
		renderIconFullBright(ms, buffer, icon, 0xFFFFFF, alpha);
	}

	private static class AstrolabeLayer extends class_1921 {
		public AstrolabeLayer() {
			super(ResourcesLib.PREFIX_MOD + "astrolabe", class_290.field_1580, class_293.class_5596.field_27382, 256, true, true,
					() -> {
						class_4722.method_24076().method_23516();
						RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 0.4F);
					}, () -> {
						class_4722.method_24076().method_23518();
					});
		}
	}
}
