/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.core.helper;

import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.util.function.Consumer;
import net.minecraft.class_290;
import net.minecraft.class_3300;
import net.minecraft.class_5944;

public class CoreShaders {
	private static class_5944 starfieldShaderInstance;
	private static class_5944 doppleganger;
	private static class_5944 manaPool;
	private static class_5944 terraPlate;
	private static class_5944 enchanter;
	private static class_5944 pylon;
	private static class_5944 halo;
	private static class_5944 filmGrainParticle;
	private static class_5944 dopplegangerBar;

	public static void init(class_3300 resourceManager,
			Consumer<Pair<class_5944, Consumer<class_5944>>> registrations) throws IOException {
		registrations.accept(Pair.of(
				new class_5944(resourceManager, "botania__starfield", class_290.field_1592),
				inst -> starfieldShaderInstance = inst)
		);
		registrations.accept(Pair.of(
				new class_5944(resourceManager, "botania__doppleganger", class_290.field_1580),
				inst -> doppleganger = inst)
		);
		registrations.accept(Pair.of(
				new class_5944(resourceManager, "botania__mana_pool", class_290.field_20888),
				inst -> manaPool = inst)
		);
		registrations.accept(Pair.of(
				new class_5944(resourceManager, "botania__terra_plate_rune", class_290.field_20888),
				inst -> terraPlate = inst)
		);
		registrations.accept(Pair.of(
				new class_5944(resourceManager, "botania__enchanter_rune", class_290.field_20888),
				inst -> enchanter = inst)
		);
		registrations.accept(Pair.of(
				new class_5944(resourceManager, "botania__pylon", class_290.field_1580),
				inst -> pylon = inst)
		);
		registrations.accept(Pair.of(
				new class_5944(resourceManager, "botania__halo", class_290.field_20887),
				inst -> halo = inst)
		);
		registrations.accept(Pair.of(
				new class_5944(resourceManager, "botania__film_grain_particle", class_290.field_1584),
				inst -> filmGrainParticle = inst)
		);
		registrations.accept(Pair.of(
				new class_5944(resourceManager, "botania__doppleganger_bar", class_290.field_1585),
				inst -> dopplegangerBar = inst
		));
	}

	public static class_5944 starfield() {
		return starfieldShaderInstance;
	}

	public static class_5944 doppleganger() {
		return doppleganger;
	}

	public static class_5944 manaPool() {
		return manaPool;
	}

	public static class_5944 terraPlate() {
		return terraPlate;
	}

	public static class_5944 enchanter() {
		return enchanter;
	}

	public static class_5944 pylon() {
		return pylon;
	}

	public static class_5944 halo() {
		return halo;
	}

	public static class_5944 filmGrainParticle() {
		return filmGrainParticle;
	}

	public static class_5944 dopplegangerBar() {
		return dopplegangerBar;
	}
}
