/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.core.handler;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block.FloatingFlower;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.client.model.ManaBlasterModel;
import vazkii.botania.client.model.TinyPotatoModel;
import vazkii.botania.client.render.block_entity.CorporeaCrystalCubeBlockEntityRenderer;
import vazkii.botania.client.render.block_entity.ManaPumpBlockEntityRenderer;
import vazkii.botania.common.item.equipment.bauble.FlugelTiaraItem;
import vazkii.botania.common.item.relic.KeyOfTheKingsLawItem;
import vazkii.botania.common.lib.LibMisc;
import vazkii.botania.mixin.client.ModelBakeryAccessor;
import vazkii.botania.xplat.ClientXplatAbstractions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1723;
import net.minecraft.class_1767;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4730;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class MiscellaneousModels {
	public static final MiscellaneousModels INSTANCE = new MiscellaneousModels();

	public boolean registeredModels = false;
	public final class_4730 alfPortalTex = mainAtlas("block/alfheim_portal_swirl");
	public final class_4730 lightRelayWorldIcon = mainAtlas("block/light_relay");
	public final class_4730 lightRelayDetectorWorldIcon = mainAtlas("block/detector_light_relay");
	public final class_4730 lightRelayForkWorldIcon = mainAtlas("block/fork_light_relay");
	public final class_4730 lightRelayToggleWorldIcon = mainAtlas("block/toggle_light_relay");
	public final class_4730 alchemyCatalystOverlay = mainAtlas("block/alchemy_catalyst_overlay");
	public final class_4730 conjurationCatalystOverlay = mainAtlas("block/conjuration_catalyst_overlay");
	public final class_4730 enchanterOverlay = mainAtlas("block/enchanter_overlay");
	public final class_4730 manaVoidOverlay = mainAtlas("block/mana_void_overlay");
	public final class_4730 manaWater = mainAtlas("block/mana_water");
	public final class_4730 terraPlateOverlay = mainAtlas("block/terra_plate_overlay");
	public final class_4730 corporeaWorldIcon = mainAtlas("item/corporea_spark");
	public final class_4730 corporeaWorldIconMaster = mainAtlas("item/corporea_spark_master");
	public final class_4730 corporeaWorldIconCreative = mainAtlas("item/corporea_spark_creative");
	public final class_4730 corporeaIconStar = mainAtlas("item/corporea_spark_star");
	public final class_4730 sparkWorldIcon = mainAtlas("item/spark");

	public final class_4730[] sparkUpgradeIcons = new class_4730[] {
			mainAtlas("item/spark_upgrade_rune_dispersive"),
			mainAtlas("item/spark_upgrade_rune_dominant"),
			mainAtlas("item/spark_upgrade_rune_recessive"),
			mainAtlas("item/spark_upgrade_rune_isolated")
	};
	public final class_1087[] tiaraWingIcons = new class_1087[FlugelTiaraItem.WING_TYPES];
	public final class_1087[] thirdEyeLayers = new class_1087[3];

	public class_1087 goldfishModel,
			phiFlowerModel,
			nerfBatModel,
			bloodPendantChain,
			bloodPendantGem,
			snowflakePendantGem,
			itemFinderGem,
			pyroclastGem,
			crimsonGem,
			cirrusGem,
			nimbusGem,
			terrasteelHelmWillModel,
			elvenSpreaderCore,
			gaiaSpreaderCore,
			manaSpreaderCore,
			redstoneSpreaderCore,
			manaSpreaderScaffolding,
			elvenSpreaderScaffolding,
			gaiaSpreaderScaffolding;

	public final HashMap<class_1767, class_1087> spreaderPaddings = new HashMap<>();

	public final class_1087[] kingKeyWeaponModels = new class_1087[KeyOfTheKingsLawItem.WEAPON_TYPES];

	public void onModelRegister(class_3300 rm, Consumer<class_2960> consumer) {
		Set<class_4730> materials = ModelBakeryAccessor.getMaterials();

		materials.addAll(Arrays.asList(alfPortalTex, lightRelayWorldIcon, lightRelayDetectorWorldIcon,
				lightRelayForkWorldIcon, lightRelayToggleWorldIcon, alchemyCatalystOverlay, conjurationCatalystOverlay,
				enchanterOverlay, manaVoidOverlay, manaWater, terraPlateOverlay, corporeaWorldIcon, corporeaWorldIconMaster,
				corporeaWorldIconCreative, corporeaIconStar, sparkWorldIcon));
		materials.addAll(Arrays.asList(sparkUpgradeIcons));
		materials.add(RenderLexicon.TEXTURE);
		materials.add(RenderLexicon.ELVEN_TEXTURE);
		consumer.accept(prefix("icon/goldfish"));
		consumer.accept(prefix("icon/phiflower"));
		consumer.accept(prefix("icon/nerfbat"));
		consumer.accept(prefix("icon/blood_pendant_chain"));
		consumer.accept(prefix("icon/blood_pendant_gem"));
		for (int i = 0; i < KeyOfTheKingsLawItem.WEAPON_TYPES; i++) {
			consumer.accept(prefix("icon/gate_weapon_" + i));
		}
		consumer.accept(prefix("icon/will_flame"));
		for (int i = 0; i < thirdEyeLayers.length; i++) {
			consumer.accept(prefix("icon/third_eye_" + i));
		}
		consumer.accept(prefix("icon/lava_pendant_gem"));
		consumer.accept(prefix("icon/super_lava_pendant_gem"));
		consumer.accept(prefix("icon/itemfinder_gem"));
		consumer.accept(prefix("icon/cloud_pendant_gem"));
		consumer.accept(prefix("icon/super_cloud_pendant_gem"));
		consumer.accept(prefix("icon/ice_pendant_gem"));
		for (int i = 0; i < tiaraWingIcons.length; i++) {
			consumer.accept(prefix("icon/tiara_wing_" + (i + 1)));
		}

		consumer.accept(new class_1091(LibMisc.MOD_ID + ":mana_gun_clip", "inventory"));
		consumer.accept(new class_1091(LibMisc.MOD_ID + ":desu_gun", "inventory"));
		consumer.accept(new class_1091(LibMisc.MOD_ID + ":desu_gun_clip", "inventory"));
		consumer.accept(prefix("block/corporea_crystal_cube_glass"));
		consumer.accept(prefix("block/pump_head"));
		consumer.accept(prefix("block/elven_spreader_core"));
		consumer.accept(prefix("block/gaia_spreader_core"));
		consumer.accept(prefix("block/mana_spreader_core"));
		consumer.accept(prefix("block/redstone_spreader_core"));
		consumer.accept(prefix("block/mana_spreader_scaffolding"));
		consumer.accept(prefix("block/elven_spreader_scaffolding"));
		consumer.accept(prefix("block/gaia_spreader_scaffolding"));
		for (class_1767 color : class_1767.values()) {
			consumer.accept(prefix("block/" + color.toString() + "_spreader_padding"));
		}

		registerIslands();
		registerTaters(rm, consumer);

		if (!registeredModels) {
			registeredModels = true;
		}
	}

	private static void registerIslands() {
		BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.GRASS, prefix("block/islands/island_grass"));
		BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.PODZOL, prefix("block/islands/island_podzol"));
		BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.MYCEL, prefix("block/islands/island_mycel"));
		BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.SNOW, prefix("block/islands/island_snow"));
		BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.DRY, prefix("block/islands/island_dry"));
		BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.GOLDEN, prefix("block/islands/island_golden"));
		BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.VIVID, prefix("block/islands/island_vivid"));
		BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.SCORCHED, prefix("block/islands/island_scorched"));
		BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.INFUSED, prefix("block/islands/island_infused"));
		BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.MUTATED, prefix("block/islands/island_mutated"));
	}

	private static void registerTaters(class_3300 rm, Consumer<class_2960> consumer) {
		for (class_2960 model : rm.method_14488(ResourcesLib.PREFIX_MODELS + ResourcesLib.PREFIX_TINY_POTATO, s -> s.method_12832().endsWith(ResourcesLib.ENDING_JSON)).keySet()) {
			if (LibMisc.MOD_ID.equals(model.method_12836())) {
				String path = model.method_12832();
				path = path.substring(ResourcesLib.PREFIX_MODELS.length(), path.length() - ResourcesLib.ENDING_JSON.length());
				consumer.accept(new class_2960(LibMisc.MOD_ID, path));
			}
		}
	}

	public void onModelBake(class_1088 loader, Map<class_2960, class_1087> map) {
		if (!registeredModels) {
			BotaniaAPI.LOGGER.error("Additional models failed to register! Aborting baking models to avoid early crashing.");
			return;
		}
		// Platforms
		class_1091 abstruseName = new class_1091("botania:abstruse_platform", "");
		class_1087 abstruse = map.get(abstruseName);
		class_1091 spectralName = new class_1091("botania:spectral_platform", "");
		class_1087 spectral = map.get(spectralName);
		class_1091 infrangibleName = new class_1091("botania:infrangible_platform", "");
		class_1087 infrangible = map.get(infrangibleName);

		map.put(abstruseName, ClientXplatAbstractions.INSTANCE.wrapPlatformModel(abstruse));
		map.put(spectralName, ClientXplatAbstractions.INSTANCE.wrapPlatformModel(spectral));
		map.put(infrangibleName, ClientXplatAbstractions.INSTANCE.wrapPlatformModel(infrangible));

		// Mana Blaster
		class_1091 key = new class_1091("botania:mana_gun", "inventory");
		class_1087 originalModel = map.get(key);
		class_1091 clipKey = new class_1091("botania:mana_gun_clip", "inventory");
		class_1087 originalModelClip = map.get(clipKey);
		map.put(key, new ManaBlasterModel(loader, originalModel, originalModelClip));

		// Tiny Potato
		class_1091 tinyPotato = new class_1091("botania:tiny_potato", "inventory");
		class_1087 originalPotato = map.get(tinyPotato);
		map.put(tinyPotato, new TinyPotatoModel(originalPotato));

		CorporeaCrystalCubeBlockEntityRenderer.cubeModel = map.get(prefix("block/corporea_crystal_cube_glass"));
		ManaPumpBlockEntityRenderer.headModel = map.get(prefix("block/pump_head"));

		// Spreader cores, paddings and scaffoldings
		elvenSpreaderCore = map.get(prefix("block/elven_spreader_core"));
		gaiaSpreaderCore = map.get(prefix("block/gaia_spreader_core"));
		manaSpreaderCore = map.get(prefix("block/mana_spreader_core"));
		redstoneSpreaderCore = map.get(prefix("block/redstone_spreader_core"));
		manaSpreaderScaffolding = map.get(prefix("block/mana_spreader_scaffolding"));
		elvenSpreaderScaffolding = map.get(prefix("block/elven_spreader_scaffolding"));
		gaiaSpreaderScaffolding = map.get(prefix("block/gaia_spreader_scaffolding"));
		for (class_1767 color : class_1767.values()) {
			spreaderPaddings.put(color, map.get(prefix("block/" + color.method_7792() + "_spreader_padding")));
		}

		// Icons
		goldfishModel = map.get(prefix("icon/goldfish"));
		phiFlowerModel = map.get(prefix("icon/phiflower"));
		nerfBatModel = map.get(prefix("icon/nerfbat"));
		bloodPendantChain = map.get(prefix("icon/blood_pendant_chain"));
		bloodPendantGem = map.get(prefix("icon/blood_pendant_gem"));
		for (int i = 0; i < KeyOfTheKingsLawItem.WEAPON_TYPES; i++) {
			kingKeyWeaponModels[i] = map.get(prefix("icon/gate_weapon_" + i));
		}
		terrasteelHelmWillModel = map.get(prefix("icon/will_flame"));
		for (int i = 0; i < thirdEyeLayers.length; i++) {
			thirdEyeLayers[i] = map.get(prefix("icon/third_eye_" + i));
		}
		pyroclastGem = map.get(prefix("icon/lava_pendant_gem"));
		crimsonGem = map.get(prefix("icon/super_lava_pendant_gem"));
		itemFinderGem = map.get(prefix("icon/itemfinder_gem"));

		cirrusGem = map.get(prefix("icon/cloud_pendant_gem"));
		nimbusGem = map.get(prefix("icon/super_cloud_pendant_gem"));
		snowflakePendantGem = map.get(prefix("icon/ice_pendant_gem"));
		for (int i = 0; i < tiaraWingIcons.length; i++) {
			tiaraWingIcons[i] = map.get(prefix("icon/tiara_wing_" + (i + 1)));
		}
	}

	private static class_4730 mainAtlas(String name) {
		return new class_4730(class_1723.field_21668, prefix(name));
	}

	private MiscellaneousModels() {}
}
