/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.core.handler;

import vazkii.botania.client.core.RecipeBookAccess;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.common.block.block_entity.corporea.CorporeaIndexBlockEntity;
import vazkii.botania.mixin.client.AbstractContainerScreenAccessor;
import vazkii.botania.mixin.client.RecipeBookComponentAccessor;
import vazkii.botania.mixin.client.RecipeBookPageAccessor;
import vazkii.botania.network.serverbound.IndexKeybindRequestPacket;
import vazkii.botania.xplat.ClientXplatAbstractions;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_507;
import net.minecraft.class_513;
import net.minecraft.class_514;
import net.minecraft.class_518;

public class CorporeaInputHandler {

	public static Supplier<class_1799> hoveredStackGetter = () -> class_1799.field_8037;
	public static Predicate<class_437> supportedGuiFilter = gui -> gui instanceof class_465;

	public static boolean buttonPressed(int keyCode, int scanCode) {
		class_310 mc = class_310.method_1551();

		if (mc.field_1687 == null || !supportedGuiFilter.test(mc.field_1755)
				|| !ClientProxy.CORPOREA_REQUEST.method_1417(keyCode, scanCode)
				|| CorporeaIndexBlockEntity.getNearbyValidIndexes(mc.field_1724).isEmpty()) {
			return false;
		}

		class_1799 stack = getStackUnderMouse();
		if (stack != null && !stack.method_7960()) {
			int count = 1;
			int max = stack.method_7914();

			if (class_437.method_25442()) {
				count = max;
				if (class_437.method_25441()) {
					count /= 4;
				}
			} else if (class_437.method_25441()) {
				count = max / 2;
			}

			if (count > 0) {
				class_1799 requested = stack.method_7972();
				requested.method_7939(count);
				ClientXplatAbstractions.INSTANCE.sendToServer(new IndexKeybindRequestPacket(requested));
				return true;
			}
		}
		return false;
	}

	private static class_1799 getStackUnderMouse() {
		class_437 screen = class_310.method_1551().field_1755;
		if (screen instanceof class_465) {
			class_1735 slotUnderMouse = ((AbstractContainerScreenAccessor) screen).getHoveredSlot();
			if (slotUnderMouse != null && slotUnderMouse.method_7681()) {
				return slotUnderMouse.method_7677().method_7972();
			}

			if (screen instanceof class_518 recipeScreen && recipeScreen.method_2659().method_2605()) {
				class_507 recipeBook = recipeScreen.method_2659();
				class_513 page = ((RecipeBookComponentAccessor) recipeBook).getRecipesArea();
				class_514 widget = ((RecipeBookPageAccessor) page).getHoveredButton();
				if (widget != null) {
					return widget.method_2643().method_8110();
				}
				class_1799 stack = ((RecipeBookAccess) recipeBook).getHoveredGhostRecipeStack();
				if (stack != null) {
					return stack;
				}
			}
		}

		return hoveredStackGetter.get();
	}
}
