/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.recipe;

import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2158;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.BotaniaAPI;

public interface OrechidRecipe extends class_1860<class_1263> {
	class_2960 TYPE_ID = new class_2960(BotaniaAPI.MODID, "orechid");
	class_2960 IGNEM_TYPE_ID = new class_2960(BotaniaAPI.MODID, "orechid_ignem");
	class_2960 MARIMORPHOSIS_TYPE_ID = new class_2960(BotaniaAPI.MODID, "marimorphosis");

	/** Valid inputs for the recipe */
	StateIngredient getInput();

	/** Output to display in recipes and to be used by default. */
	StateIngredient getOutput();

	/** Location-sensitive output, called with the position of the block to convert. */
	default StateIngredient getOutput(@NotNull class_1937 level, @NotNull class_2338 pos) {
		return getOutput();
	}

	/**
	 * Default weight, used if no special weight logic is provided, and to display
	 * in recipes (the JEI/REI displayed output per 64 input depends on the sum of default weights).
	 */
	int getWeight();

	/** Location-sensitive weight, called with the position of the block to convert. */
	default int getWeight(@NotNull class_1937 level, @NotNull class_2338 pos) {
		return getWeight();
	}

	class_2158.class_2159 getSuccessFunction();

	@Override
	default boolean method_8115(class_1263 c, class_1937 l) {
		return false;
	}

	@Override
	default class_1799 method_8116(class_1263 c) {
		return class_1799.field_8037;
	}

	@Override
	default boolean method_8113(int width, int height) {
		return false;
	}

	@Override
	default class_1799 method_8110() {
		return class_1799.field_8037;
	}

	@Override
	default boolean method_8118() {
		return true;
	}
}
